.nolist

.cpu cortex-m0plus
.thumb

.equiv __CM0PLUS_REV,          0 /* Core Revision r0p0                           */
.equiv __MPU_PRESENT,          0 /* PY32F0xx do not provide MPU                  */
.equiv __VTOR_PRESENT,         1 /* Vector  Table  Register supported            */
.equiv __NVIC_PRIO_BITS,       2 /* PY32F0xx uses 2 Bits for the Priority Levels */
.equiv __Vendor_SysTickConfig, 0 /* Set to 1 if different SysTick Config is used */

/****** MEMORY SIZES **********************************************************/

.equiv FLASH_BASE,        0x08000000  /* FLASH base address */
.equiv FLASH_END,         0x08004FFF  /* FLASH end address */
.equiv FLASH_SIZE,        FLASH_END - FLASH_BASE + 1
.equiv FLASH_PAGE_SIZE,   0x00000080  /* FLASH Page Size, 128 Bytes */
.equiv FLASH_PAGE_NB,     FLASH_SIZE / FLASH_PAGE_SIZE
.equiv FLASH_SECTOR_SIZE, 0x00001000  /* FLASH Sector Size, 4096 Bytes */
.equiv FLASH_SECTOR_NB,   FLASH_SIZE / FLASH_SECTOR_SIZE
.equiv SRAM_BASE,         0x20000000  /* SRAM base address */
.equiv SRAM_END,          0x20000BFF  /* SRAM end address */
.equiv PERIPH_BASE,       0x40000000  /* Peripheral base address */
.equiv IOPORT_BASE,       0x50000000  /* IOPORT base address */
.equiv SCS_BASE,          0xE000E000  /* System Control Space Base Address */

.equiv APBPERIPH_BASE, PERIPH_BASE
.equiv AHBPERIPH_BASE, PERIPH_BASE + 0x00020000

.equiv OB_BASE,        0x1FFF0E80  /* FLASH Option Bytes base address */
.equiv FLASHSIZE_BASE, 0x1FFF0FFC  /* FLASH Size register base address */
.equiv UID_BASE,       0x1FFF0E00  /* Unique device ID register base address */

/******  Cortex-M0+ Processor Exceptions **************************************/
.equiv SP_Init,                  0x00  /*  0 Stack Pointer Initialization Value                 */
.equiv Reset_vect,               0x04  /*  1 Reset                                              */
.equiv NMI_vect,                 0x08  /*  2 Non Maskable Interrupt                             */
.equiv HardFault_vect,           0x0C  /*  3 Cortex-M Hard Fault Interrupt                      */
.equiv SVCall_vect,              0x2C  /* 11 Cortex-M SV Call Interrupt                         */
.equiv PendSV_vect,              0x38  /* 14 Cortex-M Pend SV Interrupt                         */
.equiv SysTick_vect,             0x3C  /* 15 Cortex-M System Tick Interrupt                     */
/******  PY32F0 specific Interrupts *******************************************/
.equiv FLASH_vect,               0x4C  /* FLASH global Interrupt                                */
.equiv RCC_vect,                 0x50  /* RCC global Interrupt                                  */
.equiv EXTI0_1_vect,             0x54  /* EXTI 0 and 1 Interrupts                               */
.equiv EXTI2_3_vect,             0x58  /* EXTI Line 2 and 3 Interrupts                          */
.equiv EXTI4_15_vect,            0x5C  /* EXTI Line 4 to 15 Interrupts                          */
.equiv ADC_COMP_vect,            0x70  /* ADC&COMP Interrupts                                   */
.equiv TIM1_BRK_UP_TRG_COM_vect, 0x74  /* TIM1 Break Update, Trigger and Commutation Interrupts */
.equiv TIM1_CC_vect,             0x78  /* TIM1 Capture Compare Interrupt                        */
.equiv LPTIM1_vect,              0x84  /* LPTIM1 global Interrupts                              */
.equiv TIM16_vect,               0x94  /* TIM16 global Interrupt                                */
.equiv I2C1_vect,                0x9C  /* I2C1 Interrupt  (combined with EXTI 23)               */
.equiv SPI1_vect,                0xA4  /* SPI1 Interrupt                                        */
.equiv USART1_vect,              0xAC  /* USART1 Interrupt                                      */

/****** Interrupt numbers *****************************************************/

.equiv NonMaskableInt_IRQn,     -14  /* 2 Non Maskable Interrupt                               */
.equiv HardFault_IRQn,          -13  /* 3 Cortex-M Hard Fault Interrupt                        */
.equiv SVC_IRQn,                 -5  /* 11 Cortex-M SV Call Interrupt                          */
.equiv PendSV_IRQn,              -2  /* 14 Cortex-M Pend SV Interrupt                          */
.equiv SysTick_IRQn,             -1  /* 15 Cortex-M System Tick Interrupt                      */
.equiv FLASH_IRQn,                3  /* FLASH global Interrupt                                 */
.equiv RCC_IRQn,                  4  /* RCC global Interrupt                                   */
.equiv EXTI0_1_IRQn,              5  /* EXTI 0 and 1 Interrupts                                */
.equiv EXTI2_3_IRQn,              6  /* EXTI Line 2 and 3 Interrupts                           */
.equiv EXTI4_15_IRQn,             7  /* EXTI Line 4 to 15 Interrupts                           */
.equiv ADC_COMP_IRQn,            12  /* ADC&COMP Interrupts                                    */
.equiv TIM1_BRK_UP_TRG_COM_IRQn, 13  /* TIM1 Break  Update  Trigger and Commutation Interrupts */
.equiv TIM1_CC_IRQn,             14  /* TIM1 Capture Compare Interrupt                         */
.equiv LPTIM1_IRQn,              17  /* LPTIM1 global Interrupts                               */
.equiv TIM16_IRQn,               21  /* TIM16 global Interrupt                                 */
.equiv I2C1_IRQn,                23  /* I2C1 Interrupt  (combined with EXTI 23)                */
.equiv SPI1_IRQn,                25  /* SPI1 Interrupt                                         */
.equiv USART1_IRQn,              27  /* USART1 Interrupt                                       */

/******  REGISTER OFFSETS *****************************************************/

// TODO
// #include "core_cm0plus.h"               /* Cortex-M0+ processor and core peripherals */

.equiv ADC_ISR_offset,     0x00  /* ADC interrupt and status register             */
.equiv ADC_IER_offset,     0x04  /* ADC interrupt enable register                 */
.equiv ADC_CR_offset,      0x08  /* ADC control register                          */
.equiv ADC_CFGR1_offset,   0x0C  /* ADC configuration register 1                  */
.equiv ADC_CFGR2_offset,   0x10  /* ADC configuration register 2                  */
.equiv ADC_SMPR_offset,    0x14  /* ADC sampling time register                    */
.equiv ADC_TR_offset,      0x20  /* ADC analog watchdog 1 threshold register      */
.equiv ADC_CHSELR_offset,  0x28  /* ADC group regular sequencer register          */
.equiv ADC_DR_offset,      0x40  /* ADC group regular data register               */
.equiv ADC_CCSR_offset,    0x44  /* ADC calibration configuration&status register */

.equiv ADC_CCR_offset,     0x00  /* ADC common configuration register             */

.equiv COMP_CSR_offset, 0x00  /* COMP control and status register */
.equiv COMP_FR_offset,  0x04  /* COMP filter register             */

.equiv DBGMCU_IDCODE_offset, 0x00  /* MC device ID code            */
.equiv DBGMCU_CR_offset,     0x04  /* Debug configuration register */
.equiv DBGMCU_APBFZ1_offset, 0x08  /* Debug APB freeze register 1  */
.equiv DBGMCU_APBFZ2_offset, 0x0C  /* Debug APB freeze register 2  */

.equiv EXTI_RTSR_offset,    0x00  /* EXTI Rising Trigger Selection Register 1       */
.equiv EXTI_FTSR_offset,    0x04  /* EXTI Falling Trigger Selection Register 1      */
.equiv EXTI_SWIER_offset,   0x08  /* EXTI Software Interrupt event Register 1       */
.equiv EXTI_PR_offset,      0x0C  /* EXTI Pending Register 1                        */
.equiv EXTI_EXTICR1_offset, 0x60  /* EXTI External Interrupt Configuration Register */
.equiv EXTI_EXTICR2_offset, 0x64  /* EXTI External Interrupt Configuration Register */
.equiv EXTI_EXTICR3_offset, 0x68  /* EXTI External Interrupt Configuration Register */
.equiv EXTI_IMR_offset,     0x80  /* EXTI Interrupt Mask Register                   */
.equiv EXTI_EMR_offset,     0x84  /* EXTI Event Mask Register                       */

.equiv FLASH_ACR_offset,      0x00  /* FLASH Access Control register    */
.equiv FLASH_KEYR_offset,     0x08  /* FLASH Key register               */
.equiv FLASH_OPTKEYR_offset,  0x0C  /* FLASH Option Key register        */
.equiv FLASH_SR_offset,       0x10  /* FLASH Status register            */
.equiv FLASH_CR_offset,       0x14  /* FLASH Control register           */
.equiv FLASH_OPTR_offset,     0x20  /* FLASH Option register            */
.equiv FLASH_SDKR_offset,     0x24  /* FLASH SDK address register       */
.equiv FLASH_WRPR_offset,     0x2C  /* FLASH WRP address register       */
.equiv FLASH_STCR_offset,     0x90  /* FLASH sleep time config register */
.equiv FLASH_TS0_offset,     0x100  /* FLASH TS0 register               */
.equiv FLASH_TS1_offset,     0x104  /* FLASH TS1 register               */
.equiv FLASH_TS2P_offset,    0x108  /* FLASH TS2P register              */
.equiv FLASH_TPS3_offset,    0x10C  /* FLASH TPS3 register              */
.equiv FLASH_TS3_offset,     0x110  /* FLASH TS3 register               */
.equiv FLASH_PERTPE_offset,  0x114  /* FLASH PERTPE register            */
.equiv FLASH_SMERTPE_offset, 0x118  /* FLASH SMERTPE register           */
.equiv FLASH_PRGTPE_offset,  0x11C  /* FLASH PRGTPE register            */
.equiv FLASH_PRETPE_offset,  0x120  /* FLASH PRETPE register            */

.equiv OB_FLASH_USER_offset, 0x00  /* OPTION BYTE Flash User Option       */
.equiv OB_FLASH_SDK_offset,  0x04  /* OPTION BYTE Flash SDK Area address  */
.equiv OB_FLASH_WRP_offset,  0x0C  /* OPTION BYTE Flash Flash WRP address */

.equiv GPIO_MODER_offset,   0x00  /* GPIO port mode register               */
.equiv GPIO_OTYPER_offset,  0x04  /* GPIO port output type register        */
.equiv GPIO_OSPEEDR_offset, 0x08  /* GPIO port output speed register       */
.equiv GPIO_PUPDR_offset,   0x0C  /* GPIO port pull-up/pull-down register  */
.equiv GPIO_IDR_offset,     0x10  /* GPIO port input data register         */
.equiv GPIO_ODR_offset,     0x14  /* GPIO port output data register        */
.equiv GPIO_BSRR_offset,    0x18  /* GPIO port bit set/reset  register     */
.equiv GPIO_LCKR_offset,    0x1C  /* GPIO port configuration lock register */
.equiv GPIO_AFRL_offset,    0x20  /* GPIO alternate function registers     */
.equiv GPIO_AFRH_offset,    0x24  /* GPIO alternate function registers     */
.equiv GPIO_BRR_offset,     0x28  /* GPIO Bit Reset register               */

.equiv I2C_CR1_offset,   0x00
.equiv I2C_CR2_offset,   0x04
.equiv I2C_OAR1_offset,  0x08
.equiv I2C_OAR2_offset,  0x0C
.equiv I2C_DR_offset,    0x10
.equiv I2C_SR1_offset,   0x14
.equiv I2C_SR2_offset,   0x18
.equiv I2C_CCR_offset,   0x1C
.equiv I2C_TRISE_offset, 0x20

.equiv IWDG_KR_offset,   0x00  /* IWDG Key register       */
.equiv IWDG_PR_offset,   0x04  /* IWDG Prescaler register */
.equiv IWDG_RLR_offset,  0x08  /* IWDG Reload register    */
.equiv IWDG_SR_offset,   0x0C  /* IWDG Status register    */
//.equiv IWDG_WINR_offset, 0x10  /* IWDG Window register    */

.equiv LPTIM_ISR_offset,       0x00  /* LPTIM Interrupt and Status register */
.equiv LPTIM_ICR_offset,       0x04  /* LPTIM Interrupt Clear register      */
.equiv LPTIM_IER_offset,       0x08  /* LPTIM Interrupt Enable register     */
.equiv LPTIM_CFGR_offset,      0x0C  /* LPTIM Configuration register        */
.equiv LPTIM_CR_offset,        0x10  /* LPTIM Control register              */
.equiv LPTIM_ARR_offset,       0x18  /* LPTIM Autoreload register           */
.equiv LPTIM_CNT_offset,       0x1C  /* LPTIM Counter register              */

.equiv PWR_CR1_offset, 0x00  /* PWR Power Control Register 1 */
.equiv PWR_CR2_offset, 0x04  /* PWR Power Control Register 2 */
.equiv PWR_SR_offset,  0x14  /* PWR Power Status Register    */

.equiv SPI_CR1_offset, 0x00  /* SPI Control register 1 */
.equiv SPI_CR2_offset, 0x04  /* SPI Control register 2 */
.equiv SPI_SR_offset,  0x08  /* SPI Status register    */
.equiv SPI_DR_offset,  0x0C  /* SPI data register      */

.equiv SYSCFG_CFGR1_offset, 0x00 /* SYSCFG configuration register 1 */
.equiv SYSCFG_CFGR2_offset, 0x18 /* SYSCFG configuration register 2 */
.equiv SYSCFG_CFGR3_offset, 0x1C /* SYSCFG configuration register 3 */

.equiv TIM_CR1_offset,   0x00  /* TIM control register 1              */
.equiv TIM_CR2_offset,   0x04  /* TIM control register 2              */
.equiv TIM_SMCR_offset,  0x08  /* TIM slave mode control register     */
.equiv TIM_DIER_offset,  0x0C  /* TIM DMA/interrupt enable register   */
.equiv TIM_SR_offset,    0x10  /* TIM status register                 */
.equiv TIM_EGR_offset,   0x14  /* TIM event generation register       */
.equiv TIM_CCMR1_offset, 0x18  /* TIM capture/compare mode register 1 */
.equiv TIM_CCMR2_offset, 0x1C  /* TIM capture/compare mode register 2 */
.equiv TIM_CCER_offset,  0x20  /* TIM capture/compare enable register */
.equiv TIM_CNT_offset,   0x24  /* TIM counter register                */
.equiv TIM_PSC_offset,   0x28  /* TIM prescaler register              */
.equiv TIM_ARR_offset,   0x2C  /* TIM auto-reload register            */
.equiv TIM_RCR_offset,   0x30  /* TIM repetition counter register     */
.equiv TIM_CCR1_offset,  0x34  /* TIM capture/compare register 1      */
.equiv TIM_CCR2_offset,  0x38  /* TIM capture/compare register 2      */
.equiv TIM_CCR3_offset,  0x3C  /* TIM capture/compare register 3      */
.equiv TIM_CCR4_offset,  0x40  /* TIM capture/compare register 4      */
.equiv TIM_BDTR_offset,  0x44  /* TIM break and dead-time register    */
//.equiv TIM_OR_offset,    0x50  /* TIM option register                 */

.equiv USART_SR_offset,   0x00  /* USART Status register                   */
.equiv USART_DR_offset,   0x04  /* USART Data register                     */
.equiv USART_BRR_offset,  0x08  /* USART Baud rate register                */
.equiv USART_CR1_offset,  0x0C  /* USART Control  register 1               */
.equiv USART_CR2_offset,  0x10  /* USART Control  register 2               */
.equiv USART_CR3_offset,  0x14  /* USART Control  register 3               */
.equiv USART_GTPR_offset, 0x18  /* USART Guard time and prescaler register */

.equiv RCC_CR_offset,       0x00  /* RCC Clock Sources Control Register                        */
.equiv RCC_ICSCR_offset,    0x04  /* RCC Internal Clock Sources Calibration Register           */
.equiv RCC_CFGR_offset,     0x08  /* RCC Regulated Domain Clocks Configuration Register        */
.equiv RCC_ECSCR_offset,    0x10  /* RCC External clock source control register                */
.equiv RCC_CIER_offset,     0x18  /* RCC Clock Interrupt Enable Register                       */
.equiv RCC_CIFR_offset,     0x1C  /* RCC Clock Interrupt Flag Register                         */
.equiv RCC_CICR_offset,     0x20  /* RCC Clock Interrupt Clear Register                        */
.equiv RCC_IOPRSTR_offset,  0x24  /* RCC IO port reset register,                               */
.equiv RCC_AHBRSTR_offset,  0x28  /* RCC AHB peripherals reset register                        */
.equiv RCC_APBRSTR1_offset, 0x2C  /* RCC APB peripherals reset register 1                      */
.equiv RCC_APBRSTR2_offset, 0x30  /* RCC APB peripherals reset register 2                      */
.equiv RCC_IOPENR_offset,   0x34  /* RCC IO port enable register                               */
.equiv RCC_AHBENR_offset,   0x38  /* RCC AHB peripherals clock enable register                 */
.equiv RCC_APBENR1_offset,  0x3C  /* RCC APB peripherals clock enable register1                */
.equiv RCC_APBENR2_offset,  0x40  /* RCC APB peripherals clock enable register2                */
.equiv RCC_CCIPR_offset,    0x54  /* RCC Peripherals Independent Clocks Configuration Register */
.equiv RCC_BDCR_offset,     0x5C  /* BDCR                                                      */
.equiv RCC_CSR_offset,      0x60  /* RCC Unregulated Domain Clock Control and Status Register  */

.equiv CRC_DR_offset,  0x00
.equiv CRC_IDR_offset, 0x04
.equiv CRC_CR_offset,  0x08

.equiv NVIC_ISER_offset, 0x000  /* NVIC Interrupt Set Enable Register    */
.equiv NVIC_ICER_offset, 0x080  /* NVIC Interrupt Clear Enable Register  */
.equiv NVIC_ISPR_offset, 0x100  /* NVIC Interrupt Set Pending Register   */
.equiv NVIC_ICPR_offset, 0x180  /* NVIC Interrupt Clear Pending Register */
.equiv NVIC_IPR0_offset, 0x300  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR1_offset, 0x304  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR2_offset, 0x308  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR3_offset, 0x30C  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR4_offset, 0x310  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR5_offset, 0x314  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR6_offset, 0x318  /* NVIC Interrupt Priority Register      */
.equiv NVIC_IPR7_offset, 0x31C  /* NVIC Interrupt Priority Register      */

.equiv SCB_CPUID_offset, 0x00  /* CPUID Base Register                              */
.equiv SCB_ICSR_offset,  0x04  /* Interrupt Control and State Register             */
.equiv SCB_VTOR_offset,  0x08  /* Vector Table Offset Register                     */
.equiv SCB_AIRCR_offset, 0x0C  /* Application Interrupt and Reset Control Register */
.equiv SCB_SCR_offset,   0x10  /* System Control Register                          */
.equiv SCB_CCR_offset,   0x14  /* Configuration Control Register                   */
.equiv SCB_SHPR2_offset, 0x1C  /* System Handlers Priority Registers               */
.equiv SCB_SHPR3_offset, 0x20  /* System Handlers Priority Registers               */
.equiv SCB_SHCSR_offset, 0x24  /* System Handler Control and State                 */

.equiv SysTick_CTRL_offset,  0x00  /* SysTick Control and Status Register */
.equiv SysTick_LOAD_offset,  0x04  /* SysTick Reload Value Register       */
.equiv SysTick_VAL_offset,   0x08  /* SysTick Current Value Register      */
.equiv SysTick_CALIB_offset, 0x0C  /* SysTick Calibration Register        */

/****** APB peripherals *******************************************************/

.equiv IWDG_BASE, APBPERIPH_BASE + 0x00003000
.equiv IWDG_KR,   IWDG_BASE + IWDG_KR_offset
.equiv IWDG_PR,   IWDG_BASE + IWDG_PR_offset
.equiv IWDG_RLR,  IWDG_BASE + IWDG_RLR_offset
.equiv IWDG_SR,   IWDG_BASE + IWDG_SR_offset
//.equiv IWDG_WINR, IWDG_BASE + IWDG_WINR_offset

.equiv I2C_BASE,  APBPERIPH_BASE + 0x00005400
.equiv I2C_CR1,   I2C_BASE + I2C_CR1_offset
.equiv I2C_CR2,   I2C_BASE + I2C_CR2_offset
.equiv I2C_OAR1,  I2C_BASE + I2C_OAR1_offset
.equiv I2C_OAR2,  I2C_BASE + I2C_OAR2_offset
.equiv I2C_DR,    I2C_BASE + I2C_DR_offset
.equiv I2C_SR1,   I2C_BASE + I2C_SR1_offset
.equiv I2C_SR2,   I2C_BASE + I2C_SR2_offset
.equiv I2C_CCR,   I2C_BASE + I2C_CCR_offset
.equiv I2C_TRISE, I2C_BASE + I2C_TRISE_offset

.equiv PWR_BASE, APBPERIPH_BASE + 0x00007000
.equiv PWR_CR1,  PWR_BASE + PWR_CR1_offset
.equiv PWR_CR2,  PWR_BASE + PWR_CR2_offset
.equiv PWR_SR,   PWR_BASE + PWR_SR_offset

.equiv LPTIM_BASE, APBPERIPH_BASE + 0x00007C00
.equiv LPTIM_ISR,  LPTIM_BASE + LPTIM_ISR_offset
.equiv LPTIM_ICR,  LPTIM_BASE + LPTIM_ICR_offset
.equiv LPTIM_IER,  LPTIM_BASE + LPTIM_IER_offset
.equiv LPTIM_CFGR, LPTIM_BASE + LPTIM_CFGR_offset
.equiv LPTIM_CR,   LPTIM_BASE + LPTIM_CR_offset
.equiv LPTIM_ARR,  LPTIM_BASE + LPTIM_ARR_offset
.equiv LPTIM_CNT,  LPTIM_BASE + LPTIM_CNT_offset

.equiv SYSCFG_BASE,  APBPERIPH_BASE + 0x00010000
.equiv SYSCFG_CFGR1, SYSCFG_BASE + SYSCFG_CFGR1_offset
.equiv SYSCFG_CFGR2, SYSCFG_BASE + SYSCFG_CFGR2_offset
.equiv SYSCFG_CFGR3, SYSCFG_BASE + SYSCFG_CFGR3_offset

.equiv COMP1_BASE, APBPERIPH_BASE + 0x00010200
.equiv COMP1_CSR,  COMP1_BASE + COMP_CSR_offset
.equiv COMP1_FR,   COMP1_BASE + COMP_FR_offset

.equiv COMP2_BASE, APBPERIPH_BASE + 0x00010210
.equiv COMP2_CSR,  COMP2_BASE + COMP_CSR_offset
.equiv COMP2_FR,   COMP2_BASE + COMP_FR_offset

.equiv ADC1_BASE,   APBPERIPH_BASE + 0x00012400
.equiv ADC1_ISR,    ADC1_BASE + ADC_ISR_offset
.equiv ADC1_IER,    ADC1_BASE + ADC_IER_offset
.equiv ADC1_CR,     ADC1_BASE + ADC_CR_offset
.equiv ADC1_CFGR1,  ADC1_BASE + ADC_CFGR1_offset
.equiv ADC1_CFGR2,  ADC1_BASE + ADC_CFGR2_offset
.equiv ADC1_SMPR,   ADC1_BASE + ADC_SMPR_offset
.equiv ADC1_TR,     ADC1_BASE + ADC_TR_offset
.equiv ADC1_CHSELR, ADC1_BASE + ADC_CHSELR_offset
.equiv ADC1_DR,     ADC1_BASE + ADC_DR_offset
.equiv ADC1_CCSR,   ADC1_BASE + ADC_CCSR_offset

.equiv ADC_BASE, APBPERIPH_BASE + 0x00012708
.equiv ADC_CCR,  ADC_BASE + ADC_CCR_offset

.equiv TIM1_BASE,  APBPERIPH_BASE + 0x00012C00
.equiv TIM1_CR1,   TIM1_BASE + TIM_CR1_offset
.equiv TIM1_CR2,   TIM1_BASE + TIM_CR2_offset
.equiv TIM1_SMCR,  TIM1_BASE + TIM_SMCR_offset
.equiv TIM1_DIER,  TIM1_BASE + TIM_DIER_offset
.equiv TIM1_SR,    TIM1_BASE + TIM_SR_offset
.equiv TIM1_EGR,   TIM1_BASE + TIM_EGR_offset
.equiv TIM1_CCMR1, TIM1_BASE + TIM_CCMR1_offset
.equiv TIM1_CCMR2, TIM1_BASE + TIM_CCMR2_offset
.equiv TIM1_CCER,  TIM1_BASE + TIM_CCER_offset
.equiv TIM1_CNT,   TIM1_BASE + TIM_CNT_offset
.equiv TIM1_PSC,   TIM1_BASE + TIM_PSC_offset
.equiv TIM1_ARR,   TIM1_BASE + TIM_ARR_offset
.equiv TIM1_RCR,   TIM1_BASE + TIM_RCR_offset
.equiv TIM1_CCR1,  TIM1_BASE + TIM_CCR1_offset
.equiv TIM1_CCR2,  TIM1_BASE + TIM_CCR2_offset
.equiv TIM1_CCR3,  TIM1_BASE + TIM_CCR3_offset
.equiv TIM1_CCR4,  TIM1_BASE + TIM_CCR4_offset
.equiv TIM1_BDTR,  TIM1_BASE + TIM_BDTR_offset

.equiv SPI1_BASE, APBPERIPH_BASE + 0x00013000
.equiv SPI_CR1,   SPI1_BASE + SPI_CR1_offset
.equiv SPI_CR2,   SPI1_BASE + SPI_CR2_offset
.equiv SPI_SR,    SPI1_BASE + SPI_SR_offset
.equiv SPI_DR,    SPI1_BASE + SPI_DR_offset

.equiv USART1_BASE, APBPERIPH_BASE + 0x00013800
.equiv USART1_SR,   USART1_BASE + USART_SR_offset
.equiv USART1_DR,   USART1_BASE + USART_DR_offset
.equiv USART1_BRR,  USART1_BASE + USART_BRR_offset
.equiv USART1_CR1,  USART1_BASE + USART_CR1_offset
.equiv USART1_CR2,  USART1_BASE + USART_CR2_offset
.equiv USART1_CR3,  USART1_BASE + USART_CR3_offset
.equiv USART1_GTPR, USART1_BASE + USART_GTPR_offset

.equiv TIM16_BASE, APBPERIPH_BASE + 0x00014400
.equiv TIM16_CR1,  TIM16_BASE + TIM_CR1_offset
.equiv TIM16_DIER, TIM16_BASE + TIM_DIER_offset
.equiv TIM16_SR,   TIM16_BASE + TIM_SR_offset
.equiv TIM16_EGR,  TIM16_BASE + TIM_EGR_offset
.equiv TIM16_CNT,  TIM16_BASE + TIM_CNT_offset
.equiv TIM16_PSC,  TIM16_BASE + TIM_PSC_offset
.equiv TIM16_ARR,  TIM16_BASE + TIM_ARR_offset
.equiv TIM16_RCR,  TIM16_BASE + TIM_RCR_offset

.equiv DBGMCU_BASE,   APBPERIPH_BASE + 0x00015800
.equiv DBGMCU_IDCODE, DBGMCU_BASE + DBGMCU_IDCODE_offset
.equiv DBGMCU_CR,     DBGMCU_BASE + DBGMCU_CR_offset
.equiv DBGMCU_APBFZ1, DBGMCU_BASE + DBGMCU_APBFZ1_offset
.equiv DBGMCU_APBFZ2, DBGMCU_BASE + DBGMCU_APBFZ2_offset

/****** AHB peripherals *******************************************************/

.equiv RCC_BASE,     AHBPERIPH_BASE + 0x00001000
.equiv RCC_CR,       RCC_BASE + CR_offset
.equiv RCC_ICSCR,    RCC_BASE + ICSCR_offset
.equiv RCC_CFGR,     RCC_BASE + CFGR_offset
.equiv RCC_ECSCR,    RCC_BASE + ECSCR_offset
.equiv RCC_CIER,     RCC_BASE + CIER_offset
.equiv RCC_CIFR,     RCC_BASE + CIFR_offset
.equiv RCC_CICR,     RCC_BASE + CICR_offset
.equiv RCC_IOPRSTR,  RCC_BASE + IOPRSTR_offset
.equiv RCC_AHBRSTR,  RCC_BASE + AHBRSTR_offset
.equiv RCC_APBRSTR1, RCC_BASE + APBRSTR1_offset
.equiv RCC_APBRSTR2, RCC_BASE + APBRSTR2_offset
.equiv RCC_IOPENR,   RCC_BASE + IOPENR_offset
.equiv RCC_AHBENR,   RCC_BASE + AHBENR_offset
.equiv RCC_APBENR1,  RCC_BASE + APBENR1_offset
.equiv RCC_APBENR2,  RCC_BASE + APBENR2_offset
.equiv RCC_CCIPR,    RCC_BASE + CCIPR_offset
.equiv RCC_BDCR,     RCC_BASE + BDCR_offset
.equiv RCC_CSR,      RCC_BASE + CSR_offset

.equiv EXTI_BASE,    AHBPERIPH_BASE + 0x00001800
.equiv EXTI_RTSR,    EXTI_BASE + EXTI_RTSR_offset
.equiv EXTI_FTSR,    EXTI_BASE + EXTI_FTSR_offset
.equiv EXTI_SWIER,   EXTI_BASE + EXTI_SWIER_offset
.equiv EXTI_PR,      EXTI_BASE + EXTI_PR_offset
.equiv EXTI_EXTICR1, EXTI_BASE + EXTI_EXTICR1_offset
.equiv EXTI_EXTICR2, EXTI_BASE + EXTI_EXTICR2_offset
.equiv EXTI_EXTICR3, EXTI_BASE + EXTI_EXTICR3_offset
.equiv EXTI_IMR,     EXTI_BASE + EXTI_IMR_offset
.equiv EXTI_EMR,     EXTI_BASE + EXTI_EMR_offset

.equiv FLASH_R_BASE,  AHBPERIPH_BASE + 0x00002000
.equiv FLASH_ACR,     FLASH_R_BASE + FLASH_ACR_offset
.equiv FLASH_KEYR,    FLASH_R_BASE + FLASH_KEYR_offset
.equiv FLASH_OPTKEYR, FLASH_R_BASE + FLASH_OPTKEYR_offset
.equiv FLASH_SR,      FLASH_R_BASE + FLASH_SR_offset
.equiv FLASH_CR,      FLASH_R_BASE + FLASH_CR_offset
.equiv FLASH_OPTR,    FLASH_R_BASE + FLASH_OPTR_offset
.equiv FLASH_SDKR,    FLASH_R_BASE + FLASH_SDKR_offset
.equiv FLASH_WRPR,    FLASH_R_BASE + FLASH_WRPR_offset
.equiv FLASH_STCR,    FLASH_R_BASE + FLASH_STCR_offset
.equiv FLASH_TS0,     FLASH_R_BASE + FLASH_TS0_offset
.equiv FLASH_TS1,     FLASH_R_BASE + FLASH_TS1_offset
.equiv FLASH_TS2P,    FLASH_R_BASE + FLASH_TS2P_offset
.equiv FLASH_TPS3,    FLASH_R_BASE + FLASH_TPS3_offset
.equiv FLASH_TS3,     FLASH_R_BASE + FLASH_TS3_offset
.equiv FLASH_PERTPE,  FLASH_R_BASE + FLASH_PERTPE_offset
.equiv FLASH_SMERTPE, FLASH_R_BASE + FLASH_SMERTPE_offset
.equiv FLASH_PRGTPE,  FLASH_R_BASE + FLASH_PRGTPE_offset
.equiv FLASH_PRETPE,  FLASH_R_BASE + FLASH_PRETPE_offset

.equiv CRC_BASE, AHBPERIPH_BASE + 0x00003000
.equiv CRC_DR,   CRC_BASE + CRC_DR_offset
.equiv CRC_IDR,  CRC_BASE + CRC_IDR_offset
.equiv CRC_CR,   CRC_BASE + CRC_CR_offset

/****** IOPORT ****************************************************************/

.equiv GPIOA_BASE,    IOPORT_BASE + 0x00000000
.equiv GPIOA_MODER,   GPIOA_BASE + GPIO_MODER_offset
.equiv GPIOA_OTYPER,  GPIOA_BASE + GPIO_OTYPER_offset
.equiv GPIOA_OSPEEDR, GPIOA_BASE + GPIO_OSPEEDR_offset
.equiv GPIOA_PUPDR,   GPIOA_BASE + GPIO_PUPDR_offset
.equiv GPIOA_IDR,     GPIOA_BASE + GPIO_IDR_offset
.equiv GPIOA_ODR,     GPIOA_BASE + GPIO_ODR_offset
.equiv GPIOA_BSRR,    GPIOA_BASE + GPIO_BSRR_offset
.equiv GPIOA_LCKR,    GPIOA_BASE + GPIO_LCKR_offset
.equiv GPIOA_AFR0,    GPIOA_BASE + GPIO_AFR0_offset
.equiv GPIOA_AFR1,    GPIOA_BASE + GPIO_AFR1_offset
.equiv GPIOA_BRR,     GPIOA_BASE + GPIO_BRR_offset

.equiv GPIOB_BASE,    IOPORT_BASE + 0x00000400
.equiv GPIOB_MODER,   GPIOB_BASE + GPIO_MODER_offset
.equiv GPIOB_OTYPER,  GPIOB_BASE + GPIO_OTYPER_offset
.equiv GPIOB_OSPEEDR, GPIOB_BASE + GPIO_OSPEEDR_offset
.equiv GPIOB_PUPDR,   GPIOB_BASE + GPIO_PUPDR_offset
.equiv GPIOB_IDR,     GPIOB_BASE + GPIO_IDR_offset
.equiv GPIOB_ODR,     GPIOB_BASE + GPIO_ODR_offset
.equiv GPIOB_BSRR,    GPIOB_BASE + GPIO_BSRR_offset
.equiv GPIOB_LCKR,    GPIOB_BASE + GPIO_LCKR_offset
.equiv GPIOB_AFR0,    GPIOB_BASE + GPIO_AFR0_offset
.equiv GPIOB_AFR1,    GPIOB_BASE + GPIO_AFR1_offset
.equiv GPIOB_BRR,     GPIOB_BASE + GPIO_BRR_offset

.equiv GPIOF_BASE,    IOPORT_BASE + 0x00001400
.equiv GPIOF_MODER,   GPIOF_BASE + GPIO_MODER_offset
.equiv GPIOF_OTYPER,  GPIOF_BASE + GPIO_OTYPER_offset
.equiv GPIOF_OSPEEDR, GPIOF_BASE + GPIO_OSPEEDR_offset
.equiv GPIOF_PUPDR,   GPIOF_BASE + GPIO_PUPDR_offset
.equiv GPIOF_IDR,     GPIOF_BASE + GPIO_IDR_offset
.equiv GPIOF_ODR,     GPIOF_BASE + GPIO_ODR_offset
.equiv GPIOF_BSRR,    GPIOF_BASE + GPIO_BSRR_offset
.equiv GPIOF_LCKR,    GPIOF_BASE + GPIO_LCKR_offset
.equiv GPIOF_AFR0,    GPIOF_BASE + GPIO_AFR0_offset
.equiv GPIOF_AFR1,    GPIOF_BASE + GPIO_AFR1_offset
.equiv GPIOF_BRR,     GPIOF_BASE + GPIO_BRR_offset

/****** Cortex M0+ Peripherals ************************************************/

.equiv SysTick_BASE, SCS_BASE + 0x00000010 /* SysTick Base Address */
.equiv SysTick_CTRL,  SysTick_BASE + SysTick_CTRL_offset
.equiv SysTick_LOAD,  SysTick_BASE + SysTick_LOAD_offset
.equiv SysTick_VAL,   SysTick_BASE + SysTick_VAL_offset
.equiv SysTick_CALIB, SysTick_BASE + SysTick_CALIB_offset

.equiv NVIC_BASE, SCS_BASE + 0x00000100 /* NVIC Base Address */
.equiv NVIC_CTRL,  NVIC_BASE + NVIC_CTRL_offset
.equiv NVIC_LOAD,  NVIC_BASE + NVIC_LOAD_offset
.equiv NVIC_VAL,   NVIC_BASE + NVIC_VAL_offset
.equiv NVIC_CALIB, NVIC_BASE + NVIC_CALIB_offset

.equiv SCB_BASE, SCS_BASE + 0x00000D00 /* System Control Block Base Address */
.equiv SCB_CPUID, SCB_BASE + SCB_CPUID_offset
.equiv SCB_ICSR,  SCB_BASE + SCB_ICSR_offset
.equiv SCB_VTOR,  SCB_BASE + SCB_VTOR_offset
.equiv SCB_AIRCR, SCB_BASE + SCB_AIRCR_offset
.equiv SCB_SCR,   SCB_BASE + SCB_SCR_offset
.equiv SCB_CCR,   SCB_BASE + SCB_CCR_offset
.equiv SCB_SHPR2, SCB_BASE + SCB_SHPR2_offset
.equiv SCB_SHPR3, SCB_BASE + SCB_SHPR3_offset
.equiv SCB_SHCSR, SCB_BASE + SCB_SHCSR_offset

/******************************************************************************/
/*                         Peripheral Registers Bits Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                      Analog to Digital Converter (ADC)                     */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for ADC_ISR register  ******************/
.equiv ADC_ISR_EOSMP_Pos, (1)
.equiv ADC_ISR_EOSMP_Msk, (0x1 << ADC_ISR_EOSMP_Pos) /* 0x00000002 */
.equiv ADC_ISR_EOSMP,     ADC_ISR_EOSMP_Msk          /* ADC group regular end of sampling flag */
.equiv ADC_ISR_EOC_Pos,   (2)
.equiv ADC_ISR_EOC_Msk,   (0x1 << ADC_ISR_EOC_Pos)   /* 0x00000004 */
.equiv ADC_ISR_EOC,       ADC_ISR_EOC_Msk            /* ADC group regular end of unitary conversion flag */
.equiv ADC_ISR_EOSEQ_Pos, (3)
.equiv ADC_ISR_EOSEQ_Msk, (0x1 << ADC_ISR_EOSEQ_Pos) /* 0x00000008 */
.equiv ADC_ISR_EOSEQ,     ADC_ISR_EOSEQ_Msk          /* ADC group regular end of sequence conversions flag */
.equiv ADC_ISR_OVR_Pos,   (4)
.equiv ADC_ISR_OVR_Msk,   (0x1 << ADC_ISR_OVR_Pos)   /* 0x00000010 */
.equiv ADC_ISR_OVR,       ADC_ISR_OVR_Msk            /* ADC group regular overrun flag */
.equiv ADC_ISR_AWD_Pos,   (7)
.equiv ADC_ISR_AWD_Msk,   (0x1 << ADC_ISR_AWD_Pos)   /* 0x00000080 */
.equiv ADC_ISR_AWD,        ADC_ISR_AWD_Msk           /* ADC analog watchdog 1 flag */

/********************  Bits definition for ADC_IER register  ******************/
.equiv ADC_IER_EOSMPIE_Pos, (1)
.equiv ADC_IER_EOSMPIE_Msk, (0x1 << ADC_IER_EOSMPIE_Pos) /* 0x00000002 */
.equiv ADC_IER_EOSMPIE,     ADC_IER_EOSMPIE_Msk          /* ADC group regular end of sampling interrupt */
.equiv ADC_IER_EOCIE_Pos,   (2)
.equiv ADC_IER_EOCIE_Msk,   (0x1 << ADC_IER_EOCIE_Pos)   /* 0x00000004 */
.equiv ADC_IER_EOCIE,       ADC_IER_EOCIE_Msk            /* ADC group regular end of unitary conversion interrupt */
.equiv ADC_IER_EOSEQIE_Pos, (3)
.equiv ADC_IER_EOSEQIE_Msk, (0x1 << ADC_IER_EOSEQIE_Pos) /* 0x00000008 */
.equiv ADC_IER_EOSEQIE,     ADC_IER_EOSEQIE_Msk          /* ADC group regular end of sequence conversions interrupt */
.equiv ADC_IER_OVRIE_Pos,   (4)
.equiv ADC_IER_OVRIE_Msk,   (0x1 << ADC_IER_OVRIE_Pos)   /* 0x00000010 */
.equiv ADC_IER_OVRIE,       ADC_IER_OVRIE_Msk            /* ADC group regular overrun interrupt */
.equiv ADC_IER_AWDIE_Pos,   (7)
.equiv ADC_IER_AWDIE_Msk,   (0x1 << ADC_IER_AWDIE_Pos)   /* 0x00000080 */
.equiv ADC_IER_AWDIE,       ADC_IER_AWDIE_Msk            /* ADC analog watchdog 1 interrupt */

/********************  Bits definition for ADC_CR register  *******************/
.equiv ADC_CR_ADEN_Pos,    (0)
.equiv ADC_CR_ADEN_Msk,    (0x1 << ADC_CR_ADEN_Pos)    /* 0x00000001 */
.equiv ADC_CR_ADEN,        ADC_CR_ADEN_Msk             /* ADC enable */
.equiv ADC_CR_ADSTART_Pos, (2)
.equiv ADC_CR_ADSTART_Msk, (0x1 << ADC_CR_ADSTART_Pos) /* 0x00000004 */
.equiv ADC_CR_ADSTART,     ADC_CR_ADSTART_Msk          /* ADC group regular conversion start */
.equiv ADC_CR_ADSTP_Pos,   (4)
.equiv ADC_CR_ADSTP_Msk,   (0x1 << ADC_CR_ADSTP_Pos)   /* 0x00000010 */
.equiv ADC_CR_ADSTP,       ADC_CR_ADSTP_Msk            /* ADC group regular conversion stop */
.equiv ADC_CR_ADCAL_Pos,   (31)
.equiv ADC_CR_ADCAL_Msk,   (0x1 << ADC_CR_ADCAL_Pos)   /* 0x80000000 */
.equiv ADC_CR_ADCAL,       ADC_CR_ADCAL_Msk            /* ADC calibration */

/*******************  Bits definition for ADC_CFGR1 register  *****************/
.equiv ADC_CFGR1_SCANDIR_Pos, (2)
.equiv ADC_CFGR1_SCANDIR_Msk, (0x1 << ADC_CFGR1_SCANDIR_Pos) /* 0x00000004 */
.equiv ADC_CFGR1_SCANDIR,      ADC_CFGR1_SCANDIR_Msk         /* ADC group regular sequencer scan direction */
.equiv ADC_CFGR1_RESSEL_Pos,  (3)
.equiv ADC_CFGR1_RESSEL_Msk,  (0x3 << ADC_CFGR1_RESSEL_Pos)  /* 0x00000018 */
.equiv ADC_CFGR1_RESSEL,       ADC_CFGR1_RESSEL_Msk          /* ADC data resolution */
.equiv ADC_CFGR1_RESSEL_0,    (0x1 << ADC_CFGR1_RESSEL_Pos)  /* 0x00000008 */
.equiv ADC_CFGR1_RESSEL_1,    (0x2 << ADC_CFGR1_RESSEL_Pos)  /* 0x00000010 */
.equiv ADC_CFGR1_ALIGN_Pos,   (5)
.equiv ADC_CFGR1_ALIGN_Msk,   (0x1 << ADC_CFGR1_ALIGN_Pos)   /* 0x00000020 */
.equiv ADC_CFGR1_ALIGN,        ADC_CFGR1_ALIGN_Msk           /* ADC data alignement */
.equiv ADC_CFGR1_EXTSEL_Pos,  (6)
.equiv ADC_CFGR1_EXTSEL_Msk,  (0x7 << ADC_CFGR1_EXTSEL_Pos)  /* 0x000001C0 */
.equiv ADC_CFGR1_EXTSEL,       ADC_CFGR1_EXTSEL_Msk          /* ADC group regular external trigger source */
.equiv ADC_CFGR1_EXTSEL_0,    (0x1 << ADC_CFGR1_EXTSEL_Pos)  /* 0x00000040 */
.equiv ADC_CFGR1_EXTSEL_1,    (0x2 << ADC_CFGR1_EXTSEL_Pos)  /* 0x00000080 */
.equiv ADC_CFGR1_EXTSEL_2,    (0x4 << ADC_CFGR1_EXTSEL_Pos)  /* 0x00000100 */
.equiv ADC_CFGR1_EXTEN_Pos,   (10)
.equiv ADC_CFGR1_EXTEN_Msk,   (0x3 << ADC_CFGR1_EXTEN_Pos)   /* 0x00000C00 */
.equiv ADC_CFGR1_EXTEN,        ADC_CFGR1_EXTEN_Msk           /* ADC group regular external trigger polarity */
.equiv ADC_CFGR1_EXTEN_0,     (0x1 << ADC_CFGR1_EXTEN_Pos)   /* 0x00000400 */
.equiv ADC_CFGR1_EXTEN_1,     (0x2 << ADC_CFGR1_EXTEN_Pos)   /* 0x00000800 */
.equiv ADC_CFGR1_OVRMOD_Pos,  (12)
.equiv ADC_CFGR1_OVRMOD_Msk,  (0x1 << ADC_CFGR1_OVRMOD_Pos)  /* 0x00001000 */
.equiv ADC_CFGR1_OVRMOD,       ADC_CFGR1_OVRMOD_Msk          /* ADC group regular overrun configuration */
.equiv ADC_CFGR1_CONT_Pos,    (13)
.equiv ADC_CFGR1_CONT_Msk,    (0x1 << ADC_CFGR1_CONT_Pos)    /* 0x00002000 */
.equiv ADC_CFGR1_CONT,         ADC_CFGR1_CONT_Msk            /* ADC group regular continuous conversion mode */
.equiv ADC_CFGR1_WAIT_Pos,    (14)
.equiv ADC_CFGR1_WAIT_Msk,    (0x1 << ADC_CFGR1_WAIT_Pos)    /* 0x00004000 */
.equiv ADC_CFGR1_WAIT,         ADC_CFGR1_WAIT_Msk            /* ADC low power auto wait */
.equiv ADC_CFGR1_DISCEN_Pos,  (16)
.equiv ADC_CFGR1_DISCEN_Msk,  (0x1 << ADC_CFGR1_DISCEN_Pos)  /* 0x00010000 */
.equiv ADC_CFGR1_DISCEN,       ADC_CFGR1_DISCEN_Msk          /* ADC group regular sequencer discontinuous mode */
.equiv ADC_CFGR1_AWDSGL_Pos,  (22)
.equiv ADC_CFGR1_AWDSGL_Msk,  (0x1 << ADC_CFGR1_AWDSGL_Pos)  /* 0x00400000 */
.equiv ADC_CFGR1_AWDSGL,       ADC_CFGR1_AWDSGL_Msk          /* ADC analog watchdog 1 monitoring a single channel or all channels */
.equiv ADC_CFGR1_AWDEN_Pos,   (23)
.equiv ADC_CFGR1_AWDEN_Msk,   (0x1 << ADC_CFGR1_AWDEN_Pos)   /* 0x00800000 */
.equiv ADC_CFGR1_AWDEN,        ADC_CFGR1_AWDEN_Msk           /* ADC analog watchdog 1 enable on scope ADC group regular */
.equiv ADC_CFGR1_AWDCH_Pos,   (26)
.equiv ADC_CFGR1_AWDCH_Msk,   (0xF << ADC_CFGR1_AWDCH_Pos)   /* 0x2C000000 */
.equiv ADC_CFGR1_AWDCH,        ADC_CFGR1_AWDCH_Msk           /* ADC analog watchdog 1 monitored channel selection */
.equiv ADC_CFGR1_AWDCH_0,     (0x01 << ADC_CFGR1_AWDCH_Pos)  /* 0x04000000 */
.equiv ADC_CFGR1_AWDCH_1,     (0x02 << ADC_CFGR1_AWDCH_Pos)  /* 0x08000000 */
.equiv ADC_CFGR1_AWDCH_2,     (0x04 << ADC_CFGR1_AWDCH_Pos)  /* 0x10000000 */
.equiv ADC_CFGR1_AWDCH_3,     (0x08 << ADC_CFGR1_AWDCH_Pos)  /* 0x20000000 */

/*******************  Bits definition for ADC_CFGR2 register  *****************/
.equiv ADC_CFGR2_CKMODE_Pos, (28)
.equiv ADC_CFGR2_CKMODE_Msk, (0xF << ADC_CFGR2_CKMODE_Pos) /* 0xC0000000 */
.equiv ADC_CFGR2_CKMODE,      ADC_CFGR2_CKMODE_Msk         /* ADC clock source and prescaler (prescaler only for clock source synchronous) */
.equiv ADC_CFGR2_CKMODE_0,   (0x1 << ADC_CFGR2_CKMODE_Pos) /* 0x10000000 */
.equiv ADC_CFGR2_CKMODE_1,   (0x2 << ADC_CFGR2_CKMODE_Pos) /* 0x20000000 */
.equiv ADC_CFGR2_CKMODE_2,   (0x4 << ADC_CFGR2_CKMODE_Pos) /* 0x40000000 */
.equiv ADC_CFGR2_CKMODE_3,   (0x8 << ADC_CFGR2_CKMODE_Pos) /* 0x80000000 */

/******************  Bit definition for ADC_SMPR register  ********************/
.equiv ADC_SMPR_SMP_Pos, (0)
.equiv ADC_SMPR_SMP_Msk, (0x7 << ADC_SMPR_SMP_Pos) /* 0x00000007 */
.equiv ADC_SMPR_SMP,      ADC_SMPR_SMP_Msk         /* ADC group of channels sampling time 2 */
.equiv ADC_SMPR_SMP_0,   (0x1 << ADC_SMPR_SMP_Pos) /* 0x00000001 */
.equiv ADC_SMPR_SMP_1,   (0x2 << ADC_SMPR_SMP_Pos) /* 0x00000002 */
.equiv ADC_SMPR_SMP_2,   (0x4 << ADC_SMPR_SMP_Pos) /* 0x00000004 */

/*******************  Bit definition for ADC_TR register  ********************/
.equiv ADC_TR_LT_Pos, (0)
.equiv ADC_TR_LT_Msk, (0xFFF << ADC_TR_LT_Pos) /* 0x00000FFF */
.equiv ADC_TR_LT,      ADC_TR_LT_Msk           /* ADC analog watchdog 1 threshold low */
.equiv ADC_TR_LT_0,   (0x001 << ADC_TR_LT_Pos) /* 0x00000001 */
.equiv ADC_TR_LT_1,   (0x002 << ADC_TR_LT_Pos) /* 0x00000002 */
.equiv ADC_TR_LT_2,   (0x004 << ADC_TR_LT_Pos) /* 0x00000004 */
.equiv ADC_TR_LT_3,   (0x008 << ADC_TR_LT_Pos) /* 0x00000008 */
.equiv ADC_TR_LT_4,   (0x010 << ADC_TR_LT_Pos) /* 0x00000010 */
.equiv ADC_TR_LT_5,   (0x020 << ADC_TR_LT_Pos) /* 0x00000020 */
.equiv ADC_TR_LT_6,   (0x040 << ADC_TR_LT_Pos) /* 0x00000040 */
.equiv ADC_TR_LT_7,   (0x080 << ADC_TR_LT_Pos) /* 0x00000080 */
.equiv ADC_TR_LT_8,   (0x100 << ADC_TR_LT_Pos) /* 0x00000100 */
.equiv ADC_TR_LT_9,   (0x200 << ADC_TR_LT_Pos) /* 0x00000200 */
.equiv ADC_TR_LT_10,  (0x400 << ADC_TR_LT_Pos) /* 0x00000400 */
.equiv ADC_TR_LT_11,  (0x800 << ADC_TR_LT_Pos) /* 0x00000800 */
.equiv ADC_TR_HT_Pos, (16)
.equiv ADC_TR_HT_Msk, (0xFFF << ADC_TR_HT_Pos) /* 0x0FFF0000 */
.equiv ADC_TR_HT,      ADC_TR_HT_Msk           /* ADC Analog watchdog 1 threshold high */
.equiv ADC_TR_HT_0,   (0x001 << ADC_TR_HT_Pos) /* 0x00010000 */
.equiv ADC_TR_HT_1,   (0x002 << ADC_TR_HT_Pos) /* 0x00020000 */
.equiv ADC_TR_HT_2,   (0x004 << ADC_TR_HT_Pos) /* 0x00040000 */
.equiv ADC_TR_HT_3,   (0x008 << ADC_TR_HT_Pos) /* 0x00080000 */
.equiv ADC_TR_HT_4,   (0x010 << ADC_TR_HT_Pos) /* 0x00100000 */
.equiv ADC_TR_HT_5,   (0x020 << ADC_TR_HT_Pos) /* 0x00200000 */
.equiv ADC_TR_HT_6,   (0x040 << ADC_TR_HT_Pos) /* 0x00400000 */
.equiv ADC_TR_HT_7,   (0x080 << ADC_TR_HT_Pos) /* 0x00800000 */
.equiv ADC_TR_HT_8,   (0x100 << ADC_TR_HT_Pos) /* 0x01000000 */
.equiv ADC_TR_HT_9,   (0x200 << ADC_TR_HT_Pos) /* 0x02000000 */
.equiv ADC_TR_HT_10,  (0x400 << ADC_TR_HT_Pos) /* 0x04000000 */
.equiv ADC_TR_HT_11,  (0x800 << ADC_TR_HT_Pos) /* 0x08000000 */

/******************  Bit definition for ADC_CHSELR register  ******************/
.equiv ADC_CHSELR_CHSEL_Pos,   (0)
.equiv ADC_CHSELR_CHSEL_Msk,   (0x1BFF << ADC_CHSELR_CHSEL_Pos) /* 0x00001BFF */
.equiv ADC_CHSELR_CHSEL,        ADC_CHSELR_CHSEL_Msk            /* ADC group regular sequencer channels, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL12_Pos, (12)
.equiv ADC_CHSELR_CHSEL12_Msk, (0x1 << ADC_CHSELR_CHSEL12_Pos)  /* 0x00001000 */
.equiv ADC_CHSELR_CHSEL12,      ADC_CHSELR_CHSEL12_Msk          /* ADC group regular sequencer channel 12, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL11_Pos, (11)
.equiv ADC_CHSELR_CHSEL11_Msk, (0x1 << ADC_CHSELR_CHSEL11_Pos)  /* 0x00000800 */
.equiv ADC_CHSELR_CHSEL11,      ADC_CHSELR_CHSEL11_Msk          /* ADC group regular sequencer channel 11, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL9_Pos,  (9)
.equiv ADC_CHSELR_CHSEL9_Msk,  (0x1 << ADC_CHSELR_CHSEL9_Pos)   /* 0x00000200 */
.equiv ADC_CHSELR_CHSEL9,       ADC_CHSELR_CHSEL9_Msk           /* ADC group regular sequencer channel 9, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL8_Pos,  (8)
.equiv ADC_CHSELR_CHSEL8_Msk,  (0x1 << ADC_CHSELR_CHSEL8_Pos)   /* 0x00000100 */
.equiv ADC_CHSELR_CHSEL8,       ADC_CHSELR_CHSEL8_Msk           /* ADC group regular sequencer channel 8, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL7_Pos,  (7)
.equiv ADC_CHSELR_CHSEL7_Msk,  (0x1 << ADC_CHSELR_CHSEL7_Pos)   /* 0x00000080 */
.equiv ADC_CHSELR_CHSEL7,       ADC_CHSELR_CHSEL7_Msk           /* ADC group regular sequencer channel 7, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL6_Pos,  (6)
.equiv ADC_CHSELR_CHSEL6_Msk,  (0x1 << ADC_CHSELR_CHSEL6_Pos)   /* 0x00000040 */
.equiv ADC_CHSELR_CHSEL6,       ADC_CHSELR_CHSEL6_Msk           /* ADC group regular sequencer channel 6, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL5_Pos,  (5)
.equiv ADC_CHSELR_CHSEL5_Msk,  (0x1 << ADC_CHSELR_CHSEL5_Pos)   /* 0x00000020 */
.equiv ADC_CHSELR_CHSEL5,       ADC_CHSELR_CHSEL5_Msk           /* ADC group regular sequencer channel 5, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL4_Pos,  (4)
.equiv ADC_CHSELR_CHSEL4_Msk,  (0x1 << ADC_CHSELR_CHSEL4_Pos)   /* 0x00000010 */
.equiv ADC_CHSELR_CHSEL4,       ADC_CHSELR_CHSEL4_Msk           /* ADC group regular sequencer channel 4, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL3_Pos,  (3)
.equiv ADC_CHSELR_CHSEL3_Msk,  (0x1 << ADC_CHSELR_CHSEL3_Pos)   /* 0x00000008 */
.equiv ADC_CHSELR_CHSEL3,       ADC_CHSELR_CHSEL3_Msk           /* ADC group regular sequencer channel 3, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL2_Pos,  (2)
.equiv ADC_CHSELR_CHSEL2_Msk,  (0x1 << ADC_CHSELR_CHSEL2_Pos)   /* 0x00000004 */
.equiv ADC_CHSELR_CHSEL2,       ADC_CHSELR_CHSEL2_Msk           /* ADC group regular sequencer channel 2, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL1_Pos,  (1)
.equiv ADC_CHSELR_CHSEL1_Msk,  (0x1 << ADC_CHSELR_CHSEL1_Pos)   /* 0x00000002 */
.equiv ADC_CHSELR_CHSEL1,       ADC_CHSELR_CHSEL1_Msk           /* ADC group regular sequencer channel 1, available when ADC_CFGR1_CHSELRMOD is reset */
.equiv ADC_CHSELR_CHSEL0_Pos,  (0)
.equiv ADC_CHSELR_CHSEL0_Msk,  (0x1 << ADC_CHSELR_CHSEL0_Pos)   /* 0x00000001 */
.equiv ADC_CHSELR_CHSEL0,       ADC_CHSELR_CHSEL0_Msk           /* ADC group regular sequencer channel 0, available when ADC_CFGR1_CHSELRMOD is reset */

/********************  Bit definition for ADC_DR register  ********************/
.equiv ADC_DR_DATA_Pos, (0)
.equiv ADC_DR_DATA_Msk, (0xFFFF << ADC_DR_DATA_Pos) /* 0x0000FFFF */
.equiv ADC_DR_DATA,      ADC_DR_DATA_Msk            /* ADC group regular conversion data */
.equiv ADC_DR_DATA_0,   (0x0001 << ADC_DR_DATA_Pos) /* 0x00000001 */
.equiv ADC_DR_DATA_1,   (0x0002 << ADC_DR_DATA_Pos) /* 0x00000002 */
.equiv ADC_DR_DATA_2,   (0x0004 << ADC_DR_DATA_Pos) /* 0x00000004 */
.equiv ADC_DR_DATA_3,   (0x0008 << ADC_DR_DATA_Pos) /* 0x00000008 */
.equiv ADC_DR_DATA_4,   (0x0010 << ADC_DR_DATA_Pos) /* 0x00000010 */
.equiv ADC_DR_DATA_5,   (0x0020 << ADC_DR_DATA_Pos) /* 0x00000020 */
.equiv ADC_DR_DATA_6,   (0x0040 << ADC_DR_DATA_Pos) /* 0x00000040 */
.equiv ADC_DR_DATA_7,   (0x0080 << ADC_DR_DATA_Pos) /* 0x00000080 */
.equiv ADC_DR_DATA_8,   (0x0100 << ADC_DR_DATA_Pos) /* 0x00000100 */
.equiv ADC_DR_DATA_9,   (0x0200 << ADC_DR_DATA_Pos) /* 0x00000200 */
.equiv ADC_DR_DATA_10,  (0x0400 << ADC_DR_DATA_Pos) /* 0x00000400 */
.equiv ADC_DR_DATA_11,  (0x0800 << ADC_DR_DATA_Pos) /* 0x00000800 */
.equiv ADC_DR_DATA_12,  (0x1000 << ADC_DR_DATA_Pos) /* 0x00001000 */
.equiv ADC_DR_DATA_13,  (0x2000 << ADC_DR_DATA_Pos) /* 0x00002000 */
.equiv ADC_DR_DATA_14,  (0x4000 << ADC_DR_DATA_Pos) /* 0x00004000 */
.equiv ADC_DR_DATA_15,  (0x8000 << ADC_DR_DATA_Pos) /* 0x00008000 */

/********************  Bit definition for ADC_CCSR register  ********************/
.equiv ADC_CCSR_CALSEL_Pos,  (11)
.equiv ADC_CCSR_CALSEL_Msk,  (0x1 << ADC_CCSR_CALSEL_Pos)  /* 0x00000800 */
.equiv ADC_CCSR_CALSEL,       ADC_CCSR_CALSEL_Msk          /* ADC calibration context selection */
.equiv ADC_CCSR_CALSMP_Pos,  (12)
.equiv ADC_CCSR_CALSMP_Msk,  (0x3 << ADC_CCSR_CALSMP_Pos)  /* 0x00003000 */
.equiv ADC_CCSR_CALSMP,       ADC_CCSR_CALSMP_Msk          /* ADC calibration sample time selection */
.equiv ADC_CCSR_CALSMP_0,    (0x1 << ADC_CCSR_CALSMP_Pos)  /* 0x00001000 */
.equiv ADC_CCSR_CALSMP_1,    (0x2 << ADC_CCSR_CALSMP_Pos)  /* 0x00002000 */
.equiv ADC_CCSR_CALFAIL_Pos, (30)
.equiv ADC_CCSR_CALFAIL_Msk, (0x1 << ADC_CCSR_CALFAIL_Pos) /* 0x40000000 */
.equiv ADC_CCSR_CALFAIL,      ADC_CCSR_CALFAIL_Msk         /* ADC calibration fail flag */
.equiv ADC_CCSR_CALON_Pos,   (31)
.equiv ADC_CCSR_CALON_Msk,   (0x1 << ADC_CCSR_CALON_Pos)   /* 0x80000000 */
.equiv ADC_CCSR_CALON,        ADC_CCSR_CALON_Msk           /* ADC calibration flag */

/*************************  ADC Common registers  *****************************/
/*******************  Bit definition for ADC_CCR register  ********************/
.equiv ADC_CCR_VREFEN_Pos, (22)
.equiv ADC_CCR_VREFEN_Msk, (0x1 << ADC_CCR_VREFEN_Pos) /* 0x00400000 */
.equiv ADC_CCR_VREFEN,      ADC_CCR_VREFEN_Msk         /* ADC internal path to VrefInt enable */
.equiv ADC_CCR_TSEN_Pos,   (23)
.equiv ADC_CCR_TSEN_Msk,   (0x1 << ADC_CCR_TSEN_Pos)   /* 0x00800000 */
.equiv ADC_CCR_TSEN,        ADC_CCR_TSEN_Msk           /* ADC internal path to temperature sensor enable */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit (CRC)                        */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
.equiv CRC_DR_DR_Pos, (0)
.equiv CRC_DR_DR_Msk, (0xFFFFFFFF << CRC_DR_DR_Pos) /* 0xFFFFFFFF */
.equiv CRC_DR_DR,     CRC_DR_DR_Msk                 /* Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
.equiv CRC_IDR_IDR_Pos, (0)
.equiv CRC_IDR_IDR_Msk, (0xFF << CRC_IDR_IDR_Pos) /* 0xFFFFFFFF */
.equiv CRC_IDR_IDR,     CRC_IDR_IDR_Msk           /* General-purpose 8-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
.equiv CRC_CR_RESET_Pos, (0)
.equiv CRC_CR_RESET_Msk, (0x1 << CRC_CR_RESET_Pos) /* 0x00000001 */
.equiv CRC_CR_RESET,     CRC_CR_RESET_Msk          /* RESET the CRC computation unit bit */

/******************************************************************************/
/*                                                                            */
/*                                Debug MC (DBGMC)                          */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DBG_IDCODE register  *************/
.equiv DBGMCU_IDCODE_DEV_ID_Pos, (0)
.equiv DBGMCU_IDCODE_DEV_ID_Msk, (0xFFF << DBGMCU_IDCODE_DEV_ID_Pos)  /* 0x00000FFF */
.equiv DBGMCU_IDCODE_DEV_ID,     DBGMCU_IDCODE_DEV_ID_Msk
.equiv DBGMCU_IDCODE_REV_ID_Pos, (16)
.equiv DBGMCU_IDCODE_REV_ID_Msk, (0xFFFF << DBGMCU_IDCODE_REV_ID_Pos) /* 0xFFFF0000 */
.equiv DBGMCU_IDCODE_REV_ID,     DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
.equiv DBGMCU_CR_DBG_STOP_Pos, (1)
.equiv DBGMCU_CR_DBG_STOP_Msk, (0x1 << DBGMCU_CR_DBG_STOP_Pos) /* 0x00000002 */
.equiv DBGMCU_CR_DBG_STOP,     DBGMCU_CR_DBG_STOP_Msk

/********************  Bit definition for DBGMCU_APB_FZ1 register  ***********/
.equiv DBGMCU_APB_FZ1_DBG_IWDG_STOP_Pos,  (12)
.equiv DBGMCU_APB_FZ1_DBG_IWDG_STOP_Msk,  (0x1 << DBGMCU_APB_FZ1_DBG_IWDG_STOP_Pos) /* 0x00001000 */
.equiv DBGMCU_APB_FZ1_DBG_IWDG_STOP,      DBGMCU_APB_FZ1_DBG_IWDG_STOP_Msk
.equiv DBGMCU_APB_FZ1_DBG_LPTIM_STOP_Pos, (31)
.equiv DBGMCU_APB_FZ1_DBG_LPTIM_STOP_Msk, (0x1 << DBGMCU_APB_FZ1_DBG_LPTIM_STOP_Pos) /* 0x00001000 */
.equiv DBGMCU_APB_FZ1_DBG_LPTIM_STOP,     DBGMCU_APB_FZ1_DBG_LPTIM_STOP_Msk

/********************  Bit definition for DBGMCU_APB_FZ2 register  ************/
.equiv DBGMCU_APB_FZ2_DBG_TIM1_STOP_Pos,  (11)
.equiv DBGMCU_APB_FZ2_DBG_TIM1_STOP_Msk,  (0x1 << DBGMCU_APB_FZ2_DBG_TIM1_STOP_Pos)  /* 0x00000800 */
.equiv DBGMCU_APB_FZ2_DBG_TIM1_STOP,      DBGMCU_APB_FZ2_DBG_TIM1_STOP_Msk
.equiv DBGMCU_APB_FZ2_DBG_TIM16_STOP_Pos, (17)
.equiv DBGMCU_APB_FZ2_DBG_TIM16_STOP_Msk, (0x1 << DBGMCU_APB_FZ2_DBG_TIM16_STOP_Pos) /* 0x00020000 */
.equiv DBGMCU_APB_FZ2_DBG_TIM16_STOP,     DBGMCU_APB_FZ2_DBG_TIM16_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller (EXTI)              */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for EXTI_RTSR register  ******************/
.equiv EXTI_RTSR_RT0_Pos,  (0)
.equiv EXTI_RTSR_RT0_Msk,  (0x1 << EXTI_RTSR_RT0_Pos)  /* 0x00000001 */
.equiv EXTI_RTSR_RT0,      EXTI_RTSR_RT0_Msk           /* Rising trigger configuration for input line 0 */
.equiv EXTI_RTSR_RT1_Pos,  (1)
.equiv EXTI_RTSR_RT1_Msk,  (0x1 << EXTI_RTSR_RT1_Pos)  /* 0x00000002 */
.equiv EXTI_RTSR_RT1,      EXTI_RTSR_RT1_Msk           /* Rising trigger configuration for input line 1 */
.equiv EXTI_RTSR_RT2_Pos,  (2)
.equiv EXTI_RTSR_RT2_Msk,  (0x1 << EXTI_RTSR_RT2_Pos)  /* 0x00000004 */
.equiv EXTI_RTSR_RT2,      EXTI_RTSR_RT2_Msk           /* Rising trigger configuration for input line 2 */
.equiv EXTI_RTSR_RT3_Pos,  (3)
.equiv EXTI_RTSR_RT3_Msk,  (0x1 << EXTI_RTSR_RT3_Pos)  /* 0x00000008 */
.equiv EXTI_RTSR_RT3,      EXTI_RTSR_RT3_Msk           /* Rising trigger configuration for input line 3 */
.equiv EXTI_RTSR_RT4_Pos,  (4)
.equiv EXTI_RTSR_RT4_Msk,  (0x1 << EXTI_RTSR_RT4_Pos)  /* 0x00000010 */
.equiv EXTI_RTSR_RT4,      EXTI_RTSR_RT4_Msk           /* Rising trigger configuration for input line 4 */
.equiv EXTI_RTSR_RT5_Pos,  (5)
.equiv EXTI_RTSR_RT5_Msk,  (0x1 << EXTI_RTSR_RT5_Pos)  /* 0x00000020 */
.equiv EXTI_RTSR_RT5,      EXTI_RTSR_RT5_Msk           /* Rising trigger configuration for input line 5 */
.equiv EXTI_RTSR_RT6_Pos,  (6)
.equiv EXTI_RTSR_RT6_Msk,  (0x1 << EXTI_RTSR_RT6_Pos)  /* 0x00000040 */
.equiv EXTI_RTSR_RT6,      EXTI_RTSR_RT6_Msk           /* Rising trigger configuration for input line 6 */
.equiv EXTI_RTSR_RT7_Pos,  (7)
.equiv EXTI_RTSR_RT7_Msk,  (0x1 << EXTI_RTSR_RT7_Pos)  /* 0x00000080 */
.equiv EXTI_RTSR_RT7,      EXTI_RTSR_RT7_Msk           /* Rising trigger configuration for input line 7 */
.equiv EXTI_RTSR_RT8_Pos,  (8)
.equiv EXTI_RTSR_RT8_Msk,  (0x1 << EXTI_RTSR_RT8_Pos)  /* 0x00000100 */
.equiv EXTI_RTSR_RT8,      EXTI_RTSR_RT8_Msk           /* Rising trigger configuration for input line 8 */
.equiv EXTI_RTSR_RT9_Pos,  (9)
.equiv EXTI_RTSR_RT9_Msk,  (0x1 << EXTI_RTSR_RT9_Pos)  /* 0x00000200 */
.equiv EXTI_RTSR_RT9,      EXTI_RTSR_RT9_Msk           /* Rising trigger configuration for input line 9 */
.equiv EXTI_RTSR_RT10_Pos, (10)
.equiv EXTI_RTSR_RT10_Msk, (0x1 << EXTI_RTSR_RT10_Pos) /* 0x00000400 */
.equiv EXTI_RTSR_RT10,     EXTI_RTSR_RT10_Msk          /* Rising trigger configuration for input line 10 */
.equiv EXTI_RTSR_RT11_Pos, (11)
.equiv EXTI_RTSR_RT11_Msk, (0x1 << EXTI_RTSR_RT11_Pos) /* 0x00000800 */
.equiv EXTI_RTSR_RT11,     EXTI_RTSR_RT11_Msk          /* Rising trigger configuration for input line 11 */
.equiv EXTI_RTSR_RT12_Pos, (12)
.equiv EXTI_RTSR_RT12_Msk, (0x1 << EXTI_RTSR_RT12_Pos) /* 0x00001000 */
.equiv EXTI_RTSR_RT12,     EXTI_RTSR_RT12_Msk          /* Rising trigger configuration for input line 12 */
.equiv EXTI_RTSR_RT13_Pos, (13)
.equiv EXTI_RTSR_RT13_Msk, (0x1 << EXTI_RTSR_RT13_Pos) /* 0x00002000 */
.equiv EXTI_RTSR_RT13,     EXTI_RTSR_RT13_Msk          /* Rising trigger configuration for input line 13 */
.equiv EXTI_RTSR_RT14_Pos, (14)
.equiv EXTI_RTSR_RT14_Msk, (0x1 << EXTI_RTSR_RT14_Pos) /* 0x00004000 */
.equiv EXTI_RTSR_RT14,     EXTI_RTSR_RT14_Msk          /* Rising trigger configuration for input line 14 */
.equiv EXTI_RTSR_RT15_Pos, (15)
.equiv EXTI_RTSR_RT15_Msk, (0x1 << EXTI_RTSR_RT15_Pos) /* 0x00008000 */
.equiv EXTI_RTSR_RT15,     EXTI_RTSR_RT15_Msk          /* Rising trigger configuration for input line 15 */
.equiv EXTI_RTSR_RT16_Pos, (16)
.equiv EXTI_RTSR_RT16_Msk, (0x1 << EXTI_RTSR_RT16_Pos) /* 0x00010000 */
.equiv EXTI_RTSR_RT16,     EXTI_RTSR_RT16_Msk          /* Rising trigger configuration for input line 16 */
.equiv EXTI_RTSR_RT17_Pos, (17)
.equiv EXTI_RTSR_RT17_Msk, (0x1 << EXTI_RTSR_RT16_Pos) /* 0x00020000 */
.equiv EXTI_RTSR_RT17,     EXTI_RTSR_RT17_Msk          /* Rising trigger configuration for input line 17 */
.equiv EXTI_RTSR_RT18_Pos, (18)
.equiv EXTI_RTSR_RT18_Msk, (0x1 << EXTI_RTSR_RT18_Pos) /* 0x00040000 */
.equiv EXTI_RTSR_RT18,     EXTI_RTSR_RT18_Msk          /* Rising trigger configuration for input line 18 */

/******************  Bit definition for EXTI_FTSR register  ******************/
.equiv EXTI_FTSR_FT0_Pos,  (0)
.equiv EXTI_FTSR_FT0_Msk,  (0x1 << EXTI_FTSR_FT0_Pos)  /* 0x00000001 */
.equiv EXTI_FTSR_FT0,      EXTI_FTSR_FT0_Msk           /* Falling trigger configuration for input line 0 */
.equiv EXTI_FTSR_FT1_Pos,  (1)
.equiv EXTI_FTSR_FT1_Msk,  (0x1 << EXTI_FTSR_FT1_Pos)  /* 0x00000002 */
.equiv EXTI_FTSR_FT1,      EXTI_FTSR_FT1_Msk           /* Falling trigger configuration for input line 1 */
.equiv EXTI_FTSR_FT2_Pos,  (2)
.equiv EXTI_FTSR_FT2_Msk,  (0x1 << EXTI_FTSR_FT2_Pos)  /* 0x00000004 */
.equiv EXTI_FTSR_FT2,      EXTI_FTSR_FT2_Msk           /* Falling trigger configuration for input line 2 */
.equiv EXTI_FTSR_FT3_Pos,  (3)
.equiv EXTI_FTSR_FT3_Msk,  (0x1 << EXTI_FTSR_FT3_Pos)  /* 0x00000008 */
.equiv EXTI_FTSR_FT3,      EXTI_FTSR_FT3_Msk           /* Falling trigger configuration for input line 3 */
.equiv EXTI_FTSR_FT4_Pos,  (4)
.equiv EXTI_FTSR_FT4_Msk,  (0x1 << EXTI_FTSR_FT4_Pos)  /* 0x00000010 */
.equiv EXTI_FTSR_FT4,      EXTI_FTSR_FT4_Msk           /* Falling trigger configuration for input line 4 */
.equiv EXTI_FTSR_FT5_Pos,  (5)
.equiv EXTI_FTSR_FT5_Msk,  (0x1 << EXTI_FTSR_FT5_Pos)  /* 0x00000020 */
.equiv EXTI_FTSR_FT5,      EXTI_FTSR_FT5_Msk           /* Falling trigger configuration for input line 5 */
.equiv EXTI_FTSR_FT6_Pos,  (6)
.equiv EXTI_FTSR_FT6_Msk,  (0x1 << EXTI_FTSR_FT6_Pos)  /* 0x00000040 */
.equiv EXTI_FTSR_FT6,      EXTI_FTSR_FT6_Msk           /* Falling trigger configuration for input line 6 */
.equiv EXTI_FTSR_FT7_Pos,  (7)
.equiv EXTI_FTSR_FT7_Msk,  (0x1 << EXTI_FTSR_FT7_Pos)  /* 0x00000080 */
.equiv EXTI_FTSR_FT7,      EXTI_FTSR_FT7_Msk           /* Falling trigger configuration for input line 7 */
.equiv EXTI_FTSR_FT8_Pos,  (8)
.equiv EXTI_FTSR_FT8_Msk,  (0x1 << EXTI_FTSR_FT8_Pos)  /* 0x00000100 */
.equiv EXTI_FTSR_FT8,      EXTI_FTSR_FT8_Msk           /* Falling trigger configuration for input line 8 */
.equiv EXTI_FTSR_FT9_Pos,  (9)
.equiv EXTI_FTSR_FT9_Msk,  (0x1 << EXTI_FTSR_FT9_Pos)  /* 0x00000200 */
.equiv EXTI_FTSR_FT9,      EXTI_FTSR_FT9_Msk           /* Falling trigger configuration for input line 9 */
.equiv EXTI_FTSR_FT10_Pos, (10)
.equiv EXTI_FTSR_FT10_Msk, (0x1 << EXTI_FTSR_FT10_Pos) /* 0x00000400 */
.equiv EXTI_FTSR_FT10,     EXTI_FTSR_FT10_Msk          /* Falling trigger configuration for input line 10 */
.equiv EXTI_FTSR_FT11_Pos, (11)
.equiv EXTI_FTSR_FT11_Msk, (0x1 << EXTI_FTSR_FT11_Pos) /* 0x00000800 */
.equiv EXTI_FTSR_FT11,     EXTI_FTSR_FT11_Msk          /* Falling trigger configuration for input line 11 */
.equiv EXTI_FTSR_FT12_Pos, (12)
.equiv EXTI_FTSR_FT12_Msk, (0x1 << EXTI_FTSR_FT12_Pos) /* 0x00001000 */
.equiv EXTI_FTSR_FT12,     EXTI_FTSR_FT12_Msk          /* Falling trigger configuration for input line 12 */
.equiv EXTI_FTSR_FT13_Pos, (13)
.equiv EXTI_FTSR_FT13_Msk, (0x1 << EXTI_FTSR_FT13_Pos) /* 0x00002000 */
.equiv EXTI_FTSR_FT13,     EXTI_FTSR_FT13_Msk          /* Falling trigger configuration for input line 13 */
.equiv EXTI_FTSR_FT14_Pos, (14)
.equiv EXTI_FTSR_FT14_Msk, (0x1 << EXTI_FTSR_FT14_Pos) /* 0x00004000 */
.equiv EXTI_FTSR_FT14,     EXTI_FTSR_FT14_Msk          /* Falling trigger configuration for input line 14 */
.equiv EXTI_FTSR_FT15_Pos, (15)
.equiv EXTI_FTSR_FT15_Msk, (0x1 << EXTI_FTSR_FT15_Pos) /* 0x00008000 */
.equiv EXTI_FTSR_FT15,     EXTI_FTSR_FT15_Msk          /* Falling trigger configuration for input line 15 */
.equiv EXTI_FTSR_FT16_Pos, (16)
.equiv EXTI_FTSR_FT16_Msk, (0x1 << EXTI_FTSR_FT16_Pos) /* 0x00010000 */
.equiv EXTI_FTSR_FT16,     EXTI_FTSR_FT16_Msk          /* Falling trigger configuration for input line 16 */
.equiv EXTI_FTSR_FT17_Pos, (17)
.equiv EXTI_FTSR_FT17_Msk, (0x1 << EXTI_FTSR_FT17_Pos) /* 0x00020000 */
.equiv EXTI_FTSR_FT17,     EXTI_FTSR_FT17_Msk          /* Falling trigger configuration for input line 17 */
.equiv EXTI_FTSR_FT18_Pos, (18)
.equiv EXTI_FTSR_FT18_Msk, (0x1 << EXTI_FTSR_FT18_Pos) /* 0x00040000 */
.equiv EXTI_FTSR_FT18,              EXTI_FTSR_FT18_Msk /* Falling trigger configuration for input line 18 */

/******************  Bit definition for EXTI_SWIER register  *****************/
.equiv EXTI_SWIER_SWI0_Pos,  (0)
.equiv EXTI_SWIER_SWI0_Msk,  (0x1 << EXTI_SWIER_SWI0_Pos)  /* 0x00000001 */
.equiv EXTI_SWIER_SWI0,      EXTI_SWIER_SWI0_Msk           /* Software Interrupt on line 0 */
.equiv EXTI_SWIER_SWI1_Pos,  (1)
.equiv EXTI_SWIER_SWI1_Msk,  (0x1 << EXTI_SWIER_SWI1_Pos)  /* 0x00000002 */
.equiv EXTI_SWIER_SWI1,      EXTI_SWIER_SWI1_Msk           /* Software Interrupt on line 1 */
.equiv EXTI_SWIER_SWI2_Pos,  (2)
.equiv EXTI_SWIER_SWI2_Msk,  (0x1 << EXTI_SWIER_SWI2_Pos)  /* 0x00000004 */
.equiv EXTI_SWIER_SWI2,      EXTI_SWIER_SWI2_Msk           /* Software Interrupt on line 2 */
.equiv EXTI_SWIER_SWI3_Pos,  (3)
.equiv EXTI_SWIER_SWI3_Msk,  (0x1 << EXTI_SWIER_SWI3_Pos)  /* 0x00000008 */
.equiv EXTI_SWIER_SWI3,      EXTI_SWIER_SWI3_Msk           /* Software Interrupt on line 3 */
.equiv EXTI_SWIER_SWI4_Pos,  (4)
.equiv EXTI_SWIER_SWI4_Msk,  (0x1 << EXTI_SWIER_SWI4_Pos)  /* 0x00000010 */
.equiv EXTI_SWIER_SWI4,      EXTI_SWIER_SWI4_Msk           /* Software Interrupt on line 4 */
.equiv EXTI_SWIER_SWI5_Pos,  (5)
.equiv EXTI_SWIER_SWI5_Msk,  (0x1 << EXTI_SWIER_SWI5_Pos)  /* 0x00000020 */
.equiv EXTI_SWIER_SWI5,      EXTI_SWIER_SWI5_Msk           /* Software Interrupt on line 5 */
.equiv EXTI_SWIER_SWI6_Pos,  (6)
.equiv EXTI_SWIER_SWI6_Msk,  (0x1 << EXTI_SWIER_SWI6_Pos)  /* 0x00000040 */
.equiv EXTI_SWIER_SWI6,      EXTI_SWIER_SWI6_Msk           /* Software Interrupt on line 6 */
.equiv EXTI_SWIER_SWI7_Pos,  (7)
.equiv EXTI_SWIER_SWI7_Msk,  (0x1 << EXTI_SWIER_SWI7_Pos)  /* 0x00000080 */
.equiv EXTI_SWIER_SWI7,      EXTI_SWIER_SWI7_Msk           /* Software Interrupt on line 7 */
.equiv EXTI_SWIER_SWI8_Pos,  (8)
.equiv EXTI_SWIER_SWI8_Msk,  (0x1 << EXTI_SWIER_SWI8_Pos)  /* 0x00000100 */
.equiv EXTI_SWIER_SWI8,      EXTI_SWIER_SWI8_Msk           /* Software Interrupt on line 8 */
.equiv EXTI_SWIER_SWI9_Pos,  (9)
.equiv EXTI_SWIER_SWI9_Msk,  (0x1 << EXTI_SWIER_SWI9_Pos)  /* 0x00000200 */
.equiv EXTI_SWIER_SWI9,      EXTI_SWIER_SWI9_Msk           /* Software Interrupt on line 9 */
.equiv EXTI_SWIER_SWI10_Pos, (10)
.equiv EXTI_SWIER_SWI10_Msk, (0x1 << EXTI_SWIER_SWI10_Pos) /* 0x00000400 */
.equiv EXTI_SWIER_SWI10,     EXTI_SWIER_SWI10_Msk          /* Software Interrupt on line 10 */
.equiv EXTI_SWIER_SWI11_Pos, (11)
.equiv EXTI_SWIER_SWI11_Msk, (0x1 << EXTI_SWIER_SWI11_Pos) /* 0x00000800 */
.equiv EXTI_SWIER_SWI11,     EXTI_SWIER_SWI11_Msk          /* Software Interrupt on line 11 */
.equiv EXTI_SWIER_SWI12_Pos, (12)
.equiv EXTI_SWIER_SWI12_Msk, (0x1 << EXTI_SWIER_SWI12_Pos) /* 0x00001000 */
.equiv EXTI_SWIER_SWI12,     EXTI_SWIER_SWI12_Msk          /* Software Interrupt on line 12 */
.equiv EXTI_SWIER_SWI13_Pos, (13)
.equiv EXTI_SWIER_SWI13_Msk, (0x1 << EXTI_SWIER_SWI13_Pos) /* 0x00002000 */
.equiv EXTI_SWIER_SWI13,     EXTI_SWIER_SWI13_Msk          /* Software Interrupt on line 13 */
.equiv EXTI_SWIER_SWI14_Pos, (14)
.equiv EXTI_SWIER_SWI14_Msk, (0x1 << EXTI_SWIER_SWI14_Pos) /* 0x00004000 */
.equiv EXTI_SWIER_SWI14,     EXTI_SWIER_SWI14_Msk          /* Software Interrupt on line 14 */
.equiv EXTI_SWIER_SWI15_Pos, (15)
.equiv EXTI_SWIER_SWI15_Msk, (0x1 << EXTI_SWIER_SWI15_Pos) /* 0x00008000 */
.equiv EXTI_SWIER_SWI15,     EXTI_SWIER_SWI15_Msk          /* Software Interrupt on line 15 */
.equiv EXTI_SWIER_SWI16_Pos, (16)
.equiv EXTI_SWIER_SWI16_Msk, (0x1 << EXTI_SWIER_SWI16_Pos) /* 0x00010000 */
.equiv EXTI_SWIER_SWI16,     EXTI_SWIER_SWI16_Msk          /* Software Interrupt on line 16 */
.equiv EXTI_SWIER_SWI17_Pos, (17)
.equiv EXTI_SWIER_SWI17_Msk, (0x1 << EXTI_SWIER_SWI17_Pos) /* 0x00020000 */
.equiv EXTI_SWIER_SWI17,     EXTI_SWIER_SWI17_Msk          /* Software Interrupt on line 17 */
.equiv EXTI_SWIER_SWI18_Pos, (18)
.equiv EXTI_SWIER_SWI18_Msk, (0x1 << EXTI_SWIER_SWI18_Pos) /* 0x00040000 */
.equiv EXTI_SWIER_SWI18,     EXTI_SWIER_SWI18_Msk          /* Software Interrupt on line 18*/

/*******************  Bit definition for EXTI_PR register  ******************/
.equiv EXTI_PR_PR0_Pos,  (0)
.equiv EXTI_PR_PR0_Msk,  (0x1 << EXTI_PR_PR0_Pos)  /* 0x00000001 */
.equiv EXTI_PR_PR0,      EXTI_PR_PR0_Msk           /* Rising Pending Interrupt Flag on line 0 */
.equiv EXTI_PR_PR1_Pos,  (1)
.equiv EXTI_PR_PR1_Msk,  (0x1 << EXTI_PR_PR1_Pos)  /* 0x00000002 */
.equiv EXTI_PR_PR1,      EXTI_PR_PR1_Msk           /* Rising Pending Interrupt Flag on line 1 */
.equiv EXTI_PR_PR2_Pos,  (2)
.equiv EXTI_PR_PR2_Msk,  (0x1 << EXTI_PR_PR2_Pos)  /* 0x00000004 */
.equiv EXTI_PR_PR2,      EXTI_PR_PR2_Msk           /* Rising Pending Interrupt Flag on line 2 */
.equiv EXTI_PR_PR3_Pos,  (3)
.equiv EXTI_PR_PR3_Msk,  (0x1 << EXTI_PR_PR3_Pos)  /* 0x00000008 */
.equiv EXTI_PR_PR3,      EXTI_PR_PR3_Msk           /* Rising Pending Interrupt Flag on line 3 */
.equiv EXTI_PR_PR_Pos,   (4)
.equiv EXTI_PR_PR_Msk,   (0x1 << EXTI_PR_PR_Pos)   /* 0x00000010 */
.equiv EXTI_PR_PR4,      EXTI_PR_PR_Msk            /* Rising Pending Interrupt Flag on line 4 */
.equiv EXTI_PR_PR5_Pos,  (5)
.equiv EXTI_PR_PR5_Msk,  (0x1 << EXTI_PR_PR5_Pos ) /* 0x00000020 */
.equiv EXTI_PR_PR5,      EXTI_PR_PR5_Msk           /* Rising Pending Interrupt Flag on line 5 */
.equiv EXTI_PR_PR6_Pos,  (6)
.equiv EXTI_PR_PR6_Msk,  (0x1 << EXTI_PR_PR6_Pos)  /* 0x00000040 */
.equiv EXTI_PR_PR6,      EXTI_PR_PR6_Msk           /* Rising Pending Interrupt Flag on line 6 */
.equiv EXTI_PR_PR7_Pos,  (7)
.equiv EXTI_PR_PR7_Msk,  (0x1 << EXTI_PR_PR7_Pos)  /* 0x00000080 */
.equiv EXTI_PR_PR7,      EXTI_PR_PR7_Msk           /* Rising Pending Interrupt Flag on line 7 */
.equiv EXTI_PR_PR8_Pos,  (8)
.equiv EXTI_PR_PR8_Msk,  (0x1 << EXTI_PR_PR8_Pos ) /* 0x00000100 */
.equiv EXTI_PR_PR8,      EXTI_PR_PR8_Msk           /* Rising Pending Interrupt Flag on line 8 */
.equiv EXTI_PR_PR9_Pos,  (9)
.equiv EXTI_PR_PR9_Msk,  (0x1 << EXTI_PR_PR9_Pos)  /* 0x00000200 */
.equiv EXTI_PR_PR9,      EXTI_PR_PR9_Msk           /* Rising Pending Interrupt Flag on line 9 */
.equiv EXTI_PR_PR10_Pos, (10)
.equiv EXTI_PR_PR10_Msk, (0x1 << EXTI_PR_PR10_Pos) /* 0x00000400 */
.equiv EXTI_PR_PR10,     EXTI_PR_PR10_Msk          /* Rising Pending Interrupt Flag on line 10 */
.equiv EXTI_PR_PR11_Pos, (11)
.equiv EXTI_PR_PR11_Msk, (0x1 << EXTI_PR_PR11_Pos) /* 0x00000800 */
.equiv EXTI_PR_PR11,     EXTI_PR_PR11_Msk          /* Rising Pending Interrupt Flag on line 11 */
.equiv EXTI_PR_PR12_Pos, (12)
.equiv EXTI_PR_PR12_Msk, (0x1 << EXTI_PR_PR12_Pos) /* 0x00001000 */
.equiv EXTI_PR_PR12,     EXTI_PR_PR12_Msk          /* Rising Pending Interrupt Flag on line 12 */
.equiv EXTI_PR_PR13_Pos, (13)
.equiv EXTI_PR_PR13_Msk, (0x1 << EXTI_PR_PR13_Pos) /* 0x00002000 */
.equiv EXTI_PR_PR13,     EXTI_PR_PR13_Msk          /* Rising Pending Interrupt Flag on line 13 */
.equiv EXTI_PR_PR14_Pos, (14)
.equiv EXTI_PR_PR14_Msk, (0x1 << EXTI_PR_PR14_Pos) /* 0x00004000 */
.equiv EXTI_PR_PR14,     EXTI_PR_PR14_Msk          /* Rising Pending Interrupt Flag on line 14 */
.equiv EXTI_PR_PR15_Pos, (15)
.equiv EXTI_PR_PR15_Msk, (0x1 << EXTI_PR_PR15_Pos) /* 0x00008000 */
.equiv EXTI_PR_PR15,     EXTI_PR_PR15_Msk          /* Rising Pending Interrupt Flag on line 15 */
.equiv EXTI_PR_PR16_Pos, (16)
.equiv EXTI_PR_PR16_Msk, (0x1 << EXTI_PR_PR16_Pos) /* 0x00010000 */
.equiv EXTI_PR_PR16,     EXTI_PR_PR16_Msk          /* Rising Pending Interrupt Flag on line 16 */
.equiv EXTI_PR_PR17_Pos, (17)
.equiv EXTI_PR_PR17_Msk, (0x1 << EXTI_PR_PR17_Pos) /* 0x00020000 */
.equiv EXTI_PR_PR17,     EXTI_PR_PR17_Msk          /* Rising Pending Interrupt Flag on line 17 */
.equiv EXTI_PR_PR18_Pos, (18)
.equiv EXTI_PR_PR18_Msk, (0x1 << EXTI_PR_PR18_Pos) /* 0x00080000 */
.equiv EXTI_PR_PR18,     EXTI_PR_PR18_Msk          /* Rising Pending Interrupt Flag on line 18 */

/* References Defines */
.equiv EXTI_PR_PIF0,  EXTI_PR_PR0
.equiv EXTI_PR_PIF1,  EXTI_PR_PR1
.equiv EXTI_PR_PIF2,  EXTI_PR_PR2
.equiv EXTI_PR_PIF3,  EXTI_PR_PR3
.equiv EXTI_PR_PIF4,  EXTI_PR_PR4
.equiv EXTI_PR_PIF5,  EXTI_PR_PR5
.equiv EXTI_PR_PIF6,  EXTI_PR_PR6
.equiv EXTI_PR_PIF7,  EXTI_PR_PR7
.equiv EXTI_PR_PIF8,  EXTI_PR_PR8
.equiv EXTI_PR_PIF9,  EXTI_PR_PR9
.equiv EXTI_PR_PIF10, EXTI_PR_PR10
.equiv EXTI_PR_PIF11, EXTI_PR_PR11
.equiv EXTI_PR_PIF12, EXTI_PR_PR12
.equiv EXTI_PR_PIF13, EXTI_PR_PR13
.equiv EXTI_PR_PIF14, EXTI_PR_PR14
.equiv EXTI_PR_PIF15, EXTI_PR_PR15
.equiv EXTI_PR_PIF16, EXTI_PR_PR16
.equiv EXTI_PR_PIF17, EXTI_PR_PR17
.equiv EXTI_PR_PIF18, EXTI_PR_PR18

/*****************  Bit definition for EXTI_EXTICR1 register  **************/
.equiv EXTI_EXTICR1_EXTI0_Pos, (0)
.equiv EXTI_EXTICR1_EXTI0_Msk, (0x3 << EXTI_EXTICR1_EXTI0_Pos) /* 0x00000003 */
.equiv EXTI_EXTICR1_EXTI0,     EXTI_EXTICR1_EXTI0_Msk          /* EXTI 0 configuration */
.equiv EXTI_EXTICR1_EXTI0_0,   (0x1 << EXTI_EXTICR1_EXTI0_Pos) /* 0x00000001 */
.equiv EXTI_EXTICR1_EXTI0_1,   (0x2 << EXTI_EXTICR1_EXTI0_Pos) /* 0x00000002 */
.equiv EXTI_EXTICR1_EXTI0_PA0, (0 << EXTI_EXTICR1_EXTI0_Pos)
.equiv EXTI_EXTICR1_EXTI0_PB0, (1 << EXTI_EXTICR1_EXTI0_Pos)
.equiv EXTI_EXTICR1_EXTI0_PF0, (2 << EXTI_EXTICR1_EXTI0_Pos)
.equiv EXTI_EXTICR1_EXTI1_Pos, (8)
.equiv EXTI_EXTICR1_EXTI1_Msk, (0x3 << EXTI_EXTICR1_EXTI1_Pos) /* 0x00000300 */
.equiv EXTI_EXTICR1_EXTI1,     EXTI_EXTICR1_EXTI1_Msk          /* EXTI 1 configuration */
.equiv EXTI_EXTICR1_EXTI1_0,   (0x1 << EXTI_EXTICR1_EXTI1_Pos) /* 0x00000100 */
.equiv EXTI_EXTICR1_EXTI1_1,   (0x2 << EXTI_EXTICR1_EXTI1_Pos) /* 0x00000200 */
.equiv EXTI_EXTICR1_EXTI1_PA1, (0 << EXTI_EXTICR1_EXTI1_Pos)
.equiv EXTI_EXTICR1_EXTI1_PB1, (1 << EXTI_EXTICR1_EXTI1_Pos)
.equiv EXTI_EXTICR1_EXTI1_PF1, (2 << EXTI_EXTICR1_EXTI1_Pos)
.equiv EXTI_EXTICR1_EXTI2_Pos, (16)
.equiv EXTI_EXTICR1_EXTI2_Msk, (0x3 << EXTI_EXTICR1_EXTI2_Pos) /* 0x00030000 */
.equiv EXTI_EXTICR1_EXTI2,     EXTI_EXTICR1_EXTI2_Msk          /* EXTI 2 configuration */
.equiv EXTI_EXTICR1_EXTI2_0,   (0x1 << EXTI_EXTICR1_EXTI2_Pos) /* 0x00010000 */
.equiv EXTI_EXTICR1_EXTI2_1,   (0x2 << EXTI_EXTICR1_EXTI2_Pos) /* 0x00020000 */
.equiv EXTI_EXTICR1_EXTI2_PA2, (0 << EXTI_EXTICR1_EXTI2_Pos)
.equiv EXTI_EXTICR1_EXTI2_PB2, (1 << EXTI_EXTICR1_EXTI2_Pos)
.equiv EXTI_EXTICR1_EXTI2_PF2, (2 << EXTI_EXTICR1_EXTI2_Pos)
.equiv EXTI_EXTICR1_EXTI3_Pos, (24)
.equiv EXTI_EXTICR1_EXTI3_Msk, (0x3 << EXTI_EXTICR1_EXTI3_Pos) /* 0x03000000 */
.equiv EXTI_EXTICR1_EXTI3,     EXTI_EXTICR1_EXTI3_Msk          /* EXTI 3 configuration */
.equiv EXTI_EXTICR1_EXTI3_0,   (0x1 << EXTI_EXTICR1_EXTI3_Pos) /* 0x01000000 */
.equiv EXTI_EXTICR1_EXTI3_1,   (0x2 << EXTI_EXTICR1_EXTI3_Pos) /* 0x02000000 */
.equiv EXTI_EXTICR1_EXTI3_PA3, (0 << EXTI_EXTICR1_EXTI3_Pos)
.equiv EXTI_EXTICR1_EXTI3_PB3, (1 << EXTI_EXTICR1_EXTI3_Pos)
.equiv EXTI_EXTICR1_EXTI3_PF3, (2 << EXTI_EXTICR1_EXTI3_Pos)

/*****************  Bit definition for EXTI_EXTICR2 register  **************/
.equiv EXTI_EXTICR2_EXTI4_Pos, (0)
.equiv EXTI_EXTICR2_EXTI4_Msk, (0x3 << EXTI_EXTICR2_EXTI4_Pos) /* 0x00000003 */
.equiv EXTI_EXTICR2_EXTI4,     EXTI_EXTICR2_EXTI4_Msk          /* EXTI 4 configuration */
.equiv EXTI_EXTICR2_EXTI4_0,   (0x1 << EXTI_EXTICR2_EXTI4_Pos) /* 0x00000001 */
.equiv EXTI_EXTICR2_EXTI4_1,   (0x2 << EXTI_EXTICR2_EXTI4_Pos) /* 0x00000002 */
.equiv EXTI_EXTICR2_EXTI5_Pos, (8)
.equiv EXTI_EXTICR2_EXTI5_Msk, (0x1 << EXTI_EXTICR2_EXTI5_Pos) /* 0x00000100 */
.equiv EXTI_EXTICR2_EXTI5,     EXTI_EXTICR2_EXTI5_Msk          /* EXTI 5 configuration */
.equiv EXTI_EXTICR2_EXTI6_Pos, (16)
.equiv EXTI_EXTICR2_EXTI6_Msk, (0x1 << EXTI_EXTICR2_EXTI6_Pos) /* 0x00010000 */
.equiv EXTI_EXTICR2_EXTI6,     EXTI_EXTICR2_EXTI6_Msk          /* EXTI 6 configuration */
.equiv EXTI_EXTICR2_EXTI7_Pos, (24)
.equiv EXTI_EXTICR2_EXTI7_Msk, (0x1 << EXTI_EXTICR2_EXTI7_Pos) /* 0x01000000 */
.equiv EXTI_EXTICR2_EXTI7,     EXTI_EXTICR2_EXTI7_Msk          /* EXTI 7 configuration */

/*****************  Bit definition for EXTI_EXTICR3 register  **************/
.equiv EXTI_EXTICR3_EXTI8_Pos, (0)
.equiv EXTI_EXTICR3_EXTI8_Msk, (0x1 << EXTI_EXTICR3_EXTI8_Pos) /* 0x00000001 */
.equiv EXTI_EXTICR3_EXTI8,     EXTI_EXTICR3_EXTI8_Msk          /* EXTI 8 configuration */

/*******************  Bit definition for EXTI_IMR1 register  ******************/
.equiv EXTI_IMR_IM_Pos,   (0)
.equiv EXTI_IMR_IM_Msk,   (0x200FFFFF << EXTI_IMR_IM_Pos) /* 0x200FFFFF */
.equiv EXTI_IMR_IM,       EXTI_IMR_IM_Msk                 /* Interrupt Mask All */
.equiv EXTI_IMR_IM0_Pos,  (0)
.equiv EXTI_IMR_IM0_Msk,  (0x1 << EXTI_IMR_IM0_Pos)       /* 0x00000001 */
.equiv EXTI_IMR_IM0,      EXTI_IMR_IM0_Msk                /* Interrupt Mask on line 0 */
.equiv EXTI_IMR_IM1_Pos,  (1)
.equiv EXTI_IMR_IM1_Msk,  (0x1 << EXTI_IMR_IM1_Pos)       /* 0x00000002 */
.equiv EXTI_IMR_IM1,      EXTI_IMR_IM1_Msk                /* Interrupt Mask on line 1 */
.equiv EXTI_IMR_IM2_Pos,  (2)
.equiv EXTI_IMR_IM2_Msk,  (0x1 << EXTI_IMR_IM2_Pos)       /* 0x00000004 */
.equiv EXTI_IMR_IM2,      EXTI_IMR_IM2_Msk                /* Interrupt Mask on line 2 */
.equiv EXTI_IMR_IM3_Pos,  (3)
.equiv EXTI_IMR_IM3_Msk,  (0x1 << EXTI_IMR_IM3_Pos)       /* 0x00000008 */
.equiv EXTI_IMR_IM3,      EXTI_IMR_IM3_Msk                /* Interrupt Mask on line 3 */
.equiv EXTI_IMR_IM4_Pos,  (4)
.equiv EXTI_IMR_IM4_Msk,  (0x1 << EXTI_IMR_IM4_Pos)       /* 0x00000010 */
.equiv EXTI_IMR_IM4,      EXTI_IMR_IM4_Msk                /* Interrupt Mask on line 4 */
.equiv EXTI_IMR_IM5_Pos,  (5)
.equiv EXTI_IMR_IM5_Msk,  (0x1 << EXTI_IMR_IM5_Pos)       /* 0x00000020 */
.equiv EXTI_IMR_IM5,      EXTI_IMR_IM5_Msk                /* Interrupt Mask on line 5 */
.equiv EXTI_IMR_IM6_Pos,  (6)
.equiv EXTI_IMR_IM6_Msk,  (0x1 << EXTI_IMR_IM6_Pos)       /* 0x00000040 */
.equiv EXTI_IMR_IM6,      EXTI_IMR_IM6_Msk                /* Interrupt Mask on line 6 */
.equiv EXTI_IMR_IM7_Pos,  (7)
.equiv EXTI_IMR_IM7_Msk,  (0x1 << EXTI_IMR_IM7_Pos)       /* 0x00000080 */
.equiv EXTI_IMR_IM7,      EXTI_IMR_IM7_Msk                /* Interrupt Mask on line 7 */
.equiv EXTI_IMR_IM8_Pos,  (8)
.equiv EXTI_IMR_IM8_Msk,  (0x1 << EXTI_IMR_IM8_Pos)       /* 0x00000100 */
.equiv EXTI_IMR_IM8,      EXTI_IMR_IM8_Msk                /* Interrupt Mask on line 8 */
.equiv EXTI_IMR_IM9_Pos,  (9)
.equiv EXTI_IMR_IM9_Msk,  (0x1 << EXTI_IMR_IM9_Pos)       /* 0x00000200 */
.equiv EXTI_IMR_IM9,      EXTI_IMR_IM9_Msk                /* Interrupt Mask on line 9 */
.equiv EXTI_IMR_IM10_Pos, (10)
.equiv EXTI_IMR_IM10_Msk, (0x1 << EXTI_IMR_IM10_Pos)      /* 0x00000400 */
.equiv EXTI_IMR_IM10,     EXTI_IMR_IM10_Msk               /* Interrupt Mask on line 10 */
.equiv EXTI_IMR_IM11_Pos, (11)
.equiv EXTI_IMR_IM11_Msk, (0x1 << EXTI_IMR_IM11_Pos)      /* 0x00000800 */
.equiv EXTI_IMR_IM11,     EXTI_IMR_IM11_Msk               /* Interrupt Mask on line 11 */
.equiv EXTI_IMR_IM12_Pos, (12)
.equiv EXTI_IMR_IM12_Msk, (0x1 << EXTI_IMR_IM12_Pos)      /* 0x00001000 */
.equiv EXTI_IMR_IM12,     EXTI_IMR_IM12_Msk               /* Interrupt Mask on line 12 */
.equiv EXTI_IMR_IM13_Pos, (13)
.equiv EXTI_IMR_IM13_Msk, (0x1 << EXTI_IMR_IM13_Pos)      /* 0x00002000 */
.equiv EXTI_IMR_IM13,     EXTI_IMR_IM13_Msk               /* Interrupt Mask on line 13 */
.equiv EXTI_IMR_IM14_Pos, (14)
.equiv EXTI_IMR_IM14_Msk, (0x1 << EXTI_IMR_IM14_Pos)      /* 0x00004000 */
.equiv EXTI_IMR_IM14,     EXTI_IMR_IM14_Msk               /* Interrupt Mask on line 14 */
.equiv EXTI_IMR_IM15_Pos, (15)
.equiv EXTI_IMR_IM15_Msk, (0x1 << EXTI_IMR_IM15_Pos)      /* 0x00008000 */
.equiv EXTI_IMR_IM15,     EXTI_IMR_IM15_Msk               /* Interrupt Mask on line 15 */
.equiv EXTI_IMR_IM16_Pos, (16)
.equiv EXTI_IMR_IM16_Msk, (0x1 << EXTI_IMR_IM16_Pos)      /* 0x00010000 */
.equiv EXTI_IMR_IM16,     EXTI_IMR_IM16_Msk               /* Interrupt Mask on line 16 */
.equiv EXTI_IMR_IM17_Pos, (17)
.equiv EXTI_IMR_IM17_Msk, (0x1 << EXTI_IMR_IM17_Pos)      /* 0x00020000 */
.equiv EXTI_IMR_IM17,     EXTI_IMR_IM17_Msk               /* Interrupt Mask on line 17 */
.equiv EXTI_IMR_IM18_Pos, (18)
.equiv EXTI_IMR_IM18_Msk, (0x1 << EXTI_IMR_IM18_Pos)      /* 0x00040000 */
.equiv EXTI_IMR_IM18,     EXTI_IMR_IM18_Msk               /* Interrupt Mask on line 18 */
.equiv EXTI_IMR_IM19_Pos, (19)
.equiv EXTI_IMR_IM19_Msk, (0x1 << EXTI_IMR_IM19_Pos)      /* 0x00080000 */
.equiv EXTI_IMR_IM19,     EXTI_IMR_IM19_Msk               /* Interrupt Mask on line 19 */
.equiv EXTI_IMR_IM29_Pos, (29)
.equiv EXTI_IMR_IM29_Msk, (0x1 << EXTI_IMR_IM29_Pos)      /* 0x20000000 */
.equiv EXTI_IMR_IM29,     EXTI_IMR_IM29_Msk               /* Interrupt Mask on line 29 */

/*******************  Bit definition for EXTI_EMR1 register  ******************/
.equiv EXTI_EMR_EM_Pos,   (0)
.equiv EXTI_EMR_EM_Msk,   (0x200FFFFF << EXTI_EMR_EM_Pos) /* 0x200FFFFF */
.equiv EXTI_EMR_EM,       EXTI_EMR_EM_Msk                 /* Event Mask All */
.equiv EXTI_EMR_EM0_Pos,  (0)
.equiv EXTI_EMR_EM0_Msk,  (0x1 << EXTI_EMR_EM0_Pos)       /* 0x00000001 */
.equiv EXTI_EMR_EM0,      EXTI_EMR_EM0_Msk                /* Event Mask on line 0 */
.equiv EXTI_EMR_EM1_Pos,  (1)
.equiv EXTI_EMR_EM1_Msk,  (0x1 << EXTI_EMR_EM1_Pos)       /* 0x00000002 */
.equiv EXTI_EMR_EM1,      EXTI_EMR_EM1_Msk                /* Event Mask on line 1 */
.equiv EXTI_EMR_EM2_Pos,  (2)
.equiv EXTI_EMR_EM2_Msk,  (0x1 << EXTI_EMR_EM2_Pos)       /* 0x00000004 */
.equiv EXTI_EMR_EM2,      EXTI_EMR_EM2_Msk                /* Event Mask on line 2 */
.equiv EXTI_EMR_EM3_Pos,  (3)
.equiv EXTI_EMR_EM3_Msk,  (0x1 << EXTI_EMR_EM3_Pos)       /* 0x00000008 */
.equiv EXTI_EMR_EM3,      EXTI_EMR_EM3_Msk                /* Event Mask on line 3 */
.equiv EXTI_EMR_EM4_Pos,  (4)
.equiv EXTI_EMR_EM4_Msk,  (0x1 << EXTI_EMR_EM4_Pos)       /* 0x00000010 */
.equiv EXTI_EMR_EM4,      EXTI_EMR_EM4_Msk                /* Event Mask on line 4 */
.equiv EXTI_EMR_EM5_Pos,  (5)
.equiv EXTI_EMR_EM5_Msk,  (0x1 << EXTI_EMR_EM5_Pos)       /* 0x00000020 */
.equiv EXTI_EMR_EM5,      EXTI_EMR_EM5_Msk                /* Event Mask on line 5 */
.equiv EXTI_EMR_EM6_Pos,  (6)
.equiv EXTI_EMR_EM6_Msk,  (0x1 << EXTI_EMR_EM6_Pos)       /* 0x00000040 */
.equiv EXTI_EMR_EM6,      EXTI_EMR_EM6_Msk                /* Event Mask on line 6 */
.equiv EXTI_EMR_EM7_Pos,  (7)
.equiv EXTI_EMR_EM7_Msk,  (0x1 << EXTI_EMR_EM7_Pos)       /* 0x00000080 */
.equiv EXTI_EMR_EM7,      EXTI_EMR_EM7_Msk                /* Event Mask on line 7 */
.equiv EXTI_EMR_EM8_Pos,  (8)
.equiv EXTI_EMR_EM8_Msk,  (0x1 << EXTI_EMR_EM8_Pos)       /* 0x00000100 */
.equiv EXTI_EMR_EM8,      EXTI_EMR_EM8_Msk                /* Event Mask on line 8 */
.equiv EXTI_EMR_EM9_Pos,  (9)
.equiv EXTI_EMR_EM9_Msk,  (0x1 << EXTI_EMR_EM9_Pos)       /* 0x00000200 */
.equiv EXTI_EMR_EM9,      EXTI_EMR_EM9_Msk                /* Event Mask on line 9 */
.equiv EXTI_EMR_EM10_Pos, (10)
.equiv EXTI_EMR_EM10_Msk, (0x1 << EXTI_EMR_EM10_Pos)      /* 0x00000400 */
.equiv EXTI_EMR_EM10,     EXTI_EMR_EM10_Msk               /* Event Mask on line 10 */
.equiv EXTI_EMR_EM11_Pos, (11)
.equiv EXTI_EMR_EM11_Msk, (0x1 << EXTI_EMR_EM11_Pos)      /* 0x00000800 */
.equiv EXTI_EMR_EM11,     EXTI_EMR_EM11_Msk               /* Event Mask on line 11 */
.equiv EXTI_EMR_EM12_Pos, (12)
.equiv EXTI_EMR_EM12_Msk, (0x1 << EXTI_EMR_EM12_Pos)      /* 0x00001000 */
.equiv EXTI_EMR_EM12,     EXTI_EMR_EM12_Msk               /* Event Mask on line 12 */
.equiv EXTI_EMR_EM13_Pos, (13)
.equiv EXTI_EMR_EM13_Msk, (0x1 << EXTI_EMR_EM13_Pos)      /* 0x00002000 */
.equiv EXTI_EMR_EM13,     EXTI_EMR_EM13_Msk               /* Event Mask on line 13 */
.equiv EXTI_EMR_EM14_Pos, (14)
.equiv EXTI_EMR_EM14_Msk, (0x1 << EXTI_EMR_EM14_Pos)      /* 0x00004000 */
.equiv EXTI_EMR_EM14,     EXTI_EMR_EM14_Msk               /* Event Mask on line 14 */
.equiv EXTI_EMR_EM15_Pos, (15)
.equiv EXTI_EMR_EM15_Msk, (0x1 << EXTI_EMR_EM15_Pos)      /* 0x00008000 */
.equiv EXTI_EMR_EM15,     EXTI_EMR_EM15_Msk               /* Event Mask on line 15 */
.equiv EXTI_EMR_EM16_Pos, (16)
.equiv EXTI_EMR_EM16_Msk, (0x1 << EXTI_EMR_EM16_Pos)      /* 0x00010000 */
.equiv EXTI_EMR_EM16,     EXTI_EMR_EM16_Msk               /* Event Mask on line 16 */
.equiv EXTI_EMR_EM17_Pos, (17)
.equiv EXTI_EMR_EM17_Msk, (0x1 << EXTI_EMR_EM17_Pos)      /* 0x00020000 */
.equiv EXTI_EMR_EM17,     EXTI_EMR_EM17_Msk               /* Event Mask on line 17 */
.equiv EXTI_EMR_EM18_Pos, (18)
.equiv EXTI_EMR_EM18_Msk, (0x1 << EXTI_EMR_EM18_Pos)      /* 0x00040000 */
.equiv EXTI_EMR_EM18,     EXTI_EMR_EM18_Msk               /* Event Mask on line 18 */
.equiv EXTI_EMR_EM19_Pos, (19)
.equiv EXTI_EMR_EM19_Msk, (0x1 << EXTI_EMR_EM19_Pos)      /* 0x00080000 */
.equiv EXTI_EMR_EM19,     EXTI_EMR_EM19_Msk               /* Event Mask on line 19 */
.equiv EXTI_EMR_EM29_Pos, (29)
.equiv EXTI_EMR_EM29_Msk, (0x1 << EXTI_EMR_EM29_Pos)      /* 0x20000000 */
.equiv EXTI_EMR_EM29,     EXTI_EMR_EM29_Msk               /* Event Mask on line 29 */

/******************************************************************************/
/*                                                                            */
/*         FLASH and Option Bytes Registers                                   */
/*                                                                            */
/******************************************************************************/
.equiv GPIO_NRST_CONFIG_SUPPORT,       1 /* GPIO feature available only on specific devices: Configure NRST pin */
.equiv FLASH_SECURABLE_MEMORY_SUPPORT, 1 /* Flash feature available only on specific devices: allow to secure memory */
.equiv FLASH_PCROP_SUPPORT,            1 /* Flash feature available only on specific devices: proprietary code read protection areas selected by option */

/*******************  Bits definition for FLASH_ACR register  *****************/
.equiv FLASH_ACR_LATENCY_Pos, (0)
.equiv FLASH_ACR_LATENCY_Msk, (0x1 << FLASH_ACR_LATENCY_Pos) /* 0x00000001 */
.equiv FLASH_ACR_LATENCY,     FLASH_ACR_LATENCY_Msk

/******************  Bit definition for FLASH_KEYR register  ******************/
.equiv FLASH_KEYR_KEY_Pos, (0)
.equiv FLASH_KEYR_KEY_Msk, (0xFFFFFFFF << FLASH_KEYR_KEY_Pos) /* 0xFFFFFFFF */
.equiv FLASH_KEYR_KEY,     FLASH_KEYR_KEY_Msk                 /* FPEC Key */

/*****************  Bit definition for FLASH_OPTKEYR register  ****************/
.equiv FLASH_OPTKEYR_OPTKEY_Pos, (0)
.equiv FLASH_OPTKEYR_OPTKEY_Msk, (0xFFFFFFFF << FLASH_OPTKEYR_OPTKEY_Pos) /* 0xFFFFFFFF */
.equiv FLASH_OPTKEYR_OPTKEY,     FLASH_OPTKEYR_OPTKEY_Msk                 /* Option Byte Key */

/******************  FLASH Keys  **********************************************/
.equiv FLASH_KEY1_Pos, (0)
.equiv FLASH_KEY1_Msk, (0x45670123 << FLASH_KEY1_Pos) /* 0x45670123 */
.equiv FLASH_KEY1,     FLASH_KEY1_Msk                 /* Flash program erase key1 */
.equiv FLASH_KEY2_Pos, (0)
.equiv FLASH_KEY2_Msk, (0xCDEF89AB << FLASH_KEY2_Pos) /* 0xCDEF89AB */
.equiv FLASH_KEY2,     FLASH_KEY2_Msk                 /* Flash program erase key2: used with FLASH_PEKEY1 to unlock the write access to the FPEC. */

.equiv FLASH_OPTKEY1_Pos, (0)
.equiv FLASH_OPTKEY1_Msk, (0x08192A3B << FLASH_OPTKEY1_Pos) /* 0x08192A3B */
.equiv FLASH_OPTKEY1,     FLASH_OPTKEY1_Msk                 /* Flash option key1 */
.equiv FLASH_OPTKEY2_Pos, (0)
.equiv FLASH_OPTKEY2_Msk, (0x4C5D6E7F << FLASH_OPTKEY2_Pos) /* 0x4C5D6E7F */
.equiv FLASH_OPTKEY2,     FLASH_OPTKEY2_Msk                 /* Flash option key2: used with FLASH_OPTKEY1 to unlock the write access to the option byte block */

/*******************  Bits definition for FLASH_SR register  ******************/
.equiv FLASH_SR_EOP_Pos,     (0)
.equiv FLASH_SR_EOP_Msk,     (0x1 << FLASH_SR_EOP_Pos)     /* 0x00000001 */
.equiv FLASH_SR_EOP,         FLASH_SR_EOP_Msk
.equiv FLASH_SR_WRPERR_Pos,  (4)
.equiv FLASH_SR_WRPERR_Msk,  (0x1 << FLASH_SR_WRPERR_Pos)  /* 0x00000010 */
.equiv FLASH_SR_WRPERR,      FLASH_SR_WRPERR_Msk
.equiv FLASH_SR_OPTVERR_Pos, (15)
.equiv FLASH_SR_OPTVERR_Msk, (0x1 << FLASH_SR_OPTVERR_Pos) /* 0x00008000 */
.equiv FLASH_SR_OPTVERR,     FLASH_SR_OPTVERR_Msk
.equiv FLASH_SR_BSY_Pos,     (16)
.equiv FLASH_SR_BSY_Msk,     (0x1 << FLASH_SR_BSY_Pos)     /* 0x00010000 */
.equiv FLASH_SR_BSY,         FLASH_SR_BSY_Msk

/*******************  Bits definition for FLASH_CR register  ******************/
.equiv FLASH_CR_PG_Pos,         (0)
.equiv FLASH_CR_PG_Msk,         (0x1 << FLASH_CR_PG_Pos)         /* 0x00000001 */
.equiv FLASH_CR_PG,             FLASH_CR_PG_Msk
.equiv FLASH_CR_PER_Pos,        (1)
.equiv FLASH_CR_PER_Msk,        (0x1 << FLASH_CR_PER_Pos)        /* 0x00000002 */
.equiv FLASH_CR_PER,            FLASH_CR_PER_Msk
.equiv FLASH_CR_MER_Pos,        (2)
.equiv FLASH_CR_MER_Msk,        (0x1 << FLASH_CR_MER_Pos)        /* 0x00000004 */
.equiv FLASH_CR_MER,            FLASH_CR_MER_Msk
.equiv FLASH_CR_SER_Pos,        (11)
.equiv FLASH_CR_SER_Msk,        (0x1 << FLASH_CR_SER_Pos)        /* 0x00000800 */
.equiv FLASH_CR_SER,            FLASH_CR_SER_Msk
.equiv FLASH_CR_OPTSTRT_Pos,    (17)
.equiv FLASH_CR_OPTSTRT_Msk,    (0x1 << FLASH_CR_OPTSTRT_Pos)    /* 0x00020000 */
.equiv FLASH_CR_OPTSTRT,        FLASH_CR_OPTSTRT_Msk
.equiv FLASH_CR_PGSTRT_Pos,     (19)
.equiv FLASH_CR_PGSTRT_Msk,     (0x1 << FLASH_CR_PGSTRT_Pos)     /* 0x00080000 */
.equiv FLASH_CR_PGSTRT,         FLASH_CR_PGSTRT_Msk
.equiv FLASH_CR_EOPIE_Pos,      (24)
.equiv FLASH_CR_EOPIE_Msk,      (0x1 << FLASH_CR_EOPIE_Pos)      /* 0x01000000 */
.equiv FLASH_CR_EOPIE,          FLASH_CR_EOPIE_Msk
.equiv FLASH_CR_ERRIE_Pos,      (25)
.equiv FLASH_CR_ERRIE_Msk,      (0x1 << FLASH_CR_ERRIE_Pos)      /* 0x02000000 */
.equiv FLASH_CR_ERRIE,          FLASH_CR_ERRIE_Msk
.equiv FLASH_CR_OBL_LAUNCH_Pos, (27)
.equiv FLASH_CR_OBL_LAUNCH_Msk, (0x1 << FLASH_CR_OBL_LAUNCH_Pos) /* 0x08000000 */
.equiv FLASH_CR_OBL_LAUNCH,     FLASH_CR_OBL_LAUNCH_Msk
.equiv FLASH_CR_OPTLOCK_Pos,    (30)
.equiv FLASH_CR_OPTLOCK_Msk,    (0x1 << FLASH_CR_OPTLOCK_Pos)    /* 0x40000000 */
.equiv FLASH_CR_OPTLOCK,        FLASH_CR_OPTLOCK_Msk
.equiv FLASH_CR_LOCK_Pos,       (31)
.equiv FLASH_CR_LOCK_Msk,       (0x1 << FLASH_CR_LOCK_Pos)       /* 0x80000000 */
.equiv FLASH_CR_LOCK,           FLASH_CR_LOCK_Msk

/*******************  Bits definition for FLASH_OPTR register  ****************/
.equiv FLASH_OPTR_RDP_Pos,       (0)
.equiv FLASH_OPTR_RDP_Msk,       (0xFF << FLASH_OPTR_RDP_Pos)
.equiv FLASH_OPTR_RDP,           FLASH_OPTR_RDP_Msk
.equiv FLASH_OPTR_BOR_EN_Pos,    (8)
.equiv FLASH_OPTR_BOR_EN_Msk,    (0x1 << FLASH_OPTR_BOR_EN_Pos)    /* 0x00000100 */
.equiv FLASH_OPTR_BOR_EN,        FLASH_OPTR_BOR_EN_Msk
.equiv FLASH_OPTR_BOR_LEV_Pos,   (9)
.equiv FLASH_OPTR_BOR_LEV_Msk,   (0x7 << FLASH_OPTR_BOR_LEV_Pos)   /* 0x00000E00 */
.equiv FLASH_OPTR_BOR_LEV,       FLASH_OPTR_BOR_LEV_Msk
.equiv FLASH_OPTR_BOR_LEV_0,     (0x1 << FLASH_OPTR_BOR_LEV_Pos)   /* 0x00000200 */
.equiv FLASH_OPTR_BOR_LEV_1,     (0x2 << FLASH_OPTR_BOR_LEV_Pos)   /* 0x00000400 */
.equiv FLASH_OPTR_BOR_LEV_2,     (0x4 << FLASH_OPTR_BOR_LEV_Pos)   /* 0x00000800 */
.equiv FLASH_OPTR_IWDG_SW_Pos,   (12)
.equiv FLASH_OPTR_IWDG_SW_Msk,   (0x1 << FLASH_OPTR_IWDG_SW_Pos)   /* 0x00010000 */
.equiv FLASH_OPTR_IWDG_SW,       FLASH_OPTR_IWDG_SW_Msk
.equiv FLASH_OPTR_NRST_MODE_Pos, (14)
.equiv FLASH_OPTR_NRST_MODE_Msk, (0x1 << FLASH_OPTR_NRST_MODE_Pos) /* 0x08000000 */
.equiv FLASH_OPTR_NRST_MODE,     FLASH_OPTR_NRST_MODE_Msk
.equiv FLASH_OPTR_nBOOT1_Pos,    (15)
.equiv FLASH_OPTR_nBOOT1_Msk,    (0x1 << FLASH_OPTR_nBOOT1_Pos)    /* 0x02000000 */
.equiv FLASH_OPTR_nBOOT1,        FLASH_OPTR_nBOOT1_Msk

.equiv FLASH_OPTR_RDP_LEVEL_0,   (0xAA)
.equiv FLASH_OPTR_RDP_LEVEL_1,   (0x55)

/*******************  Bits definition for FLASH_SDKR register  ****************/
.equiv FLASH_SDKR_SDK_STRT_Pos, (0)
.equiv FLASH_SDKR_SDK_STRT_Msk, (0x1F << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_STRT,     FLASH_SDKR_SDK_STRT_Msk
.equiv FLASH_SDKR_SDK_STRT_0,   (0x01 << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_STRT_1,   (0x02 << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_STRT_2,   (0x04 << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_STRT_3,   (0x08 << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_STRT_4,   (0x10 << FLASH_SDKR_SDK_STRT_Pos)
.equiv FLASH_SDKR_SDK_END_Pos,  (8)
.equiv FLASH_SDKR_SDK_END_Msk,  (0x1F << FLASH_SDKR_SDK_END_Pos)
.equiv FLASH_SDKR_SDK_END,      FLASH_SDKR_SDK_END_Msk
.equiv FLASH_SDKR_SDK_END_0,    (0x01 << FLASH_SDKR_SDK_END_Pos)
.equiv FLASH_SDKR_SDK_END_1,    (0x02 << FLASH_SDKR_SDK_END_Pos)
.equiv FLASH_SDKR_SDK_END_2,    (0x04 << FLASH_SDKR_SDK_END_Pos)
.equiv FLASH_SDKR_SDK_END_3,    (0x08 << FLASH_SDKR_SDK_END_Pos)
.equiv FLASH_SDKR_SDK_END_4,    (0x10 << FLASH_SDKR_SDK_END_Pos)

/******************  Bits definition for FLASH_WRPR register  ***************/
.equiv FLASH_WRPR_WRP_Pos, (0)
.equiv FLASH_WRPR_WRP_Msk, (0xFFFF << FLASH_WRPR_WRP_Pos) /* 0x0000FFFF */
.equiv FLASH_WRPR_WRP,     FLASH_WRPR_WRP_Msk
.equiv FLASH_WRPR_WRP_0,   (0x0001 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_1,   (0x0002 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_2,   (0x0004 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_3,   (0x0008 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_4,   (0x0010 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_5,   (0x0020 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_6,   (0x0040 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_7,   (0x0080 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_8,   (0x0100 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_9,   (0x0200 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_10,  (0x0400 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_11,  (0x0800 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_12,  (0x1000 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_13,  (0x2000 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_14,  (0x4000 << FLASH_WRPR_WRP_Pos)
.equiv FLASH_WRPR_WRP_15,  (0x8000 << FLASH_WRPR_WRP_Pos)

/******************  Bits definition for FLASH_STCR register  ***************/
.equiv FLASH_STCR_SLEEP_EN_Pos,   (0)
.equiv FLASH_STCR_SLEEP_EN_Msk,   (0x1 << FLASH_STCR_SLEEP_EN_Pos)
.equiv FLASH_STCR_SLEEP_EN,       FLASH_STCR_SLEEP_EN_Msk
.equiv FLASH_STCR_SLEEP_TIME_Pos, (8)
.equiv FLASH_STCR_SLEEP_TIME_Msk, (0xFF << FLASH_STCR_SLEEP_TIME_Pos)
.equiv FLASH_STCR_SLEEP_TIME,     FLASH_STCR_SLEEP_TIME_Msk

/******************  Bits definition for FLASH_TS0 register  ***************/
.equiv FLASH_TS0_TS0_Pos, (0)
.equiv FLASH_TS0_TS0_Msk, (0xFF << FLASH_TS0_TS0_Pos) /* 0x000000FF */
.equiv FLASH_TS0_TS0,     FLASH_TS0_TS0_Msk
.equiv FLASH_TS0_TS0_0,   (0x0001 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_1,   (0x0002 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_2,   (0x0004 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_3,   (0x0008 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_4,   (0x0010 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_5,   (0x0020 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_6,   (0x0040 << FLASH_TS0_TS0_Pos)
.equiv FLASH_TS0_TS0_7,   (0x0080 << FLASH_TS0_TS0_Pos)

/******************  Bits definition for FLASH_TS1 register  ***************/
.equiv FLASH_TS1_TS1_Pos, (0)
.equiv FLASH_TS1_TS1_Msk, (0xFF << FLASH_TS1_TS1_Pos)   /* 0x000000FF */
.equiv FLASH_TS1_TS1,     FLASH_TS1_TS1_Msk
.equiv FLASH_TS1_TS1_0,   (0x0001 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_1,   (0x0002 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_2,   (0x0004 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_3,   (0x0008 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_4,   (0x0010 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_5,   (0x0020 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_6,   (0x0040 << FLASH_TS1_TS1_Pos)
.equiv FLASH_TS1_TS1_7,   (0x0080 << FLASH_TS1_TS1_Pos)

/******************  Bits definition for FLASH_TS2P register  ***************/
.equiv FLASH_TS2P_TS2P_Pos, (0)
.equiv FLASH_TS2P_TS2P_Msk, (0xFF << FLASH_TS2P_TS2P_Pos)   /* 0x000000FF */
.equiv FLASH_TS2P_TS2P,     FLASH_TS2P_TS2P_Msk
.equiv FLASH_TS2P_TS2P_0,   (0x0001 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_1,   (0x0002 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_2,   (0x0004 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_3,   (0x0008 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_4,   (0x0010 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_5,   (0x0020 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_6,   (0x0040 << FLASH_TS2P_TS2P_Pos)
.equiv FLASH_TS2P_TS2P_7,   (0x0080 << FLASH_TS2P_TS2P_Pos)

/******************  Bits definition for FLASH_TPS3 register  ***************/
.equiv FLASH_TPS3_TPS3_Pos, (0)
.equiv FLASH_TPS3_TPS3_Msk, (0x7FF << FLASH_TPS3_TPS3_Pos)   /* 0x000007FF */
.equiv FLASH_TPS3_TPS3,     FLASH_TPS3_TPS3_Msk
.equiv FLASH_TPS3_TPS3_0,   (0x0001 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_1,   (0x0002 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_2,   (0x0004 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_3,   (0x0008 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_4,   (0x0010 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_5,   (0x0020 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_6,   (0x0040 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_7,   (0x0080 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_8,   (0x0100 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_9,   (0x0200 << FLASH_TPS3_TPS3_Pos)
.equiv FLASH_TPS3_TPS3_10,  (0x0400 << FLASH_TPS3_TPS3_Pos)

/******************  Bits definition for FLASH_TS3 register  ***************/
.equiv FLASH_TS3_TS3_Pos, (0)
.equiv FLASH_TS3_TS3_Msk, (0xFF << FLASH_TS3_TS3_Pos)   /* 0x000000FF */
.equiv FLASH_TS3_TS3,     FLASH_TS3_TS3_Msk
.equiv FLASH_TS3_TS3_0,   (0x0001 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_1,   (0x0002 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_2,   (0x0004 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_3,   (0x0008 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_4,   (0x0010 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_5,   (0x0020 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_6,   (0x0040 << FLASH_TS3_TS3_Pos)
.equiv FLASH_TS3_TS3_7,   (0x0080 << FLASH_TS3_TS3_Pos)

/******************  Bits definition for FLASH_PERTPE register  ***************/
.equiv FLASH_PERTPE_PERTPE_Pos, (0)
.equiv FLASH_PERTPE_PERTPE_Msk, (0x1FFFF << FLASH_PERTPE_PERTPE_Pos) /* 0x0001FFFF */
.equiv FLASH_PERTPE_PERTPE,     FLASH_PERTPE_PERTPE_Msk
.equiv FLASH_PERTPE_PERTPE_0,   (0x00001 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_1,   (0x00002 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_2,   (0x00004 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_3,   (0x00008 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_4,   (0x00010 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_5,   (0x00020 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_6,   (0x00040 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_7,   (0x00080 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_8,   (0x00100 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_9,   (0x00200 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_10,  (0x00400 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_11,  (0x00800 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_12,  (0x01000 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_13,  (0x02000 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_14,  (0x04000 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_15,  (0x08000 << FLASH_PERTPE_PERTPE_Pos)
.equiv FLASH_PERTPE_PERTPE_16,  (0x10000 << FLASH_PERTPE_PERTPE_Pos)

/******************  Bits definition for FLASH_SMERTPE register  ***************/
.equiv FLASH_SMERTPE_SMERTPE_Pos, (0)
.equiv FLASH_SMERTPE_SMERTPE_Msk, (0x1FFFF << FLASH_SMERTPE_SMERTPE_Pos) /* 0x0001FFFF */
.equiv FLASH_SMERTPE_SMERTPE,     FLASH_SMERTPE_SMERTPE_Msk
.equiv FLASH_SMERTPE_SMERTPE_0,   (0x00001 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_1,   (0x00002 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_2,   (0x00004 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_3,   (0x00008 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_4,   (0x00010 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_5,   (0x00020 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_6,   (0x00040 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_7,   (0x00080 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_8,   (0x00100 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_9,   (0x00200 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_10,  (0x00400 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_11,  (0x00800 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_12,  (0x01000 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_13,  (0x02000 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_14,  (0x04000 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_15,  (0x08000 << FLASH_SMERTPE_SMERTPE_Pos)
.equiv FLASH_SMERTPE_SMERTPE_16,  (0x10000 << FLASH_SMERTPE_SMERTPE_Pos)

/******************  Bits definition for FLASH_PRGTPE register  ***************/
.equiv FLASH_PRGTPE_PRGTPE_Pos, (0)
.equiv FLASH_PRGTPE_PRGTPE_Msk, (0xFFFF << FLASH_PRGTPE_PRGTPE_Pos) /* 0x0000FFFF */
.equiv FLASH_PRGTPE_PRGTPE,     FLASH_PRGTPE_PRGTPE_Msk
.equiv FLASH_PRGTPE_PRGTPE_0,   (0x0001 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_1,   (0x0002 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_2,   (0x0004 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_3,   (0x0008 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_4,   (0x0010 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_5,   (0x0020 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_6,   (0x0040 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_7,   (0x0080 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_8,   (0x0100 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_9,   (0x0200 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_10,  (0x0400 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_11,  (0x0800 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_12,  (0x1000 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_13,  (0x2000 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_14,  (0x4000 << FLASH_PRGTPE_PRGTPE_Pos)
.equiv FLASH_PRGTPE_PRGTPE_15,  (0x8000 << FLASH_PRGTPE_PRGTPE_Pos)

/******************  Bits definition for FLASH_PRETPE register  ***************/
.equiv FLASH_PRETPE_PRETPE_Pos, (0)
.equiv FLASH_PRETPE_PRETPE_Msk, (0x3FFF << FLASH_PRETPE_PRETPE_Pos) /* 0x00003FFF */
.equiv FLASH_PRETPE_PRETPE,     FLASH_PRETPE_PRETPE_Msk
.equiv FLASH_PRETPE_PRETPE_0,   (0x0001 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_1,   (0x0002 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_2,   (0x0004 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_3,   (0x0008 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_4,   (0x0010 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_5,   (0x0020 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_6,   (0x0040 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_7,   (0x0080 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_8,   (0x0100 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_9,   (0x0200 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_10,  (0x0400 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_11,  (0x0800 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_12,  (0x1000 << FLASH_PRETPE_PRETPE_Pos)
.equiv FLASH_PRETPE_PRETPE_13,  (0x2000 << FLASH_PRETPE_PRETPE_Pos)

/******************************************************************************/
/*                                                                            */
/*                            General Purpose I/O (GPIO)                      */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
.equiv GPIO_MODER_MODE0_Pos,  (0)
.equiv GPIO_MODER_MODE0_Msk,  (0x3 << GPIO_MODER_MODE0_Pos)  /* 0x00000003 */
.equiv GPIO_MODER_MODE0,      GPIO_MODER_MODE0_Msk
.equiv GPIO_MODER_MODE0_0,    (0x1 << GPIO_MODER_MODE0_Pos)  /* 0x00000001 */
.equiv GPIO_MODER_MODE0_1,    (0x2 << GPIO_MODER_MODE0_Pos)  /* 0x00000002 */
.equiv GPIO_MODER_MODE1_Pos,  (2)
.equiv GPIO_MODER_MODE1_Msk,  (0x3 << GPIO_MODER_MODE1_Pos)  /* 0x0000000C */
.equiv GPIO_MODER_MODE1,      GPIO_MODER_MODE1_Msk
.equiv GPIO_MODER_MODE1_0,    (0x1 << GPIO_MODER_MODE1_Pos)  /* 0x00000004 */
.equiv GPIO_MODER_MODE1_1,    (0x2 << GPIO_MODER_MODE1_Pos)  /* 0x00000008 */
.equiv GPIO_MODER_MODE2_Pos,  (4)
.equiv GPIO_MODER_MODE2_Msk,  (0x3 << GPIO_MODER_MODE2_Pos)  /* 0x00000030 */
.equiv GPIO_MODER_MODE2,      GPIO_MODER_MODE2_Msk
.equiv GPIO_MODER_MODE2_0,    (0x1 << GPIO_MODER_MODE2_Pos)  /* 0x00000010 */
.equiv GPIO_MODER_MODE2_1,    (0x2 << GPIO_MODER_MODE2_Pos)  /* 0x00000020 */
.equiv GPIO_MODER_MODE3_Pos,  (6)
.equiv GPIO_MODER_MODE3_Msk,  (0x3 << GPIO_MODER_MODE3_Pos)  /* 0x000000C0 */
.equiv GPIO_MODER_MODE3,      GPIO_MODER_MODE3_Msk
.equiv GPIO_MODER_MODE3_0,    (0x1 << GPIO_MODER_MODE3_Pos)  /* 0x00000040 */
.equiv GPIO_MODER_MODE3_1,    (0x2 << GPIO_MODER_MODE3_Pos)  /* 0x00000080 */
.equiv GPIO_MODER_MODE4_Pos,  (8)
.equiv GPIO_MODER_MODE4_Msk,  (0x3 << GPIO_MODER_MODE4_Pos)  /* 0x00000300 */
.equiv GPIO_MODER_MODE4,      GPIO_MODER_MODE4_Msk
.equiv GPIO_MODER_MODE4_0,    (0x1 << GPIO_MODER_MODE4_Pos)  /* 0x00000100 */
.equiv GPIO_MODER_MODE4_1,    (0x2 << GPIO_MODER_MODE4_Pos)  /* 0x00000200 */
.equiv GPIO_MODER_MODE5_Pos,  (10)
.equiv GPIO_MODER_MODE5_Msk,  (0x3 << GPIO_MODER_MODE5_Pos)  /* 0x00000C00 */
.equiv GPIO_MODER_MODE5,      GPIO_MODER_MODE5_Msk
.equiv GPIO_MODER_MODE5_0,    (0x1 << GPIO_MODER_MODE5_Pos)  /* 0x00000400 */
.equiv GPIO_MODER_MODE5_1,    (0x2 << GPIO_MODER_MODE5_Pos)  /* 0x00000800 */
.equiv GPIO_MODER_MODE6_Pos,  (12)
.equiv GPIO_MODER_MODE6_Msk,  (0x3 << GPIO_MODER_MODE6_Pos)  /* 0x00003000 */
.equiv GPIO_MODER_MODE6,      GPIO_MODER_MODE6_Msk
.equiv GPIO_MODER_MODE6_0,    (0x1 << GPIO_MODER_MODE6_Pos)  /* 0x00001000 */
.equiv GPIO_MODER_MODE6_1,    (0x2 << GPIO_MODER_MODE6_Pos)  /* 0x00002000 */
.equiv GPIO_MODER_MODE7_Pos,  (14)
.equiv GPIO_MODER_MODE7_Msk,  (0x3 << GPIO_MODER_MODE7_Pos)  /* 0x0000C000 */
.equiv GPIO_MODER_MODE7,      GPIO_MODER_MODE7_Msk
.equiv GPIO_MODER_MODE7_0,    (0x1 << GPIO_MODER_MODE7_Pos)  /* 0x00004000 */
.equiv GPIO_MODER_MODE7_1,    (0x2 << GPIO_MODER_MODE7_Pos)  /* 0x00008000 */
.equiv GPIO_MODER_MODE8_Pos,  (16)
.equiv GPIO_MODER_MODE8_Msk,  (0x3 << GPIO_MODER_MODE8_Pos)  /* 0x00030000 */
.equiv GPIO_MODER_MODE8,      GPIO_MODER_MODE8_Msk
.equiv GPIO_MODER_MODE8_0,    (0x1 << GPIO_MODER_MODE8_Pos)  /* 0x00010000 */
.equiv GPIO_MODER_MODE8_1,    (0x2 << GPIO_MODER_MODE8_Pos)  /* 0x00020000 */
.equiv GPIO_MODER_MODE9_Pos,  (18)
.equiv GPIO_MODER_MODE9_Msk,  (0x3 << GPIO_MODER_MODE9_Pos)  /* 0x000C0000 */
.equiv GPIO_MODER_MODE9,      GPIO_MODER_MODE9_Msk
.equiv GPIO_MODER_MODE9_0,    (0x1 << GPIO_MODER_MODE9_Pos)  /* 0x00040000 */
.equiv GPIO_MODER_MODE9_1,    (0x2 << GPIO_MODER_MODE9_Pos)  /* 0x00080000 */
.equiv GPIO_MODER_MODE10_Pos, (20)
.equiv GPIO_MODER_MODE10_Msk, (0x3 << GPIO_MODER_MODE10_Pos) /* 0x00300000 */
.equiv GPIO_MODER_MODE10,     GPIO_MODER_MODE10_Msk
.equiv GPIO_MODER_MODE10_0,   (0x1 << GPIO_MODER_MODE10_Pos) /* 0x00100000 */
.equiv GPIO_MODER_MODE10_1,   (0x2 << GPIO_MODER_MODE10_Pos) /* 0x00200000 */
.equiv GPIO_MODER_MODE11_Pos, (22)
.equiv GPIO_MODER_MODE11_Msk, (0x3 << GPIO_MODER_MODE11_Pos) /* 0x00C00000 */
.equiv GPIO_MODER_MODE11,     GPIO_MODER_MODE11_Msk
.equiv GPIO_MODER_MODE11_0,   (0x1 << GPIO_MODER_MODE11_Pos) /* 0x00400000 */
.equiv GPIO_MODER_MODE11_1,   (0x2 << GPIO_MODER_MODE11_Pos) /* 0x00800000 */
.equiv GPIO_MODER_MODE12_Pos, (24)
.equiv GPIO_MODER_MODE12_Msk, (0x3 << GPIO_MODER_MODE12_Pos) /* 0x03000000 */
.equiv GPIO_MODER_MODE12,     GPIO_MODER_MODE12_Msk
.equiv GPIO_MODER_MODE12_0,   (0x1 << GPIO_MODER_MODE12_Pos) /* 0x01000000 */
.equiv GPIO_MODER_MODE12_1,   (0x2 << GPIO_MODER_MODE12_Pos) /* 0x02000000 */
.equiv GPIO_MODER_MODE13_Pos, (26)
.equiv GPIO_MODER_MODE13_Msk, (0x3 << GPIO_MODER_MODE13_Pos) /* 0x0C000000 */
.equiv GPIO_MODER_MODE13,     GPIO_MODER_MODE13_Msk
.equiv GPIO_MODER_MODE13_0,   (0x1 << GPIO_MODER_MODE13_Pos) /* 0x04000000 */
.equiv GPIO_MODER_MODE13_1,   (0x2 << GPIO_MODER_MODE13_Pos) /* 0x08000000 */
.equiv GPIO_MODER_MODE14_Pos, (28)
.equiv GPIO_MODER_MODE14_Msk, (0x3 << GPIO_MODER_MODE14_Pos) /* 0x30000000 */
.equiv GPIO_MODER_MODE14,     GPIO_MODER_MODE14_Msk
.equiv GPIO_MODER_MODE14_0,   (0x1 << GPIO_MODER_MODE14_Pos) /* 0x10000000 */
.equiv GPIO_MODER_MODE14_1,   (0x2 << GPIO_MODER_MODE14_Pos) /* 0x20000000 */
.equiv GPIO_MODER_MODE15_Pos, (30)
.equiv GPIO_MODER_MODE15_Msk, (0x3 << GPIO_MODER_MODE15_Pos) /* 0xC0000000 */
.equiv GPIO_MODER_MODE15,     GPIO_MODER_MODE15_Msk
.equiv GPIO_MODER_MODE15_0,   (0x1 << GPIO_MODER_MODE15_Pos) /* 0x40000000 */
.equiv GPIO_MODER_MODE15_1,   (0x2 << GPIO_MODER_MODE15_Pos) /* 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
.equiv GPIO_OTYPER_OT0_Pos,  (0)
.equiv GPIO_OTYPER_OT0_Msk,  (0x1 << GPIO_OTYPER_OT0_Pos)  /* 0x00000001 */
.equiv GPIO_OTYPER_OT0,      GPIO_OTYPER_OT0_Msk
.equiv GPIO_OTYPER_OT1_Pos,  (1)
.equiv GPIO_OTYPER_OT1_Msk,  (0x1 << GPIO_OTYPER_OT1_Pos)  /* 0x00000002 */
.equiv GPIO_OTYPER_OT1,      GPIO_OTYPER_OT1_Msk
.equiv GPIO_OTYPER_OT2_Pos,  (2)
.equiv GPIO_OTYPER_OT2_Msk,  (0x1 << GPIO_OTYPER_OT2_Pos)  /* 0x00000004 */
.equiv GPIO_OTYPER_OT2,      GPIO_OTYPER_OT2_Msk
.equiv GPIO_OTYPER_OT3_Pos,  (3)
.equiv GPIO_OTYPER_OT3_Msk,  (0x1 << GPIO_OTYPER_OT3_Pos)  /* 0x00000008 */
.equiv GPIO_OTYPER_OT3,      GPIO_OTYPER_OT3_Msk
.equiv GPIO_OTYPER_OT4_Pos,  (4)
.equiv GPIO_OTYPER_OT4_Msk,  (0x1 << GPIO_OTYPER_OT4_Pos)  /* 0x00000010 */
.equiv GPIO_OTYPER_OT4,      GPIO_OTYPER_OT4_Msk
.equiv GPIO_OTYPER_OT5_Pos,  (5)
.equiv GPIO_OTYPER_OT5_Msk,  (0x1 << GPIO_OTYPER_OT5_Pos)  /* 0x00000020 */
.equiv GPIO_OTYPER_OT5,      GPIO_OTYPER_OT5_Msk
.equiv GPIO_OTYPER_OT6_Pos,  (6)
.equiv GPIO_OTYPER_OT6_Msk,  (0x1 << GPIO_OTYPER_OT6_Pos)  /* 0x00000040 */
.equiv GPIO_OTYPER_OT6,      GPIO_OTYPER_OT6_Msk
.equiv GPIO_OTYPER_OT7_Pos,  (7)
.equiv GPIO_OTYPER_OT7_Msk,  (0x1 << GPIO_OTYPER_OT7_Pos)  /* 0x00000080 */
.equiv GPIO_OTYPER_OT7,      GPIO_OTYPER_OT7_Msk
.equiv GPIO_OTYPER_OT8_Pos,  (8)
.equiv GPIO_OTYPER_OT8_Msk,  (0x1 << GPIO_OTYPER_OT8_Pos)  /* 0x00000100 */
.equiv GPIO_OTYPER_OT8,      GPIO_OTYPER_OT8_Msk
.equiv GPIO_OTYPER_OT9_Pos,  (9)
.equiv GPIO_OTYPER_OT9_Msk,  (0x1 << GPIO_OTYPER_OT9_Pos)  /* 0x00000200 */
.equiv GPIO_OTYPER_OT9,      GPIO_OTYPER_OT9_Msk
.equiv GPIO_OTYPER_OT10_Pos, (10)
.equiv GPIO_OTYPER_OT10_Msk, (0x1 << GPIO_OTYPER_OT10_Pos) /* 0x00000400 */
.equiv GPIO_OTYPER_OT10,     GPIO_OTYPER_OT10_Msk
.equiv GPIO_OTYPER_OT11_Pos, (11)
.equiv GPIO_OTYPER_OT11_Msk, (0x1 << GPIO_OTYPER_OT11_Pos) /* 0x00000800 */
.equiv GPIO_OTYPER_OT11,     GPIO_OTYPER_OT11_Msk
.equiv GPIO_OTYPER_OT12_Pos, (12)
.equiv GPIO_OTYPER_OT12_Msk, (0x1 << GPIO_OTYPER_OT12_Pos) /* 0x00001000 */
.equiv GPIO_OTYPER_OT12,     GPIO_OTYPER_OT12_Msk
.equiv GPIO_OTYPER_OT13_Pos, (13)
.equiv GPIO_OTYPER_OT13_Msk, (0x1 << GPIO_OTYPER_OT13_Pos) /* 0x00002000 */
.equiv GPIO_OTYPER_OT13,     GPIO_OTYPER_OT13_Msk
.equiv GPIO_OTYPER_OT14_Pos, (14)
.equiv GPIO_OTYPER_OT14_Msk, (0x1 << GPIO_OTYPER_OT14_Pos) /* 0x00004000 */
.equiv GPIO_OTYPER_OT14,     GPIO_OTYPER_OT14_Msk
.equiv GPIO_OTYPER_OT15_Pos, (15)
.equiv GPIO_OTYPER_OT15_Msk, (0x1 << GPIO_OTYPER_OT15_Pos) /* 0x00008000 */
.equiv GPIO_OTYPER_OT15,     GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
.equiv GPIO_OSPEEDR_OSPEED0_Pos,  (0)
.equiv GPIO_OSPEEDR_OSPEED0_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED0_Pos)  /* 0x00000003 */
.equiv GPIO_OSPEEDR_OSPEED0,      GPIO_OSPEEDR_OSPEED0_Msk
.equiv GPIO_OSPEEDR_OSPEED0_0,    (0x1 << GPIO_OSPEEDR_OSPEED0_Pos)  /* 0x00000001 */
.equiv GPIO_OSPEEDR_OSPEED0_1,    (0x2 << GPIO_OSPEEDR_OSPEED0_Pos)  /* 0x00000002 */
.equiv GPIO_OSPEEDR_OSPEED1_Pos,  (2)
.equiv GPIO_OSPEEDR_OSPEED1_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED1_Pos)  /* 0x0000000C */
.equiv GPIO_OSPEEDR_OSPEED1,      GPIO_OSPEEDR_OSPEED1_Msk
.equiv GPIO_OSPEEDR_OSPEED1_0,    (0x1 << GPIO_OSPEEDR_OSPEED1_Pos)  /* 0x00000004 */
.equiv GPIO_OSPEEDR_OSPEED1_1,    (0x2 << GPIO_OSPEEDR_OSPEED1_Pos)  /* 0x00000008 */
.equiv GPIO_OSPEEDR_OSPEED2_Pos,  (4)
.equiv GPIO_OSPEEDR_OSPEED2_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED2_Pos)  /* 0x00000030 */
.equiv GPIO_OSPEEDR_OSPEED2,      GPIO_OSPEEDR_OSPEED2_Msk
.equiv GPIO_OSPEEDR_OSPEED2_0,    (0x1 << GPIO_OSPEEDR_OSPEED2_Pos)  /* 0x00000010 */
.equiv GPIO_OSPEEDR_OSPEED2_1,    (0x2 << GPIO_OSPEEDR_OSPEED2_Pos)  /* 0x00000020 */
.equiv GPIO_OSPEEDR_OSPEED3_Pos,  (6)
.equiv GPIO_OSPEEDR_OSPEED3_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED3_Pos)  /* 0x000000C0 */
.equiv GPIO_OSPEEDR_OSPEED3,      GPIO_OSPEEDR_OSPEED3_Msk
.equiv GPIO_OSPEEDR_OSPEED3_0,    (0x1 << GPIO_OSPEEDR_OSPEED3_Pos)  /* 0x00000040 */
.equiv GPIO_OSPEEDR_OSPEED3_1,    (0x2 << GPIO_OSPEEDR_OSPEED3_Pos)  /* 0x00000080 */
.equiv GPIO_OSPEEDR_OSPEED4_Pos,  (8)
.equiv GPIO_OSPEEDR_OSPEED4_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED4_Pos)  /* 0x00000300 */
.equiv GPIO_OSPEEDR_OSPEED4,      GPIO_OSPEEDR_OSPEED4_Msk
.equiv GPIO_OSPEEDR_OSPEED4_0,    (0x1 << GPIO_OSPEEDR_OSPEED4_Pos)  /* 0x00000100 */
.equiv GPIO_OSPEEDR_OSPEED4_1,    (0x2 << GPIO_OSPEEDR_OSPEED4_Pos)  /* 0x00000200 */
.equiv GPIO_OSPEEDR_OSPEED5_Pos,  (10)
.equiv GPIO_OSPEEDR_OSPEED5_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED5_Pos)  /* 0x00000C00 */
.equiv GPIO_OSPEEDR_OSPEED5,      GPIO_OSPEEDR_OSPEED5_Msk
.equiv GPIO_OSPEEDR_OSPEED5_0,    (0x1 << GPIO_OSPEEDR_OSPEED5_Pos)  /* 0x00000400 */
.equiv GPIO_OSPEEDR_OSPEED5_1,    (0x2 << GPIO_OSPEEDR_OSPEED5_Pos)  /* 0x00000800 */
.equiv GPIO_OSPEEDR_OSPEED6_Pos,  (12)
.equiv GPIO_OSPEEDR_OSPEED6_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED6_Pos)  /* 0x00003000 */
.equiv GPIO_OSPEEDR_OSPEED6,      GPIO_OSPEEDR_OSPEED6_Msk
.equiv GPIO_OSPEEDR_OSPEED6_0,    (0x1 << GPIO_OSPEEDR_OSPEED6_Pos)  /* 0x00001000 */
.equiv GPIO_OSPEEDR_OSPEED6_1,    (0x2 << GPIO_OSPEEDR_OSPEED6_Pos)  /* 0x00002000 */
.equiv GPIO_OSPEEDR_OSPEED7_Pos,  (14)
.equiv GPIO_OSPEEDR_OSPEED7_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED7_Pos)  /* 0x0000C000 */
.equiv GPIO_OSPEEDR_OSPEED7,      GPIO_OSPEEDR_OSPEED7_Msk
.equiv GPIO_OSPEEDR_OSPEED7_0,    (0x1 << GPIO_OSPEEDR_OSPEED7_Pos)  /* 0x00004000 */
.equiv GPIO_OSPEEDR_OSPEED7_1,    (0x2 << GPIO_OSPEEDR_OSPEED7_Pos)  /* 0x00008000 */
.equiv GPIO_OSPEEDR_OSPEED8_Pos,  (16)
.equiv GPIO_OSPEEDR_OSPEED8_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED8_Pos)  /* 0x00030000 */
.equiv GPIO_OSPEEDR_OSPEED8,      GPIO_OSPEEDR_OSPEED8_Msk
.equiv GPIO_OSPEEDR_OSPEED8_0,    (0x1 << GPIO_OSPEEDR_OSPEED8_Pos)  /* 0x00010000 */
.equiv GPIO_OSPEEDR_OSPEED8_1,    (0x2 << GPIO_OSPEEDR_OSPEED8_Pos)  /* 0x00020000 */
.equiv GPIO_OSPEEDR_OSPEED9_Pos,  (18)
.equiv GPIO_OSPEEDR_OSPEED9_Msk,  (0x3 << GPIO_OSPEEDR_OSPEED9_Pos)  /* 0x000C0000 */
.equiv GPIO_OSPEEDR_OSPEED9,      GPIO_OSPEEDR_OSPEED9_Msk
.equiv GPIO_OSPEEDR_OSPEED9_0,    (0x1 << GPIO_OSPEEDR_OSPEED9_Pos)  /* 0x00040000 */
.equiv GPIO_OSPEEDR_OSPEED9_1,    (0x2 << GPIO_OSPEEDR_OSPEED9_Pos)  /* 0x00080000 */
.equiv GPIO_OSPEEDR_OSPEED10_Pos, (20)
.equiv GPIO_OSPEEDR_OSPEED10_Msk, (0x3 << GPIO_OSPEEDR_OSPEED10_Pos) /* 0x00300000 */
.equiv GPIO_OSPEEDR_OSPEED10,     GPIO_OSPEEDR_OSPEED10_Msk
.equiv GPIO_OSPEEDR_OSPEED10_0,   (0x1 << GPIO_OSPEEDR_OSPEED10_Pos) /* 0x00100000 */
.equiv GPIO_OSPEEDR_OSPEED10_1,   (0x2 << GPIO_OSPEEDR_OSPEED10_Pos) /* 0x00200000 */
.equiv GPIO_OSPEEDR_OSPEED11_Pos, (22)
.equiv GPIO_OSPEEDR_OSPEED11_Msk, (0x3 << GPIO_OSPEEDR_OSPEED11_Pos) /* 0x00C00000 */
.equiv GPIO_OSPEEDR_OSPEED11,     GPIO_OSPEEDR_OSPEED11_Msk
.equiv GPIO_OSPEEDR_OSPEED11_0,   (0x1 << GPIO_OSPEEDR_OSPEED11_Pos) /* 0x00400000 */
.equiv GPIO_OSPEEDR_OSPEED11_1,   (0x2 << GPIO_OSPEEDR_OSPEED11_Pos) /* 0x00800000 */
.equiv GPIO_OSPEEDR_OSPEED12_Pos, (24)
.equiv GPIO_OSPEEDR_OSPEED12_Msk, (0x3 << GPIO_OSPEEDR_OSPEED12_Pos) /* 0x03000000 */
.equiv GPIO_OSPEEDR_OSPEED12,     GPIO_OSPEEDR_OSPEED12_Msk
.equiv GPIO_OSPEEDR_OSPEED12_0,   (0x1 << GPIO_OSPEEDR_OSPEED12_Pos) /* 0x01000000 */
.equiv GPIO_OSPEEDR_OSPEED12_1,   (0x2 << GPIO_OSPEEDR_OSPEED12_Pos) /* 0x02000000 */
.equiv GPIO_OSPEEDR_OSPEED13_Pos, (26)
.equiv GPIO_OSPEEDR_OSPEED13_Msk, (0x3 << GPIO_OSPEEDR_OSPEED13_Pos) /* 0x0C000000 */
.equiv GPIO_OSPEEDR_OSPEED13,     GPIO_OSPEEDR_OSPEED13_Msk
.equiv GPIO_OSPEEDR_OSPEED13_0,   (0x1 << GPIO_OSPEEDR_OSPEED13_Pos) /* 0x04000000 */
.equiv GPIO_OSPEEDR_OSPEED13_1,   (0x2 << GPIO_OSPEEDR_OSPEED13_Pos) /* 0x08000000 */
.equiv GPIO_OSPEEDR_OSPEED14_Pos, (28)
.equiv GPIO_OSPEEDR_OSPEED14_Msk, (0x3 << GPIO_OSPEEDR_OSPEED14_Pos) /* 0x30000000 */
.equiv GPIO_OSPEEDR_OSPEED14,     GPIO_OSPEEDR_OSPEED14_Msk
.equiv GPIO_OSPEEDR_OSPEED14_0,   (0x1 << GPIO_OSPEEDR_OSPEED14_Pos) /* 0x10000000 */
.equiv GPIO_OSPEEDR_OSPEED14_1,   (0x2 << GPIO_OSPEEDR_OSPEED14_Pos) /* 0x20000000 */
.equiv GPIO_OSPEEDR_OSPEED15_Pos, (30)
.equiv GPIO_OSPEEDR_OSPEED15_Msk, (0x3 << GPIO_OSPEEDR_OSPEED15_Pos) /* 0xC0000000 */
.equiv GPIO_OSPEEDR_OSPEED15,     GPIO_OSPEEDR_OSPEED15_Msk
.equiv GPIO_OSPEEDR_OSPEED15_0,   (0x1 << GPIO_OSPEEDR_OSPEED15_Pos) /* 0x40000000 */
.equiv GPIO_OSPEEDR_OSPEED15_1,   (0x2 << GPIO_OSPEEDR_OSPEED15_Pos) /* 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
.equiv GPIO_PUPDR_PUPD0_Pos,  (0)
.equiv GPIO_PUPDR_PUPD0_Msk,  (0x3 << GPIO_PUPDR_PUPD0_Pos)  /* 0x00000003 */
.equiv GPIO_PUPDR_PUPD0,      GPIO_PUPDR_PUPD0_Msk
.equiv GPIO_PUPDR_PUPD0_0,    (0x1 << GPIO_PUPDR_PUPD0_Pos)  /* 0x00000001 */
.equiv GPIO_PUPDR_PUPD0_1,    (0x2 << GPIO_PUPDR_PUPD0_Pos)  /* 0x00000002 */
.equiv GPIO_PUPDR_PUPD1_Pos,  (2)
.equiv GPIO_PUPDR_PUPD1_Msk,  (0x3 << GPIO_PUPDR_PUPD1_Pos)  /* 0x0000000C */
.equiv GPIO_PUPDR_PUPD1,      GPIO_PUPDR_PUPD1_Msk
.equiv GPIO_PUPDR_PUPD1_0,    (0x1 << GPIO_PUPDR_PUPD1_Pos)  /* 0x00000004 */
.equiv GPIO_PUPDR_PUPD1_1,    (0x2 << GPIO_PUPDR_PUPD1_Pos)  /* 0x00000008 */
.equiv GPIO_PUPDR_PUPD2_Pos,  (4)
.equiv GPIO_PUPDR_PUPD2_Msk,  (0x3 << GPIO_PUPDR_PUPD2_Pos)  /* 0x00000030 */
.equiv GPIO_PUPDR_PUPD2,      GPIO_PUPDR_PUPD2_Msk
.equiv GPIO_PUPDR_PUPD2_0,    (0x1 << GPIO_PUPDR_PUPD2_Pos)  /* 0x00000010 */
.equiv GPIO_PUPDR_PUPD2_1,    (0x2 << GPIO_PUPDR_PUPD2_Pos)  /* 0x00000020 */
.equiv GPIO_PUPDR_PUPD3_Pos,  (6)
.equiv GPIO_PUPDR_PUPD3_Msk,  (0x3 << GPIO_PUPDR_PUPD3_Pos)  /* 0x000000C0 */
.equiv GPIO_PUPDR_PUPD3,      GPIO_PUPDR_PUPD3_Msk
.equiv GPIO_PUPDR_PUPD3_0,    (0x1 << GPIO_PUPDR_PUPD3_Pos)  /* 0x00000040 */
.equiv GPIO_PUPDR_PUPD3_1,    (0x2 << GPIO_PUPDR_PUPD3_Pos)  /* 0x00000080 */
.equiv GPIO_PUPDR_PUPD4_Pos,  (8)
.equiv GPIO_PUPDR_PUPD4_Msk,  (0x3 << GPIO_PUPDR_PUPD4_Pos)  /* 0x00000300 */
.equiv GPIO_PUPDR_PUPD4,      GPIO_PUPDR_PUPD4_Msk
.equiv GPIO_PUPDR_PUPD4_0,    (0x1 << GPIO_PUPDR_PUPD4_Pos)  /* 0x00000100 */
.equiv GPIO_PUPDR_PUPD4_1,    (0x2 << GPIO_PUPDR_PUPD4_Pos)  /* 0x00000200 */
.equiv GPIO_PUPDR_PUPD5_Pos,  (10)
.equiv GPIO_PUPDR_PUPD5_Msk,  (0x3 << GPIO_PUPDR_PUPD5_Pos)  /* 0x00000C00 */
.equiv GPIO_PUPDR_PUPD5,      GPIO_PUPDR_PUPD5_Msk
.equiv GPIO_PUPDR_PUPD5_0,    (0x1 << GPIO_PUPDR_PUPD5_Pos)  /* 0x00000400 */
.equiv GPIO_PUPDR_PUPD5_1,    (0x2 << GPIO_PUPDR_PUPD5_Pos)  /* 0x00000800 */
.equiv GPIO_PUPDR_PUPD6_Pos,  (12)
.equiv GPIO_PUPDR_PUPD6_Msk,  (0x3 << GPIO_PUPDR_PUPD6_Pos)  /* 0x00003000 */
.equiv GPIO_PUPDR_PUPD6,      GPIO_PUPDR_PUPD6_Msk
.equiv GPIO_PUPDR_PUPD6_0,    (0x1 << GPIO_PUPDR_PUPD6_Pos)  /* 0x00001000 */
.equiv GPIO_PUPDR_PUPD6_1,    (0x2 << GPIO_PUPDR_PUPD6_Pos)  /* 0x00002000 */
.equiv GPIO_PUPDR_PUPD7_Pos,  (14)
.equiv GPIO_PUPDR_PUPD7_Msk,  (0x3 << GPIO_PUPDR_PUPD7_Pos)  /* 0x0000C000 */
.equiv GPIO_PUPDR_PUPD7,      GPIO_PUPDR_PUPD7_Msk
.equiv GPIO_PUPDR_PUPD7_0,    (0x1 << GPIO_PUPDR_PUPD7_Pos)  /* 0x00004000 */
.equiv GPIO_PUPDR_PUPD7_1,    (0x2 << GPIO_PUPDR_PUPD7_Pos)  /* 0x00008000 */
.equiv GPIO_PUPDR_PUPD8_Pos,  (16)
.equiv GPIO_PUPDR_PUPD8_Msk,  (0x3 << GPIO_PUPDR_PUPD8_Pos)  /* 0x00030000 */
.equiv GPIO_PUPDR_PUPD8,      GPIO_PUPDR_PUPD8_Msk
.equiv GPIO_PUPDR_PUPD8_0,    (0x1 << GPIO_PUPDR_PUPD8_Pos)  /* 0x00010000 */
.equiv GPIO_PUPDR_PUPD8_1,    (0x2 << GPIO_PUPDR_PUPD8_Pos)  /* 0x00020000 */
.equiv GPIO_PUPDR_PUPD9_Pos,  (18)
.equiv GPIO_PUPDR_PUPD9_Msk,  (0x3 << GPIO_PUPDR_PUPD9_Pos)  /* 0x000C0000 */
.equiv GPIO_PUPDR_PUPD9,      GPIO_PUPDR_PUPD9_Msk
.equiv GPIO_PUPDR_PUPD9_0,    (0x1 << GPIO_PUPDR_PUPD9_Pos)  /* 0x00040000 */
.equiv GPIO_PUPDR_PUPD9_1,    (0x2 << GPIO_PUPDR_PUPD9_Pos)  /* 0x00080000 */
.equiv GPIO_PUPDR_PUPD10_Pos, (20)
.equiv GPIO_PUPDR_PUPD10_Msk, (0x3 << GPIO_PUPDR_PUPD10_Pos) /* 0x00300000 */
.equiv GPIO_PUPDR_PUPD10,     GPIO_PUPDR_PUPD10_Msk
.equiv GPIO_PUPDR_PUPD10_0,   (0x1 << GPIO_PUPDR_PUPD10_Pos) /* 0x00100000 */
.equiv GPIO_PUPDR_PUPD10_1,   (0x2 << GPIO_PUPDR_PUPD10_Pos) /* 0x00200000 */
.equiv GPIO_PUPDR_PUPD11_Pos, (22)
.equiv GPIO_PUPDR_PUPD11_Msk, (0x3 << GPIO_PUPDR_PUPD11_Pos) /* 0x00C00000 */
.equiv GPIO_PUPDR_PUPD11,     GPIO_PUPDR_PUPD11_Msk
.equiv GPIO_PUPDR_PUPD11_0,   (0x1 << GPIO_PUPDR_PUPD11_Pos) /* 0x00400000 */
.equiv GPIO_PUPDR_PUPD11_1,   (0x2 << GPIO_PUPDR_PUPD11_Pos) /* 0x00800000 */
.equiv GPIO_PUPDR_PUPD12_Pos, (24)
.equiv GPIO_PUPDR_PUPD12_Msk, (0x3 << GPIO_PUPDR_PUPD12_Pos) /* 0x03000000 */
.equiv GPIO_PUPDR_PUPD12,     GPIO_PUPDR_PUPD12_Msk
.equiv GPIO_PUPDR_PUPD12_0,   (0x1 << GPIO_PUPDR_PUPD12_Pos) /* 0x01000000 */
.equiv GPIO_PUPDR_PUPD12_1,   (0x2 << GPIO_PUPDR_PUPD12_Pos) /* 0x02000000 */
.equiv GPIO_PUPDR_PUPD13_Pos, (26)
.equiv GPIO_PUPDR_PUPD13_Msk, (0x3 << GPIO_PUPDR_PUPD13_Pos) /* 0x0C000000 */
.equiv GPIO_PUPDR_PUPD13,     GPIO_PUPDR_PUPD13_Msk
.equiv GPIO_PUPDR_PUPD13_0,   (0x1 << GPIO_PUPDR_PUPD13_Pos) /* 0x04000000 */
.equiv GPIO_PUPDR_PUPD13_1,   (0x2 << GPIO_PUPDR_PUPD13_Pos) /* 0x08000000 */
.equiv GPIO_PUPDR_PUPD14_Pos, (28)
.equiv GPIO_PUPDR_PUPD14_Msk, (0x3 << GPIO_PUPDR_PUPD14_Pos) /* 0x30000000 */
.equiv GPIO_PUPDR_PUPD14,     GPIO_PUPDR_PUPD14_Msk
.equiv GPIO_PUPDR_PUPD14_0,   (0x1 << GPIO_PUPDR_PUPD14_Pos) /* 0x10000000 */
.equiv GPIO_PUPDR_PUPD14_1,   (0x2 << GPIO_PUPDR_PUPD14_Pos) /* 0x20000000 */
.equiv GPIO_PUPDR_PUPD15_Pos, (30)
.equiv GPIO_PUPDR_PUPD15_Msk, (0x3 << GPIO_PUPDR_PUPD15_Pos) /* 0xC0000000 */
.equiv GPIO_PUPDR_PUPD15,     GPIO_PUPDR_PUPD15_Msk
.equiv GPIO_PUPDR_PUPD15_0,   (0x1 << GPIO_PUPDR_PUPD15_Pos) /* 0x40000000 */
.equiv GPIO_PUPDR_PUPD15_1,   (0x2 << GPIO_PUPDR_PUPD15_Pos) /* 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
.equiv GPIO_IDR_ID0_Pos,  (0)
.equiv GPIO_IDR_ID0_Msk,  (0x1 << GPIO_IDR_ID0_Pos)  /* 0x00000001 */
.equiv GPIO_IDR_ID0,      GPIO_IDR_ID0_Msk
.equiv GPIO_IDR_ID1_Pos,  (1)
.equiv GPIO_IDR_ID1_Msk,  (0x1 << GPIO_IDR_ID1_Pos)  /* 0x00000002 */
.equiv GPIO_IDR_ID1,      GPIO_IDR_ID1_Msk
.equiv GPIO_IDR_ID2_Pos,  (2)
.equiv GPIO_IDR_ID2_Msk,  (0x1 << GPIO_IDR_ID2_Pos)  /* 0x00000004 */
.equiv GPIO_IDR_ID2,      GPIO_IDR_ID2_Msk
.equiv GPIO_IDR_ID3_Pos,  (3)
.equiv GPIO_IDR_ID3_Msk,  (0x1 << GPIO_IDR_ID3_Pos)  /* 0x00000008 */
.equiv GPIO_IDR_ID3,      GPIO_IDR_ID3_Msk
.equiv GPIO_IDR_ID4_Pos,  (4)
.equiv GPIO_IDR_ID4_Msk,  (0x1 << GPIO_IDR_ID4_Pos)  /* 0x00000010 */
.equiv GPIO_IDR_ID4,      GPIO_IDR_ID4_Msk
.equiv GPIO_IDR_ID5_Pos,  (5)
.equiv GPIO_IDR_ID5_Msk,  (0x1 << GPIO_IDR_ID5_Pos)  /* 0x00000020 */
.equiv GPIO_IDR_ID5,      GPIO_IDR_ID5_Msk
.equiv GPIO_IDR_ID6_Pos,  (6)
.equiv GPIO_IDR_ID6_Msk,  (0x1 << GPIO_IDR_ID6_Pos)  /* 0x00000040 */
.equiv GPIO_IDR_ID6,      GPIO_IDR_ID6_Msk
.equiv GPIO_IDR_ID7_Pos,  (7)
.equiv GPIO_IDR_ID7_Msk,  (0x1 << GPIO_IDR_ID7_Pos)  /* 0x00000080 */
.equiv GPIO_IDR_ID7,      GPIO_IDR_ID7_Msk
.equiv GPIO_IDR_ID8_Pos,  (8)
.equiv GPIO_IDR_ID8_Msk,  (0x1 << GPIO_IDR_ID8_Pos)  /* 0x00000100 */
.equiv GPIO_IDR_ID8,      GPIO_IDR_ID8_Msk
.equiv GPIO_IDR_ID9_Pos,  (9)
.equiv GPIO_IDR_ID9_Msk,  (0x1 << GPIO_IDR_ID9_Pos)  /* 0x00000200 */
.equiv GPIO_IDR_ID9,      GPIO_IDR_ID9_Msk
.equiv GPIO_IDR_ID10_Pos, (10)
.equiv GPIO_IDR_ID10_Msk, (0x1 << GPIO_IDR_ID10_Pos) /* 0x00000400 */
.equiv GPIO_IDR_ID10,     GPIO_IDR_ID10_Msk
.equiv GPIO_IDR_ID11_Pos, (11)
.equiv GPIO_IDR_ID11_Msk, (0x1 << GPIO_IDR_ID11_Pos) /* 0x00000800 */
.equiv GPIO_IDR_ID11,     GPIO_IDR_ID11_Msk
.equiv GPIO_IDR_ID12_Pos, (12)
.equiv GPIO_IDR_ID12_Msk, (0x1 << GPIO_IDR_ID12_Pos) /* 0x00001000 */
.equiv GPIO_IDR_ID12,     GPIO_IDR_ID12_Msk
.equiv GPIO_IDR_ID13_Pos, (13)
.equiv GPIO_IDR_ID13_Msk, (0x1 << GPIO_IDR_ID13_Pos) /* 0x00002000 */
.equiv GPIO_IDR_ID13,     GPIO_IDR_ID13_Msk
.equiv GPIO_IDR_ID14_Pos, (14)
.equiv GPIO_IDR_ID14_Msk, (0x1 << GPIO_IDR_ID14_Pos) /* 0x00004000 */
.equiv GPIO_IDR_ID14,     GPIO_IDR_ID14_Msk
.equiv GPIO_IDR_ID15_Pos, (15)
.equiv GPIO_IDR_ID15_Msk, (0x1 << GPIO_IDR_ID15_Pos) /* 0x00008000 */
.equiv GPIO_IDR_ID15,     GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
.equiv GPIO_ODR_OD0_Pos,  (0)
.equiv GPIO_ODR_OD0_Msk,  (0x1 << GPIO_ODR_OD0_Pos)  /* 0x00000001 */
.equiv GPIO_ODR_OD0,      GPIO_ODR_OD0_Msk
.equiv GPIO_ODR_OD1_Pos,  (1)
.equiv GPIO_ODR_OD1_Msk,  (0x1 << GPIO_ODR_OD1_Pos)  /* 0x00000002 */
.equiv GPIO_ODR_OD1,      GPIO_ODR_OD1_Msk
.equiv GPIO_ODR_OD2_Pos,  (2)
.equiv GPIO_ODR_OD2_Msk,  (0x1 << GPIO_ODR_OD2_Pos)  /* 0x00000004 */
.equiv GPIO_ODR_OD2,      GPIO_ODR_OD2_Msk
.equiv GPIO_ODR_OD3_Pos,  (3)
.equiv GPIO_ODR_OD3_Msk,  (0x1 << GPIO_ODR_OD3_Pos)  /* 0x00000008 */
.equiv GPIO_ODR_OD3,      GPIO_ODR_OD3_Msk
.equiv GPIO_ODR_OD4_Pos,  (4)
.equiv GPIO_ODR_OD4_Msk,  (0x1 << GPIO_ODR_OD4_Pos)  /* 0x00000010 */
.equiv GPIO_ODR_OD4,      GPIO_ODR_OD4_Msk
.equiv GPIO_ODR_OD5_Pos,  (5)
.equiv GPIO_ODR_OD5_Msk,  (0x1 << GPIO_ODR_OD5_Pos)  /* 0x00000020 */
.equiv GPIO_ODR_OD5,      GPIO_ODR_OD5_Msk
.equiv GPIO_ODR_OD6_Pos,  (6)
.equiv GPIO_ODR_OD6_Msk,  (0x1 << GPIO_ODR_OD6_Pos)  /* 0x00000040 */
.equiv GPIO_ODR_OD6,      GPIO_ODR_OD6_Msk
.equiv GPIO_ODR_OD7_Pos,  (7)
.equiv GPIO_ODR_OD7_Msk,  (0x1 << GPIO_ODR_OD7_Pos)  /* 0x00000080 */
.equiv GPIO_ODR_OD7,      GPIO_ODR_OD7_Msk
.equiv GPIO_ODR_OD8_Pos,  (8)
.equiv GPIO_ODR_OD8_Msk,  (0x1 << GPIO_ODR_OD8_Pos)  /* 0x00000100 */
.equiv GPIO_ODR_OD8,      GPIO_ODR_OD8_Msk
.equiv GPIO_ODR_OD9_Pos,  (9)
.equiv GPIO_ODR_OD9_Msk,  (0x1 << GPIO_ODR_OD9_Pos)  /* 0x00000200 */
.equiv GPIO_ODR_OD9,      GPIO_ODR_OD9_Msk
.equiv GPIO_ODR_OD10_Pos, (10)
.equiv GPIO_ODR_OD10_Msk, (0x1 << GPIO_ODR_OD10_Pos) /* 0x00000400 */
.equiv GPIO_ODR_OD10,     GPIO_ODR_OD10_Msk
.equiv GPIO_ODR_OD11_Pos, (11)
.equiv GPIO_ODR_OD11_Msk, (0x1 << GPIO_ODR_OD11_Pos) /* 0x00000800 */
.equiv GPIO_ODR_OD11,     GPIO_ODR_OD11_Msk
.equiv GPIO_ODR_OD12_Pos, (12)
.equiv GPIO_ODR_OD12_Msk, (0x1 << GPIO_ODR_OD12_Pos) /* 0x00001000 */
.equiv GPIO_ODR_OD12,     GPIO_ODR_OD12_Msk
.equiv GPIO_ODR_OD13_Pos, (13)
.equiv GPIO_ODR_OD13_Msk, (0x1 << GPIO_ODR_OD13_Pos) /* 0x00002000 */
.equiv GPIO_ODR_OD13,     GPIO_ODR_OD13_Msk
.equiv GPIO_ODR_OD14_Pos, (14)
.equiv GPIO_ODR_OD14_Msk, (0x1 << GPIO_ODR_OD14_Pos) /* 0x00004000 */
.equiv GPIO_ODR_OD14,     GPIO_ODR_OD14_Msk
.equiv GPIO_ODR_OD15_Pos, (15)
.equiv GPIO_ODR_OD15_Msk, (0x1 << GPIO_ODR_OD15_Pos) /* 0x00008000 */
.equiv GPIO_ODR_OD15,     GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
.equiv GPIO_BSRR_BS0_Pos,  (0)
.equiv GPIO_BSRR_BS0_Msk,  (0x1 << GPIO_BSRR_BS0_Pos)  /* 0x00000001 */
.equiv GPIO_BSRR_BS0,      GPIO_BSRR_BS0_Msk
.equiv GPIO_BSRR_BS1_Pos,  (1)
.equiv GPIO_BSRR_BS1_Msk,  (0x1 << GPIO_BSRR_BS1_Pos)  /* 0x00000002 */
.equiv GPIO_BSRR_BS1,      GPIO_BSRR_BS1_Msk
.equiv GPIO_BSRR_BS2_Pos,  (2)
.equiv GPIO_BSRR_BS2_Msk,  (0x1 << GPIO_BSRR_BS2_Pos)  /* 0x00000004 */
.equiv GPIO_BSRR_BS2,      GPIO_BSRR_BS2_Msk
.equiv GPIO_BSRR_BS3_Pos,  (3)
.equiv GPIO_BSRR_BS3_Msk,  (0x1 << GPIO_BSRR_BS3_Pos)  /* 0x00000008 */
.equiv GPIO_BSRR_BS3,      GPIO_BSRR_BS3_Msk
.equiv GPIO_BSRR_BS4_Pos,  (4)
.equiv GPIO_BSRR_BS4_Msk,  (0x1 << GPIO_BSRR_BS4_Pos)  /* 0x00000010 */
.equiv GPIO_BSRR_BS4,      GPIO_BSRR_BS4_Msk
.equiv GPIO_BSRR_BS5_Pos,  (5)
.equiv GPIO_BSRR_BS5_Msk,  (0x1 << GPIO_BSRR_BS5_Pos)  /* 0x00000020 */
.equiv GPIO_BSRR_BS5,      GPIO_BSRR_BS5_Msk
.equiv GPIO_BSRR_BS6_Pos,  (6)
.equiv GPIO_BSRR_BS6_Msk,  (0x1 << GPIO_BSRR_BS6_Pos)  /* 0x00000040 */
.equiv GPIO_BSRR_BS6,      GPIO_BSRR_BS6_Msk
.equiv GPIO_BSRR_BS7_Pos,  (7)
.equiv GPIO_BSRR_BS7_Msk,  (0x1 << GPIO_BSRR_BS7_Pos)  /* 0x00000080 */
.equiv GPIO_BSRR_BS7,      GPIO_BSRR_BS7_Msk
.equiv GPIO_BSRR_BS8_Pos,  (8)
.equiv GPIO_BSRR_BS8_Msk,  (0x1 << GPIO_BSRR_BS8_Pos)  /* 0x00000100 */
.equiv GPIO_BSRR_BS8,      GPIO_BSRR_BS8_Msk
.equiv GPIO_BSRR_BS9_Pos,  (9)
.equiv GPIO_BSRR_BS9_Msk,  (0x1 << GPIO_BSRR_BS9_Pos)  /* 0x00000200 */
.equiv GPIO_BSRR_BS9,      GPIO_BSRR_BS9_Msk
.equiv GPIO_BSRR_BS10_Pos, (10)
.equiv GPIO_BSRR_BS10_Msk, (0x1 << GPIO_BSRR_BS10_Pos) /* 0x00000400 */
.equiv GPIO_BSRR_BS10,     GPIO_BSRR_BS10_Msk
.equiv GPIO_BSRR_BS11_Pos, (11)
.equiv GPIO_BSRR_BS11_Msk, (0x1 << GPIO_BSRR_BS11_Pos) /* 0x00000800 */
.equiv GPIO_BSRR_BS11,     GPIO_BSRR_BS11_Msk
.equiv GPIO_BSRR_BS12_Pos, (12)
.equiv GPIO_BSRR_BS12_Msk, (0x1 << GPIO_BSRR_BS12_Pos) /* 0x00001000 */
.equiv GPIO_BSRR_BS12,     GPIO_BSRR_BS12_Msk
.equiv GPIO_BSRR_BS13_Pos, (13)
.equiv GPIO_BSRR_BS13_Msk, (0x1 << GPIO_BSRR_BS13_Pos) /* 0x00002000 */
.equiv GPIO_BSRR_BS13,     GPIO_BSRR_BS13_Msk
.equiv GPIO_BSRR_BS14_Pos, (14)
.equiv GPIO_BSRR_BS14_Msk, (0x1 << GPIO_BSRR_BS14_Pos) /* 0x00004000 */
.equiv GPIO_BSRR_BS14,     GPIO_BSRR_BS14_Msk
.equiv GPIO_BSRR_BS15_Pos, (15)
.equiv GPIO_BSRR_BS15_Msk, (0x1 << GPIO_BSRR_BS15_Pos) /* 0x00008000 */
.equiv GPIO_BSRR_BS15,     GPIO_BSRR_BS15_Msk
.equiv GPIO_BSRR_BR0_Pos,  (16)
.equiv GPIO_BSRR_BR0_Msk,  (0x1 << GPIO_BSRR_BR0_Pos)  /* 0x00010000 */
.equiv GPIO_BSRR_BR0,      GPIO_BSRR_BR0_Msk
.equiv GPIO_BSRR_BR1_Pos,  (17)
.equiv GPIO_BSRR_BR1_Msk,  (0x1 << GPIO_BSRR_BR1_Pos)  /* 0x00020000 */
.equiv GPIO_BSRR_BR1,      GPIO_BSRR_BR1_Msk
.equiv GPIO_BSRR_BR2_Pos,  (18)
.equiv GPIO_BSRR_BR2_Msk,  (0x1 << GPIO_BSRR_BR2_Pos)  /* 0x00040000 */
.equiv GPIO_BSRR_BR2,      GPIO_BSRR_BR2_Msk
.equiv GPIO_BSRR_BR3_Pos,  (19)
.equiv GPIO_BSRR_BR3_Msk,  (0x1 << GPIO_BSRR_BR3_Pos)  /* 0x00080000 */
.equiv GPIO_BSRR_BR3,      GPIO_BSRR_BR3_Msk
.equiv GPIO_BSRR_BR4_Pos,  (20)
.equiv GPIO_BSRR_BR4_Msk,  (0x1 << GPIO_BSRR_BR4_Pos)  /* 0x00100000 */
.equiv GPIO_BSRR_BR4,      GPIO_BSRR_BR4_Msk
.equiv GPIO_BSRR_BR5_Pos,  (21)
.equiv GPIO_BSRR_BR5_Msk,  (0x1 << GPIO_BSRR_BR5_Pos)  /* 0x00200000 */
.equiv GPIO_BSRR_BR5,      GPIO_BSRR_BR5_Msk
.equiv GPIO_BSRR_BR6_Pos,  (22)
.equiv GPIO_BSRR_BR6_Msk,  (0x1 << GPIO_BSRR_BR6_Pos)  /* 0x00400000 */
.equiv GPIO_BSRR_BR6,      GPIO_BSRR_BR6_Msk
.equiv GPIO_BSRR_BR7_Pos,  (23)
.equiv GPIO_BSRR_BR7_Msk,  (0x1 << GPIO_BSRR_BR7_Pos)  /* 0x00800000 */
.equiv GPIO_BSRR_BR7,      GPIO_BSRR_BR7_Msk
.equiv GPIO_BSRR_BR8_Pos,  (24)
.equiv GPIO_BSRR_BR8_Msk,  (0x1 << GPIO_BSRR_BR8_Pos)  /* 0x01000000 */
.equiv GPIO_BSRR_BR8,      GPIO_BSRR_BR8_Msk
.equiv GPIO_BSRR_BR9_Pos,  (25)
.equiv GPIO_BSRR_BR9_Msk,  (0x1 << GPIO_BSRR_BR9_Pos)  /* 0x02000000 */
.equiv GPIO_BSRR_BR9,      GPIO_BSRR_BR9_Msk
.equiv GPIO_BSRR_BR10_Pos, (26)
.equiv GPIO_BSRR_BR10_Msk, (0x1 << GPIO_BSRR_BR10_Pos) /* 0x04000000 */
.equiv GPIO_BSRR_BR10,     GPIO_BSRR_BR10_Msk
.equiv GPIO_BSRR_BR11_Pos, (27)
.equiv GPIO_BSRR_BR11_Msk, (0x1 << GPIO_BSRR_BR11_Pos) /* 0x08000000 */
.equiv GPIO_BSRR_BR11,     GPIO_BSRR_BR11_Msk
.equiv GPIO_BSRR_BR12_Pos, (28)
.equiv GPIO_BSRR_BR12_Msk, (0x1 << GPIO_BSRR_BR12_Pos) /* 0x10000000 */
.equiv GPIO_BSRR_BR12,     GPIO_BSRR_BR12_Msk
.equiv GPIO_BSRR_BR13_Pos, (29)
.equiv GPIO_BSRR_BR13_Msk, (0x1 << GPIO_BSRR_BR13_Pos) /* 0x20000000 */
.equiv GPIO_BSRR_BR13,     GPIO_BSRR_BR13_Msk
.equiv GPIO_BSRR_BR14_Pos, (30)
.equiv GPIO_BSRR_BR14_Msk, (0x1 << GPIO_BSRR_BR14_Pos) /* 0x40000000 */
.equiv GPIO_BSRR_BR14,     GPIO_BSRR_BR14_Msk
.equiv GPIO_BSRR_BR15_Pos, (31)
.equiv GPIO_BSRR_BR15_Msk, (0x1 << GPIO_BSRR_BR15_Pos) /* 0x80000000 */
.equiv GPIO_BSRR_BR15,     GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
.equiv GPIO_LCKR_LCK0_Pos,  (0)
.equiv GPIO_LCKR_LCK0_Msk,  (0x1 << GPIO_LCKR_LCK0_Pos)  /* 0x00000001 */
.equiv GPIO_LCKR_LCK0,      GPIO_LCKR_LCK0_Msk
.equiv GPIO_LCKR_LCK1_Pos,  (1)
.equiv GPIO_LCKR_LCK1_Msk,  (0x1 << GPIO_LCKR_LCK1_Pos)  /* 0x00000002 */
.equiv GPIO_LCKR_LCK1,      GPIO_LCKR_LCK1_Msk
.equiv GPIO_LCKR_LCK2_Pos,  (2)
.equiv GPIO_LCKR_LCK2_Msk,  (0x1 << GPIO_LCKR_LCK2_Pos)  /* 0x00000004 */
.equiv GPIO_LCKR_LCK2,      GPIO_LCKR_LCK2_Msk
.equiv GPIO_LCKR_LCK3_Pos,  (3)
.equiv GPIO_LCKR_LCK3_Msk,  (0x1 << GPIO_LCKR_LCK3_Pos)  /* 0x00000008 */
.equiv GPIO_LCKR_LCK3,      GPIO_LCKR_LCK3_Msk
.equiv GPIO_LCKR_LCK4_Pos,  (4)
.equiv GPIO_LCKR_LCK4_Msk,  (0x1 << GPIO_LCKR_LCK4_Pos)  /* 0x00000010 */
.equiv GPIO_LCKR_LCK4,      GPIO_LCKR_LCK4_Msk
.equiv GPIO_LCKR_LCK5_Pos,  (5)
.equiv GPIO_LCKR_LCK5_Msk,  (0x1 << GPIO_LCKR_LCK5_Pos)  /* 0x00000020 */
.equiv GPIO_LCKR_LCK5,      GPIO_LCKR_LCK5_Msk
.equiv GPIO_LCKR_LCK6_Pos,  (6)
.equiv GPIO_LCKR_LCK6_Msk,  (0x1 << GPIO_LCKR_LCK6_Pos)  /* 0x00000040 */
.equiv GPIO_LCKR_LCK6,      GPIO_LCKR_LCK6_Msk
.equiv GPIO_LCKR_LCK7_Pos,  (7)
.equiv GPIO_LCKR_LCK7_Msk,  (0x1 << GPIO_LCKR_LCK7_Pos)  /* 0x00000080 */
.equiv GPIO_LCKR_LCK7,      GPIO_LCKR_LCK7_Msk
.equiv GPIO_LCKR_LCK8_Pos,  (8)
.equiv GPIO_LCKR_LCK8_Msk,  (0x1 << GPIO_LCKR_LCK8_Pos)  /* 0x00000100 */
.equiv GPIO_LCKR_LCK8,      GPIO_LCKR_LCK8_Msk
.equiv GPIO_LCKR_LCK9_Pos,  (9)
.equiv GPIO_LCKR_LCK9_Msk,  (0x1 << GPIO_LCKR_LCK9_Pos)  /* 0x00000200 */
.equiv GPIO_LCKR_LCK9,      GPIO_LCKR_LCK9_Msk
.equiv GPIO_LCKR_LCK10_Pos, (10)
.equiv GPIO_LCKR_LCK10_Msk, (0x1 << GPIO_LCKR_LCK10_Pos) /* 0x00000400 */
.equiv GPIO_LCKR_LCK10,     GPIO_LCKR_LCK10_Msk
.equiv GPIO_LCKR_LCK11_Pos, (11)
.equiv GPIO_LCKR_LCK11_Msk, (0x1 << GPIO_LCKR_LCK11_Pos) /* 0x00000800 */
.equiv GPIO_LCKR_LCK11,     GPIO_LCKR_LCK11_Msk
.equiv GPIO_LCKR_LCK12_Pos, (12)
.equiv GPIO_LCKR_LCK12_Msk, (0x1 << GPIO_LCKR_LCK12_Pos) /* 0x00001000 */
.equiv GPIO_LCKR_LCK12,     GPIO_LCKR_LCK12_Msk
.equiv GPIO_LCKR_LCK13_Pos, (13)
.equiv GPIO_LCKR_LCK13_Msk, (0x1 << GPIO_LCKR_LCK13_Pos) /* 0x00002000 */
.equiv GPIO_LCKR_LCK13,     GPIO_LCKR_LCK13_Msk
.equiv GPIO_LCKR_LCK14_Pos, (14)
.equiv GPIO_LCKR_LCK14_Msk, (0x1 << GPIO_LCKR_LCK14_Pos) /* 0x00004000 */
.equiv GPIO_LCKR_LCK14,     GPIO_LCKR_LCK14_Msk
.equiv GPIO_LCKR_LCK15_Pos, (15)
.equiv GPIO_LCKR_LCK15_Msk, (0x1 << GPIO_LCKR_LCK15_Pos) /* 0x00008000 */
.equiv GPIO_LCKR_LCK15,     GPIO_LCKR_LCK15_Msk
.equiv GPIO_LCKR_LCKK_Pos,  (16)
.equiv GPIO_LCKR_LCKK_Msk,  (0x1 << GPIO_LCKR_LCKK_Pos)  /* 0x00010000 */
.equiv GPIO_LCKR_LCKK,      GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
.equiv GPIO_AFRL_AFSEL0_Pos, (0)
.equiv GPIO_AFRL_AFSEL0_Msk, (0xF << GPIO_AFRL_AFSEL0_Pos) /* 0x0000000F */
.equiv GPIO_AFRL_AFSEL0,     GPIO_AFRL_AFSEL0_Msk
.equiv GPIO_AFRL_AFSEL0_0,   (0x1 << GPIO_AFRL_AFSEL0_Pos) /* 0x00000001 */
.equiv GPIO_AFRL_AFSEL0_1,   (0x2 << GPIO_AFRL_AFSEL0_Pos) /* 0x00000002 */
.equiv GPIO_AFRL_AFSEL0_2,   (0x4 << GPIO_AFRL_AFSEL0_Pos) /* 0x00000004 */
.equiv GPIO_AFRL_AFSEL0_3,   (0x8 << GPIO_AFRL_AFSEL0_Pos) /* 0x00000008 */
.equiv GPIO_AFRL_AFSEL1_Pos, (4)
.equiv GPIO_AFRL_AFSEL1_Msk, (0xF << GPIO_AFRL_AFSEL1_Pos) /* 0x000000F0 */
.equiv GPIO_AFRL_AFSEL1,     GPIO_AFRL_AFSEL1_Msk
.equiv GPIO_AFRL_AFSEL1_0,   (0x1 << GPIO_AFRL_AFSEL1_Pos) /* 0x00000010 */
.equiv GPIO_AFRL_AFSEL1_1,   (0x2 << GPIO_AFRL_AFSEL1_Pos) /* 0x00000020 */
.equiv GPIO_AFRL_AFSEL1_2,   (0x4 << GPIO_AFRL_AFSEL1_Pos) /* 0x00000040 */
.equiv GPIO_AFRL_AFSEL1_3,   (0x8 << GPIO_AFRL_AFSEL1_Pos) /* 0x00000080 */
.equiv GPIO_AFRL_AFSEL2_Pos, (8)
.equiv GPIO_AFRL_AFSEL2_Msk, (0xF << GPIO_AFRL_AFSEL2_Pos) /* 0x00000F00 */
.equiv GPIO_AFRL_AFSEL2,     GPIO_AFRL_AFSEL2_Msk
.equiv GPIO_AFRL_AFSEL2_0,   (0x1 << GPIO_AFRL_AFSEL2_Pos) /* 0x00000100 */
.equiv GPIO_AFRL_AFSEL2_1,   (0x2 << GPIO_AFRL_AFSEL2_Pos) /* 0x00000200 */
.equiv GPIO_AFRL_AFSEL2_2,   (0x4 << GPIO_AFRL_AFSEL2_Pos) /* 0x00000400 */
.equiv GPIO_AFRL_AFSEL2_3,   (0x8 << GPIO_AFRL_AFSEL2_Pos) /* 0x00000800 */
.equiv GPIO_AFRL_AFSEL3_Pos, (12)
.equiv GPIO_AFRL_AFSEL3_Msk, (0xF << GPIO_AFRL_AFSEL3_Pos) /* 0x0000F000 */
.equiv GPIO_AFRL_AFSEL3,     GPIO_AFRL_AFSEL3_Msk
.equiv GPIO_AFRL_AFSEL3_0,   (0x1 << GPIO_AFRL_AFSEL3_Pos) /* 0x00001000 */
.equiv GPIO_AFRL_AFSEL3_1,   (0x2 << GPIO_AFRL_AFSEL3_Pos) /* 0x00002000 */
.equiv GPIO_AFRL_AFSEL3_2,   (0x4 << GPIO_AFRL_AFSEL3_Pos) /* 0x00004000 */
.equiv GPIO_AFRL_AFSEL3_3,   (0x8 << GPIO_AFRL_AFSEL3_Pos) /* 0x00008000 */
.equiv GPIO_AFRL_AFSEL4_Pos, (16)
.equiv GPIO_AFRL_AFSEL4_Msk, (0xF << GPIO_AFRL_AFSEL4_Pos) /* 0x000F0000 */
.equiv GPIO_AFRL_AFSEL4,     GPIO_AFRL_AFSEL4_Msk
.equiv GPIO_AFRL_AFSEL4_0,   (0x1 << GPIO_AFRL_AFSEL4_Pos) /* 0x00010000 */
.equiv GPIO_AFRL_AFSEL4_1,   (0x2 << GPIO_AFRL_AFSEL4_Pos) /* 0x00020000 */
.equiv GPIO_AFRL_AFSEL4_2,   (0x4 << GPIO_AFRL_AFSEL4_Pos) /* 0x00040000 */
.equiv GPIO_AFRL_AFSEL4_3,   (0x8 << GPIO_AFRL_AFSEL4_Pos) /* 0x00080000 */
.equiv GPIO_AFRL_AFSEL5_Pos, (20)
.equiv GPIO_AFRL_AFSEL5_Msk, (0xF << GPIO_AFRL_AFSEL5_Pos) /* 0x00F00000 */
.equiv GPIO_AFRL_AFSEL5,     GPIO_AFRL_AFSEL5_Msk
.equiv GPIO_AFRL_AFSEL5_0,   (0x1 << GPIO_AFRL_AFSEL5_Pos) /* 0x00100000 */
.equiv GPIO_AFRL_AFSEL5_1,   (0x2 << GPIO_AFRL_AFSEL5_Pos) /* 0x00200000 */
.equiv GPIO_AFRL_AFSEL5_2,   (0x4 << GPIO_AFRL_AFSEL5_Pos) /* 0x00400000 */
.equiv GPIO_AFRL_AFSEL5_3,   (0x8 << GPIO_AFRL_AFSEL5_Pos) /* 0x00800000 */
.equiv GPIO_AFRL_AFSEL6_Pos, (24)
.equiv GPIO_AFRL_AFSEL6_Msk, (0xF << GPIO_AFRL_AFSEL6_Pos) /* 0x0F000000 */
.equiv GPIO_AFRL_AFSEL6,     GPIO_AFRL_AFSEL6_Msk
.equiv GPIO_AFRL_AFSEL6_0,   (0x1 << GPIO_AFRL_AFSEL6_Pos) /* 0x01000000 */
.equiv GPIO_AFRL_AFSEL6_1,   (0x2 << GPIO_AFRL_AFSEL6_Pos) /* 0x02000000 */
.equiv GPIO_AFRL_AFSEL6_2,   (0x4 << GPIO_AFRL_AFSEL6_Pos) /* 0x04000000 */
.equiv GPIO_AFRL_AFSEL6_3,   (0x8 << GPIO_AFRL_AFSEL6_Pos) /* 0x08000000 */
.equiv GPIO_AFRL_AFSEL7_Pos, (28)
.equiv GPIO_AFRL_AFSEL7_Msk, (0xF << GPIO_AFRL_AFSEL7_Pos) /* 0xF0000000 */
.equiv GPIO_AFRL_AFSEL7,     GPIO_AFRL_AFSEL7_Msk
.equiv GPIO_AFRL_AFSEL7_0,   (0x1 << GPIO_AFRL_AFSEL7_Pos) /* 0x10000000 */
.equiv GPIO_AFRL_AFSEL7_1,   (0x2 << GPIO_AFRL_AFSEL7_Pos) /* 0x20000000 */
.equiv GPIO_AFRL_AFSEL7_2,   (0x4 << GPIO_AFRL_AFSEL7_Pos) /* 0x40000000 */
.equiv GPIO_AFRL_AFSEL7_3,   (0x8 << GPIO_AFRL_AFSEL7_Pos) /* 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
.equiv GPIO_AFRH_AFSEL8_Pos,  (0)
.equiv GPIO_AFRH_AFSEL8_Msk,  (0xF << GPIO_AFRH_AFSEL8_Pos)  /* 0x0000000F */
.equiv GPIO_AFRH_AFSEL8,      GPIO_AFRH_AFSEL8_Msk
.equiv GPIO_AFRH_AFSEL8_0,    (0x1 << GPIO_AFRH_AFSEL8_Pos)  /* 0x00000001 */
.equiv GPIO_AFRH_AFSEL8_1,    (0x2 << GPIO_AFRH_AFSEL8_Pos)  /* 0x00000002 */
.equiv GPIO_AFRH_AFSEL8_2,    (0x4 << GPIO_AFRH_AFSEL8_Pos)  /* 0x00000004 */
.equiv GPIO_AFRH_AFSEL8_3,    (0x8 << GPIO_AFRH_AFSEL8_Pos)  /* 0x00000008 */
.equiv GPIO_AFRH_AFSEL9_Pos,  (4)
.equiv GPIO_AFRH_AFSEL9_Msk,  (0xF << GPIO_AFRH_AFSEL9_Pos)  /* 0x000000F0 */
.equiv GPIO_AFRH_AFSEL9,      GPIO_AFRH_AFSEL9_Msk
.equiv GPIO_AFRH_AFSEL9_0,    (0x1 << GPIO_AFRH_AFSEL9_Pos)  /* 0x00000010 */
.equiv GPIO_AFRH_AFSEL9_1,    (0x2 << GPIO_AFRH_AFSEL9_Pos)  /* 0x00000020 */
.equiv GPIO_AFRH_AFSEL9_2,    (0x4 << GPIO_AFRH_AFSEL9_Pos)  /* 0x00000040 */
.equiv GPIO_AFRH_AFSEL9_3,    (0x8 << GPIO_AFRH_AFSEL9_Pos)  /* 0x00000080 */
.equiv GPIO_AFRH_AFSEL10_Pos, (8)
.equiv GPIO_AFRH_AFSEL10_Msk, (0xF << GPIO_AFRH_AFSEL10_Pos) /* 0x00000F00 */
.equiv GPIO_AFRH_AFSEL10,     GPIO_AFRH_AFSEL10_Msk
.equiv GPIO_AFRH_AFSEL10_0,   (0x1 << GPIO_AFRH_AFSEL10_Pos) /* 0x00000100 */
.equiv GPIO_AFRH_AFSEL10_1,   (0x2 << GPIO_AFRH_AFSEL10_Pos) /* 0x00000200 */
.equiv GPIO_AFRH_AFSEL10_2,   (0x4 << GPIO_AFRH_AFSEL10_Pos) /* 0x00000400 */
.equiv GPIO_AFRH_AFSEL10_3,   (0x8 << GPIO_AFRH_AFSEL10_Pos) /* 0x00000800 */
.equiv GPIO_AFRH_AFSEL11_Pos, (12)
.equiv GPIO_AFRH_AFSEL11_Msk, (0xF << GPIO_AFRH_AFSEL11_Pos) /* 0x0000F000 */
.equiv GPIO_AFRH_AFSEL11,     GPIO_AFRH_AFSEL11_Msk
.equiv GPIO_AFRH_AFSEL11_0,   (0x1 << GPIO_AFRH_AFSEL11_Pos) /* 0x00001000 */
.equiv GPIO_AFRH_AFSEL11_1,   (0x2 << GPIO_AFRH_AFSEL11_Pos) /* 0x00002000 */
.equiv GPIO_AFRH_AFSEL11_2,   (0x4 << GPIO_AFRH_AFSEL11_Pos) /* 0x00004000 */
.equiv GPIO_AFRH_AFSEL11_3,   (0x8 << GPIO_AFRH_AFSEL11_Pos) /* 0x00008000 */
.equiv GPIO_AFRH_AFSEL12_Pos, (16)
.equiv GPIO_AFRH_AFSEL12_Msk, (0xF << GPIO_AFRH_AFSEL12_Pos) /* 0x000F0000 */
.equiv GPIO_AFRH_AFSEL12,     GPIO_AFRH_AFSEL12_Msk
.equiv GPIO_AFRH_AFSEL12_0,   (0x1 << GPIO_AFRH_AFSEL12_Pos) /* 0x00010000 */
.equiv GPIO_AFRH_AFSEL12_1,   (0x2 << GPIO_AFRH_AFSEL12_Pos) /* 0x00020000 */
.equiv GPIO_AFRH_AFSEL12_2,   (0x4 << GPIO_AFRH_AFSEL12_Pos) /* 0x00040000 */
.equiv GPIO_AFRH_AFSEL12_3,   (0x8 << GPIO_AFRH_AFSEL12_Pos) /* 0x00080000 */
.equiv GPIO_AFRH_AFSEL13_Pos, (20)
.equiv GPIO_AFRH_AFSEL13_Msk, (0xF << GPIO_AFRH_AFSEL13_Pos) /* 0x00F00000 */
.equiv GPIO_AFRH_AFSEL13,     GPIO_AFRH_AFSEL13_Msk
.equiv GPIO_AFRH_AFSEL13_0,   (0x1 << GPIO_AFRH_AFSEL13_Pos) /* 0x00100000 */
.equiv GPIO_AFRH_AFSEL13_1,   (0x2 << GPIO_AFRH_AFSEL13_Pos) /* 0x00200000 */
.equiv GPIO_AFRH_AFSEL13_2,   (0x4 << GPIO_AFRH_AFSEL13_Pos) /* 0x00400000 */
.equiv GPIO_AFRH_AFSEL13_3,   (0x8 << GPIO_AFRH_AFSEL13_Pos) /* 0x00800000 */
.equiv GPIO_AFRH_AFSEL14_Pos, (24)
.equiv GPIO_AFRH_AFSEL14_Msk, (0xF << GPIO_AFRH_AFSEL14_Pos) /* 0x0F000000 */
.equiv GPIO_AFRH_AFSEL14,     GPIO_AFRH_AFSEL14_Msk
.equiv GPIO_AFRH_AFSEL14_0,   (0x1 << GPIO_AFRH_AFSEL14_Pos) /* 0x01000000 */
.equiv GPIO_AFRH_AFSEL14_1,   (0x2 << GPIO_AFRH_AFSEL14_Pos) /* 0x02000000 */
.equiv GPIO_AFRH_AFSEL14_2,   (0x4 << GPIO_AFRH_AFSEL14_Pos) /* 0x04000000 */
.equiv GPIO_AFRH_AFSEL14_3,   (0x8 << GPIO_AFRH_AFSEL14_Pos) /* 0x08000000 */
.equiv GPIO_AFRH_AFSEL15_Pos, (28)
.equiv GPIO_AFRH_AFSEL15_Msk, (0xF << GPIO_AFRH_AFSEL15_Pos) /* 0xF0000000 */
.equiv GPIO_AFRH_AFSEL15,     GPIO_AFRH_AFSEL15_Msk
.equiv GPIO_AFRH_AFSEL15_0,   (0x1 << GPIO_AFRH_AFSEL15_Pos) /* 0x10000000 */
.equiv GPIO_AFRH_AFSEL15_1,   (0x2 << GPIO_AFRH_AFSEL15_Pos) /* 0x20000000 */
.equiv GPIO_AFRH_AFSEL15_2,   (0x4 << GPIO_AFRH_AFSEL15_Pos) /* 0x40000000 */
.equiv GPIO_AFRH_AFSEL15_3,   (0x8 << GPIO_AFRH_AFSEL15_Pos) /* 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
.equiv GPIO_BRR_BR0_Pos,  (0)
.equiv GPIO_BRR_BR0_Msk,  (0x1 << GPIO_BRR_BR0_Pos)  /* 0x00000001 */
.equiv GPIO_BRR_BR0,      GPIO_BRR_BR0_Msk
.equiv GPIO_BRR_BR1_Pos,  (1)
.equiv GPIO_BRR_BR1_Msk,  (0x1 << GPIO_BRR_BR1_Pos)  /* 0x00000002 */
.equiv GPIO_BRR_BR1,      GPIO_BRR_BR1_Msk
.equiv GPIO_BRR_BR2_Pos,  (2)
.equiv GPIO_BRR_BR2_Msk,  (0x1 << GPIO_BRR_BR2_Pos)  /* 0x00000004 */
.equiv GPIO_BRR_BR2,      GPIO_BRR_BR2_Msk
.equiv GPIO_BRR_BR3_Pos,  (3)
.equiv GPIO_BRR_BR3_Msk,  (0x1 << GPIO_BRR_BR3_Pos)  /* 0x00000008 */
.equiv GPIO_BRR_BR3,      GPIO_BRR_BR3_Msk
.equiv GPIO_BRR_BR4_Pos,  (4)
.equiv GPIO_BRR_BR4_Msk,  (0x1 << GPIO_BRR_BR4_Pos)  /* 0x00000010 */
.equiv GPIO_BRR_BR4,      GPIO_BRR_BR4_Msk
.equiv GPIO_BRR_BR5_Pos,  (5)
.equiv GPIO_BRR_BR5_Msk,  (0x1 << GPIO_BRR_BR5_Pos)  /* 0x00000020 */
.equiv GPIO_BRR_BR5,      GPIO_BRR_BR5_Msk
.equiv GPIO_BRR_BR6_Pos,  (6)
.equiv GPIO_BRR_BR6_Msk,  (0x1 << GPIO_BRR_BR6_Pos)  /* 0x00000040 */
.equiv GPIO_BRR_BR6,      GPIO_BRR_BR6_Msk
.equiv GPIO_BRR_BR7_Pos,  (7)
.equiv GPIO_BRR_BR7_Msk,  (0x1 << GPIO_BRR_BR7_Pos)  /* 0x00000080 */
.equiv GPIO_BRR_BR7,      GPIO_BRR_BR7_Msk
.equiv GPIO_BRR_BR8_Pos,  (8)
.equiv GPIO_BRR_BR8_Msk,  (0x1 << GPIO_BRR_BR8_Pos)  /* 0x00000100 */
.equiv GPIO_BRR_BR8,      GPIO_BRR_BR8_Msk
.equiv GPIO_BRR_BR9_Pos,  (9)
.equiv GPIO_BRR_BR9_Msk,  (0x1 << GPIO_BRR_BR9_Pos)  /* 0x00000200 */
.equiv GPIO_BRR_BR9,      GPIO_BRR_BR9_Msk
.equiv GPIO_BRR_BR10_Pos, (10)
.equiv GPIO_BRR_BR10_Msk, (0x1 << GPIO_BRR_BR10_Pos) /* 0x00000400 */
.equiv GPIO_BRR_BR10,     GPIO_BRR_BR10_Msk
.equiv GPIO_BRR_BR11_Pos, (11)
.equiv GPIO_BRR_BR11_Msk, (0x1 << GPIO_BRR_BR11_Pos) /* 0x00000800 */
.equiv GPIO_BRR_BR11,     GPIO_BRR_BR11_Msk
.equiv GPIO_BRR_BR12_Pos, (12)
.equiv GPIO_BRR_BR12_Msk, (0x1 << GPIO_BRR_BR12_Pos) /* 0x00001000 */
.equiv GPIO_BRR_BR12,     GPIO_BRR_BR12_Msk
.equiv GPIO_BRR_BR13_Pos, (13)
.equiv GPIO_BRR_BR13_Msk, (0x1 << GPIO_BRR_BR13_Pos) /* 0x00002000 */
.equiv GPIO_BRR_BR13,     GPIO_BRR_BR13_Msk
.equiv GPIO_BRR_BR14_Pos, (14)
.equiv GPIO_BRR_BR14_Msk, (0x1 << GPIO_BRR_BR14_Pos) /* 0x00004000 */
.equiv GPIO_BRR_BR14,     GPIO_BRR_BR14_Msk
.equiv GPIO_BRR_BR15_Pos, (15)
.equiv GPIO_BRR_BR15_Msk, (0x1 << GPIO_BRR_BR15_Pos) /* 0x00008000 */
.equiv GPIO_BRR_BR15,     GPIO_BRR_BR15_Msk

/******************************************************************************/
/*                                                                            */
/*                      Inter-integrated Circuit Interface (I2C)              */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for I2C_CR1 register  ********************/
.equiv I2C_CR1_PE_Pos,        (0)
.equiv I2C_CR1_PE_Msk,        (0x1 << I2C_CR1_PE_Pos)        /* 0x00000001 */
.equiv I2C_CR1_PE,            I2C_CR1_PE_Msk                 /* Peripheral Enable */
//.equiv I2C_CR1_ENARP_Pos,     (4)
//.equiv I2C_CR1_ENARP_Msk,     (0x1 << I2C_CR1_ENARP_Pos)     /* 0x00000010 */
//.equiv I2C_CR1_ENARP,         I2C_CR1_ENARP_Msk              /* ARP Enable */
//.equiv I2C_CR1_ENPEC_Pos,     (5)
//.equiv I2C_CR1_ENPEC_Msk,     (0x1 << I2C_CR1_ENPEC_Pos)     /* 0x00000020 */
//.equiv I2C_CR1_ENPEC,         I2C_CR1_ENPEC_Msk              /* PEC Enable */
.equiv I2C_CR1_ENGC_Pos,      (6)
.equiv I2C_CR1_ENGC_Msk,      (0x1 << I2C_CR1_ENGC_Pos)      /* 0x00000040 */
.equiv I2C_CR1_ENGC,          I2C_CR1_ENGC_Msk               /* General Call Enable */
.equiv I2C_CR1_NOSTRETCH_Pos, (7)
.equiv I2C_CR1_NOSTRETCH_Msk, (0x1 << I2C_CR1_NOSTRETCH_Pos) /* 0x00000080 */
.equiv I2C_CR1_NOSTRETCH,     I2C_CR1_NOSTRETCH_Msk          /* Clock Stretching Disable (Slave mode) */
.equiv I2C_CR1_START_Pos,     (8)
.equiv I2C_CR1_START_Msk,     (0x1 << I2C_CR1_START_Pos)     /* 0x00000100 */
.equiv I2C_CR1_START,         I2C_CR1_START_Msk              /* Start Generation */
.equiv I2C_CR1_STOP_Pos,      (9)
.equiv I2C_CR1_STOP_Msk,      (0x1 << I2C_CR1_STOP_Pos)      /* 0x00000200 */
.equiv I2C_CR1_STOP,          I2C_CR1_STOP_Msk               /* Stop Generation */
.equiv I2C_CR1_ACK_Pos,       (10)
.equiv I2C_CR1_ACK_Msk,       (0x1 << I2C_CR1_ACK_Pos)       /* 0x00000400 */
.equiv I2C_CR1_ACK,           I2C_CR1_ACK_Msk                /* Acknowledge Enable */
.equiv I2C_CR1_POS_Pos,       (11)
.equiv I2C_CR1_POS_Msk,       (0x1 << I2C_CR1_POS_Pos)       /* 0x00000800 */
.equiv I2C_CR1_POS,           I2C_CR1_POS_Msk                /* Acknowledge/PEC Position (for data reception) */
//.equiv I2C_CR1_PEC_Pos,       (12)
//.equiv I2C_CR1_PEC_Msk,       (0x1 << I2C_CR1_PEC_Pos)       /* 0x00001000 */
//.equiv I2C_CR1_PEC,           I2C_CR1_PEC_Msk                /* Packet Error Checking */
.equiv I2C_CR1_SWRST_Pos,     (15)
.equiv I2C_CR1_SWRST_Msk,     (0x1 << I2C_CR1_SWRST_Pos)     /* 0x00008000 */
.equiv I2C_CR1_SWRST,         I2C_CR1_SWRST_Msk              /* Software Reset */

/*******************  Bit definition for I2C_CR2 register  ********************/
.equiv I2C_CR2_FREQ_Pos,    (0)
.equiv I2C_CR2_FREQ_Msk,    (0x3F << I2C_CR2_FREQ_Pos)   /* 0x0000003F */
.equiv I2C_CR2_FREQ,        I2C_CR2_FREQ_Msk             /* FREQ[5:0] bits (Peripheral Clock Frequency) */
.equiv I2C_CR2_FREQ_0,      (0x01 << I2C_CR2_FREQ_Pos)   /* 0x00000001 */
.equiv I2C_CR2_FREQ_1,      (0x02 << I2C_CR2_FREQ_Pos)   /* 0x00000002 */
.equiv I2C_CR2_FREQ_2,      (0x04 << I2C_CR2_FREQ_Pos)   /* 0x00000004 */
.equiv I2C_CR2_FREQ_3,      (0x08 << I2C_CR2_FREQ_Pos)   /* 0x00000008 */
.equiv I2C_CR2_FREQ_4,      (0x10 << I2C_CR2_FREQ_Pos)   /* 0x00000010 */
.equiv I2C_CR2_FREQ_5,      (0x20 << I2C_CR2_FREQ_Pos)   /* 0x00000020 */
.equiv I2C_CR2_ITERREN_Pos, (8)
.equiv I2C_CR2_ITERREN_Msk, (0x1 << I2C_CR2_ITERREN_Pos) /* 0x00000100 */
.equiv I2C_CR2_ITERREN,     I2C_CR2_ITERREN_Msk          /* Error Interrupt Enable */
.equiv I2C_CR2_ITEVTEN_Pos, (9)
.equiv I2C_CR2_ITEVTEN_Msk, (0x1 << I2C_CR2_ITEVTEN_Pos) /* 0x00000200 */
.equiv I2C_CR2_ITEVTEN,     I2C_CR2_ITEVTEN_Msk          /* Event Interrupt Enable */
.equiv I2C_CR2_ITBUFEN_Pos, (10)
.equiv I2C_CR2_ITBUFEN_Msk, (0x1 << I2C_CR2_ITBUFEN_Pos) /* 0x00000400 */
.equiv I2C_CR2_ITBUFEN,     I2C_CR2_ITBUFEN_Msk          /* Buffer Interrupt Enable */

/*******************  Bit definition for I2C_OAR1 register  *******************/
.equiv I2C_OAR1_ADD1_7,   0x000000FE                  /* Interface Address */
.equiv I2C_OAR1_ADD1_Pos, (1)
.equiv I2C_OAR1_ADD1_Msk, (0x1 << I2C_OAR1_ADD1_Pos)  /* 0x00000002 */
.equiv I2C_OAR1_ADD1,     I2C_OAR1_ADD1_Msk           /* Bit 1 */
.equiv I2C_OAR1_ADD2_Pos, (2)
.equiv I2C_OAR1_ADD2_Msk, (0x1 << I2C_OAR1_ADD2_Pos)  /* 0x00000004 */
.equiv I2C_OAR1_ADD2,     I2C_OAR1_ADD2_Msk           /* Bit 2 */
.equiv I2C_OAR1_ADD3_Pos, (3)
.equiv I2C_OAR1_ADD3_Msk, (0x1 << I2C_OAR1_ADD3_Pos)  /* 0x00000008 */
.equiv I2C_OAR1_ADD3,     I2C_OAR1_ADD3_Msk           /* Bit 3 */
.equiv I2C_OAR1_ADD4_Pos, (4)
.equiv I2C_OAR1_ADD4_Msk, (0x1 << I2C_OAR1_ADD4_Pos)  /* 0x00000010 */
.equiv I2C_OAR1_ADD4,     I2C_OAR1_ADD4_Msk           /* Bit 4 */
.equiv I2C_OAR1_ADD5_Pos, (5)
.equiv I2C_OAR1_ADD5_Msk, (0x1 << I2C_OAR1_ADD5_Pos)  /* 0x00000020 */
.equiv I2C_OAR1_ADD5,     I2C_OAR1_ADD5_Msk           /* Bit 5 */
.equiv I2C_OAR1_ADD6_Pos, (6)
.equiv I2C_OAR1_ADD6_Msk, (0x1 << I2C_OAR1_ADD6_Pos)  /* 0x00000040 */
.equiv I2C_OAR1_ADD6,     I2C_OAR1_ADD6_Msk           /* Bit 6 */
.equiv I2C_OAR1_ADD7_Pos, (7)
.equiv I2C_OAR1_ADD7_Msk, (0x1 << I2C_OAR1_ADD7_Pos)  /* 0x00000080 */
.equiv I2C_OAR1_ADD7,     I2C_OAR1_ADD7_Msk           /* Bit 7 */

/********************  Bit definition for I2C_DR register  ********************/
.equiv I2C_DR_DR_Pos, (0)
.equiv I2C_DR_DR_Msk, (0xFF << I2C_DR_DR_Pos) /* 0x000000FF */
.equiv I2C_DR_DR,     I2C_DR_DR_Msk           /* 8-bit Data Register         */
.equiv I2C_DR_DR_0,   (0x01 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_1,   (0x02 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_2,   (0x04 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_3,   (0x08 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_4,   (0x10 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_5,   (0x20 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_6,   (0x40 << I2C_DR_DR_Pos)
.equiv I2C_DR_DR_7,   (0x80 << I2C_DR_DR_Pos)

/*******************  Bit definition for I2C_SR1 register  ********************/
.equiv I2C_SR1_SB_Pos,      (0)
.equiv I2C_SR1_SB_Msk,      (0x1 << I2C_SR1_SB_Pos)      /* 0x00000001 */
.equiv I2C_SR1_SB,          I2C_SR1_SB_Msk               /* Start Bit (Master mode) */
.equiv I2C_SR1_ADDR_Pos,    (1)
.equiv I2C_SR1_ADDR_Msk,    (0x1 << I2C_SR1_ADDR_Pos)    /* 0x00000002 */
.equiv I2C_SR1_ADDR,        I2C_SR1_ADDR_Msk             /* Address sent (master mode)/matched (slave mode) */
.equiv I2C_SR1_BTF_Pos,     (2)
.equiv I2C_SR1_BTF_Msk,     (0x1 << I2C_SR1_BTF_Pos)     /* 0x00000004 */
.equiv I2C_SR1_BTF,         I2C_SR1_BTF_Msk              /* Byte Transfer Finished */
//.equiv I2C_SR1_ADD10_Pos,   (3)
//.equiv I2C_SR1_ADD10_Msk,   (0x1 << I2C_SR1_ADD10_Pos)   /* 0x00000008 */
//.equiv I2C_SR1_ADD10,       I2C_SR1_ADD10_Msk            /* 10-bit header sent (Master mode) */
.equiv I2C_SR1_STOPF_Pos,   (4)
.equiv I2C_SR1_STOPF_Msk,   (0x1 << I2C_SR1_STOPF_Pos)   /* 0x00000010 */
.equiv I2C_SR1_STOPF,       I2C_SR1_STOPF_Msk            /* Stop detection (Slave mode) */
.equiv I2C_SR1_RXNE_Pos,    (6)
.equiv I2C_SR1_RXNE_Msk,    (0x1 << I2C_SR1_RXNE_Pos)    /* 0x00000040 */
.equiv I2C_SR1_RXNE,        I2C_SR1_RXNE_Msk             /* Data Register not Empty (receivers) */
.equiv I2C_SR1_TXE_Pos,     (7)
.equiv I2C_SR1_TXE_Msk,     (0x1 << I2C_SR1_TXE_Pos)     /* 0x00000080 */
.equiv I2C_SR1_TXE,         I2C_SR1_TXE_Msk              /* Data Register Empty (transmitters) */
.equiv I2C_SR1_BERR_Pos,    (8)
.equiv I2C_SR1_BERR_Msk,    (0x1 << I2C_SR1_BERR_Pos)    /* 0x00000100 */
.equiv I2C_SR1_BERR,        I2C_SR1_BERR_Msk             /* Bus Error */
.equiv I2C_SR1_ARLO_Pos,    (9)
.equiv I2C_SR1_ARLO_Msk,    (0x1 << I2C_SR1_ARLO_Pos)    /* 0x00000200 */
.equiv I2C_SR1_ARLO,        I2C_SR1_ARLO_Msk             /* Arbitration Lost (master mode) */
.equiv I2C_SR1_AF_Pos,      (10)
.equiv I2C_SR1_AF_Msk,      (0x1 << I2C_SR1_AF_Pos)      /* 0x00000400 */
.equiv I2C_SR1_AF,          I2C_SR1_AF_Msk               /* Acknowledge Failure */
.equiv I2C_SR1_OVR_Pos,     (11)
.equiv I2C_SR1_OVR_Msk,     (0x1 << I2C_SR1_OVR_Pos)     /* 0x00000800 */
.equiv I2C_SR1_OVR,         I2C_SR1_OVR_Msk              /* Overrun/Underrun */
.equiv I2C_SR1_PECERR_Pos,  (12)
.equiv I2C_SR1_PECERR_Msk,  (0x1 << I2C_SR1_PECERR_Pos)  /* 0x00001000 */
.equiv I2C_SR1_PECERR,      I2C_SR1_PECERR_Msk           /* PEC Error in reception */

/*******************  Bit definition for I2C_SR2 register  ********************/
.equiv I2C_SR2_MSL_Pos,     (0)
.equiv I2C_SR2_MSL_Msk,     (0x1 << I2C_SR2_MSL_Pos)     /* 0x00000001 */
.equiv I2C_SR2_MSL,         I2C_SR2_MSL_Msk              /* Master/Slave */
.equiv I2C_SR2_BUSY_Pos,    (1)
.equiv I2C_SR2_BUSY_Msk,    (0x1 << I2C_SR2_BUSY_Pos)    /* 0x00000002 */
.equiv I2C_SR2_BUSY,        I2C_SR2_BUSY_Msk             /* Bus Busy */
.equiv I2C_SR2_TRA_Pos,     (2)
.equiv I2C_SR2_TRA_Msk,     (0x1 << I2C_SR2_TRA_Pos)     /* 0x00000004 */
.equiv I2C_SR2_TRA,         I2C_SR2_TRA_Msk              /* Transmitter/Receiver */
.equiv I2C_SR2_GENCALL_Pos, (4)
.equiv I2C_SR2_GENCALL_Msk, (0x1 << I2C_SR2_GENCALL_Pos) /* 0x00000010 */
.equiv I2C_SR2_GENCALL,     I2C_SR2_GENCALL_Msk          /* General Call Address (Slave mode) */
//.equiv I2C_SR2_DUALF_Pos,   (7)
//.equiv I2C_SR2_DUALF_Msk,   (0x1 << I2C_SR2_DUALF_Pos)   /* 0x00000080 */
//.equiv I2C_SR2_DUALF,       I2C_SR2_DUALF_Msk            /* Dual Flag (Slave mode) */
.equiv I2C_SR2_PEC_Pos,     (8)
.equiv I2C_SR2_PEC_Msk,     (0xFF << I2C_SR2_PEC_Pos)    /* 0x0000FF00 */
.equiv I2C_SR2_PEC,         I2C_SR2_PEC_Msk              /* Packet Error Checking Register */

/*******************  Bit definition for I2C_CCR register  ********************/
.equiv I2C_CCR_CCR_Pos,  (0)
.equiv I2C_CCR_CCR_Msk,  (0xFFF << I2C_CCR_CCR_Pos) /* 0x00000FFF */
.equiv I2C_CCR_CCR,      I2C_CCR_CCR_Msk            /* Clock Control Register in Fast/Standard mode (Master mode) */
.equiv I2C_CCR_DUTY_Pos, (14)
.equiv I2C_CCR_DUTY_Msk, (0x1 << I2C_CCR_DUTY_Pos)  /* 0x00004000 */
.equiv I2C_CCR_DUTY,     I2C_CCR_DUTY_Msk           /* Fast Mode Duty Cycle */
.equiv I2C_CCR_FS_Pos,   (15)
.equiv I2C_CCR_FS_Msk,   (0x1 << I2C_CCR_FS_Pos)    /* 0x00008000 */
.equiv I2C_CCR_FS,       I2C_CCR_FS_Msk             /* I2C Master Mode Selection */

/******************  Bit definition for I2C_TRISE register  *******************/
.equiv I2C_TRISE_TRISE_Pos, (0)
.equiv I2C_TRISE_TRISE_Msk, (0x3F << I2C_TRISE_TRISE_Pos) /* 0x0000003F */
.equiv I2C_TRISE_TRISE,     I2C_TRISE_TRISE_Msk           /* Maximum Rise Time in Fast/Standard mode (Master mode) */

/******************************************************************************/
/*                                                                            */
/*                        Independent WATCHDOG (IWDG)                         */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for IWDG_KR register  ********************/
.equiv IWDG_KR_KEY_Pos, (0)
.equiv IWDG_KR_KEY_Msk, (0xFFFF << IWDG_KR_KEY_Pos) /* 0x0000FFFF */
.equiv IWDG_KR_KEY,     IWDG_KR_KEY_Msk             /*Key value (write only, read 0000h) */

/*******************  Bit definition for IWDG_PR register  ********************/
.equiv IWDG_PR_PR_Pos, (0)
.equiv IWDG_PR_PR_Msk, (0x7 << IWDG_PR_PR_Pos) /* 0x00000007 */
.equiv IWDG_PR_PR,     IWDG_PR_PR_Msk          /* PR[2:0] (Prescaler divider) */
.equiv IWDG_PR_PR_0,   (0x1 << IWDG_PR_PR_Pos) /* 0x00000001 */
.equiv IWDG_PR_PR_1,   (0x2 << IWDG_PR_PR_Pos) /* 0x00000002 */
.equiv IWDG_PR_PR_2,   (0x4 << IWDG_PR_PR_Pos) /* 0x00000004 */

/*******************  Bit definition for IWDG_RLR register  *******************/
.equiv IWDG_RLR_RL_Pos, (0)
.equiv IWDG_RLR_RL_Msk, (0xFFF << IWDG_RLR_RL_Pos) /* 0x00000FFF */
.equiv IWDG_RLR_RL,     IWDG_RLR_RL_Msk            /*Watchdog counter reload value        */

/*******************  Bit definition for IWDG_SR register  ********************/
.equiv IWDG_SR_PVU_Pos, (0)
.equiv IWDG_SR_PVU_Msk, (0x1 << IWDG_SR_PVU_Pos) /* 0x00000001 */
.equiv IWDG_SR_PVU,     IWDG_SR_PVU_Msk          /* Watchdog prescaler value update */
.equiv IWDG_SR_RVU_Pos, (1)
.equiv IWDG_SR_RVU_Msk, (0x1 << IWDG_SR_RVU_Pos) /* 0x00000002 */
.equiv IWDG_SR_RVU,     IWDG_SR_RVU_Msk          /* Watchdog counter reload value update */
//.equiv IWDG_SR_WVU_Pos, (2)
//.equiv IWDG_SR_WVU_Msk, (0x1 << IWDG_SR_WVU_Pos) /* 0x00000004 */
//.equiv IWDG_SR_WVU,     IWDG_SR_WVU_Msk          /* Watchdog counter window value update */

/*******************  Bit definition for IWDG_WINR register  ********************/
//.equiv IWDG_WINR_WIN_Pos, (0)
//.equiv IWDG_WINR_WIN_Msk, (0xFFF << IWDG_WINR_WIN_Pos) /* 0x00000FFF */
//.equiv IWDG_WINR_WIN,     IWDG_WINR_WIN_Msk            /* Watchdog counter window value */

/******************************************************************************/
/*                                                                            */
/*                        Power Control (PWR)                                 */
/*                                                                            */
/******************************************************************************/
.equiv PWR_BOR_SUPPORT,  1 /* PWR feature available only on specific devices: Brown-Out Reset feature */
.equiv PWR_SHDW_SUPPORT, 1 /* PWR feature available only on specific devices: Shutdown mode */

/********************  Bit definition for PWR_CR1 register  ********************/
.equiv PWR_CR1_BIAS_CR_Pos,     (0)
.equiv PWR_CR1_BIAS_CR_Msk,     (0xF << PWR_CR1_BIAS_CR_Pos)     /* 0x0000000F */
.equiv PWR_CR1_BIAS_CR,         PWR_CR1_BIAS_CR_Msk              /* Low Power Mode Selection */
.equiv PWR_CR1_BIAS_CR_0,       (0x1 << PWR_CR1_BIAS_CR_Pos)     /* 0x00000001 */
.equiv PWR_CR1_BIAS_CR_1,       (0x2 << PWR_CR1_BIAS_CR_Pos)     /* 0x00000002 */
.equiv PWR_CR1_BIAS_CR_2,       (0x4 << PWR_CR1_BIAS_CR_Pos)     /* 0x00000004 */
.equiv PWR_CR1_BIAS_CR_3,       (0x8 << PWR_CR1_BIAS_CR_Pos)     /* 0x00000008 */
.equiv PWR_CR1_BIAS_CR_SEL_Pos, (4)
.equiv PWR_CR1_BIAS_CR_SEL_Msk, (0x1 << PWR_CR1_BIAS_CR_SEL_Pos)
.equiv PWR_CR1_BIAS_CR_SEL,     PWR_CR1_BIAS_CR_SEL_Msk
.equiv PWR_CR1_DBP_Pos,         (8)
.equiv PWR_CR1_DBP_Msk,         (0x1 << PWR_CR1_DBP_Pos)         /* 0x00000100 */
.equiv PWR_CR1_DBP,             PWR_CR1_DBP_Msk                  /* Disable Backup Domain write protection */
.equiv PWR_CR1_VOS_Pos,         (9)
.equiv PWR_CR1_VOS_Msk,         (0x1 << PWR_CR1_VOS_Pos)         /* 0x00000200 */
.equiv PWR_CR1_VOS,             PWR_CR1_VOS_Msk                  /* Voltage scaling */
.equiv PWR_CR1_MRRDY_TIME_Pos,  (10)
.equiv PWR_CR1_MRRDY_TIME_Msk,  (0x3 << PWR_CR1_MRRDY_TIME_Pos)  /* 0x00000c00 */
.equiv PWR_CR1_MRRDY_TIME,      PWR_CR1_MRRDY_TIME_Msk
.equiv PWR_CR1_MRRDY_TIME_0,    (0x1 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_MRRDY_TIME_1,    (0x2 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_MRRDY_TIME_2US,  (0 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_MRRDY_TIME_3US,  (1 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_MRRDY_TIME_4US,  (2 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_MRRDY_TIME_5US,  (3 << PWR_CR1_MRRDY_TIME_Pos)
.equiv PWR_CR1_FLS_SLPTIME_Pos, (12)
.equiv PWR_CR1_FLS_SLPTIME_Msk, (0x3 << PWR_CR1_FLS_SLPTIME_Pos) /* 0x00003000 */
.equiv PWR_CR1_FLS_SLPTIME,     PWR_CR1_FLS_SLPTIME_Msk
.equiv PWR_CR1_FLS_SLPTIME_0,   (0x1 << PWR_CR1_FLS_SLPTIME_Pos)
.equiv PWR_CR1_FLS_SLPTIME_1,   (0x2 << PWR_CR1_FLS_SLPTIME_Pos)
.equiv PWR_CR1_LPR_Pos,         (14)
.equiv PWR_CR1_LPR_Msk,         (0x1 << PWR_CR1_LPR_Pos)         /* 0x00004000 */
.equiv PWR_CR1_LPR,             PWR_CR1_LPR_Msk                  /* Regulator Low-Power Run mode */
.equiv PWR_CR1_SRAM_RETV_Pos,   (16)
.equiv PWR_CR1_SRAM_RETV_Msk,   (0x7 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_CR1_SRAM_RETV,       PWR_CR1_SRAM_RETV_Msk
.equiv PWR_CR1_SRAM_RETV_0,     (0x1 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_CR1_SRAM_RETV_1,     (0x2 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_CR1_SRAM_RETV_2,     (0x4 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_SRAM_RETV_1V0_1V2,   (3 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_SRAM_RETV_0V9,       (7 << PWR_CR1_SRAM_RETV_Pos)
.equiv PWR_CR1_HSION_CTRL_Pos,  (19)
.equiv PWR_CR1_HSION_CTRL_Msk,  (0x1 << PWR_CR1_HSION_CTRL_Pos)
.equiv PWR_CR1_HSION_CTRL,      PWR_CR1_HSION_CTRL_Msk

/********************  Bit definition for PWR_CR2 register  ********************/
.equiv PWR_CR2_SRCSEL_Pos,   (2)
.equiv PWR_CR2_SRCSEL_Msk,   (0x1 << PWR_CR2_SRCSEL_Pos)   /* 0x00000004*/
.equiv PWR_CR2_SRCSEL,       PWR_CR2_SRCSEL_Msk            /*  Selection bit field */
.equiv PWR_CR2_FLTEN_Pos,    (8)
.equiv PWR_CR2_FLTEN_Msk,    (0x1 << PWR_CR2_FLTEN_Pos)    /* 0x00000100 */
.equiv PWR_CR2_FLTEN,        PWR_CR2_FLTEN_Msk             /* filter enable control bit field */
.equiv PWR_CR2_FLT_TIME_Pos, (9)
.equiv PWR_CR2_FLT_TIME_Msk, (0x7 << PWR_CR2_FLT_TIME_Pos) /* 0x00000E00*/
.equiv PWR_CR2_FLT_TIME,     PWR_CR2_FLT_TIME_Msk          /*  Selection bit field */
.equiv PWR_CR2_FLT_TIME_0,   (0x1 << PWR_CR2_FLT_TIME_Pos) /* 0x00000200 */
.equiv PWR_CR2_FLT_TIME_1,   (0x2 << PWR_CR2_FLT_TIME_Pos) /* 0x00000400 */
.equiv PWR_CR2_FLT_TIME_2,   (0x4 << PWR_CR2_FLT_TIME_Pos) /* 0x00000800 */

/******************************************************************************/
/*                                                                            */
/*                           Reset and Clock Control (RCC)                    */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for RCC_CR register  *****************/
.equiv RCC_CR_HSION_Pos,  (8)
.equiv RCC_CR_HSION_Msk,  (0x1 << RCC_CR_HSION_Pos)  /* 0x00000100 */
.equiv RCC_CR_HSION,      RCC_CR_HSION_Msk           /* Internal High Speed clock enable */
.equiv RCC_CR_HSIRDY_Pos, (10)
.equiv RCC_CR_HSIRDY_Msk, (0x1 << RCC_CR_HSIRDY_Pos) /* 0x00000400 */
.equiv RCC_CR_HSIRDY,     RCC_CR_HSIRDY_Msk          /* Internal High Speed clock ready flag */
.equiv RCC_CR_HSIDIV_Pos, (11)
.equiv RCC_CR_HSIDIV_Msk, (0x7 << RCC_CR_HSIDIV_Pos) /* 0x00003800 */
.equiv RCC_CR_HSIDIV,     RCC_CR_HSIDIV_Msk          /* HSIDIV[13:11] Internal High Speed clock division factor */
.equiv RCC_CR_HSIDIV_0,   (0x1 << RCC_CR_HSIDIV_Pos) /* 0x00000800 */
.equiv RCC_CR_HSIDIV_1,   (0x2 << RCC_CR_HSIDIV_Pos) /* 0x00001000 */
.equiv RCC_CR_HSIDIV_2,   (0x4 << RCC_CR_HSIDIV_Pos) /* 0x00002000 */
.equiv RCC_CR_HSEON_Pos,  (16)
.equiv RCC_CR_HSEON_Msk,  (0x1 << RCC_CR_HSEON_Pos)  /* 0x00010000 */
.equiv RCC_CR_HSEON,      RCC_CR_HSEON_Msk           /* External High Speed clock enable */
.equiv RCC_CR_HSERDY_Pos, (17)
.equiv RCC_CR_HSERDY_Msk, (0x1 << RCC_CR_HSERDY_Pos) /* 0x00020000 */
.equiv RCC_CR_HSERDY,     RCC_CR_HSERDY_Msk          /* External High Speed clock ready */
.equiv RCC_CR_HSEBYP_Pos, (18)
.equiv RCC_CR_HSEBYP_Msk, (0x1 << RCC_CR_HSEBYP_Pos) /* 0x00040000 */
.equiv RCC_CR_HSEBYP,     RCC_CR_HSEBYP_Msk          /* External High Speed clock Bypass */
.equiv RCC_CR_CSSON_Pos,  (19)
.equiv RCC_CR_CSSON_Msk,  (0x1 << RCC_CR_CSSON_Pos)  /* 0x00080000 */
.equiv RCC_CR_CSSON,      RCC_CR_CSSON_Msk           /* HSE Clock Security System enable */

/********************  Bit definition for RCC_ICSCR register  ***************/
.equiv RCC_ICSCR_HSI_TRIM_Pos,    (0)
.equiv RCC_ICSCR_HSI_TRIM_Msk,    (0x1FFF << RCC_ICSCR_HSI_TRIM_Pos) /* 0x00001FFF */
.equiv RCC_ICSCR_HSI_TRIM,        RCC_ICSCR_HSI_TRIM_Msk             /* HSITRIM[14:8] bits */
.equiv RCC_ICSCR_HSI_TRIM_0,      (0x01 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000001 */
.equiv RCC_ICSCR_HSI_TRIM_1,      (0x02 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000002 */
.equiv RCC_ICSCR_HSI_TRIM_2,      (0x04 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000004 */
.equiv RCC_ICSCR_HSI_TRIM_3,      (0x08 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000008 */
.equiv RCC_ICSCR_HSI_TRIM_4,      (0x10 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000010 */
.equiv RCC_ICSCR_HSI_TRIM_5,      (0x20 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000020 */
.equiv RCC_ICSCR_HSI_TRIM_6,      (0x40 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000040 */
.equiv RCC_ICSCR_HSI_TRIM_7,      (0x80 << RCC_ICSCR_HSI_TRIM_Pos)   /* 0x00000080 */
.equiv RCC_ICSCR_HSI_TRIM_8,      (0x100 << RCC_ICSCR_HSI_TRIM_Pos)  /* 0x00000100 */
.equiv RCC_ICSCR_HSI_TRIM_9,      (0x200 << RCC_ICSCR_HSI_TRIM_Pos)  /* 0x00000200 */
.equiv RCC_ICSCR_HSI_TRIM_10,     (0x400 << RCC_ICSCR_HSI_TRIM_Pos)  /* 0x00000400 */
.equiv RCC_ICSCR_HSI_TRIM_11,     (0x800 << RCC_ICSCR_HSI_TRIM_Pos)  /* 0x00000800 */
.equiv RCC_ICSCR_HSI_TRIM_12,     (0x1000 << RCC_ICSCR_HSI_TRIM_Pos) /* 0x00001000 */
.equiv RCC_ICSCR_HSI_FS_Pos,      (13)
.equiv RCC_ICSCR_HSI_FS_Msk,      (0x7 << RCC_ICSCR_HSI_FS_Pos)      /* 0x0000E000 */
.equiv RCC_ICSCR_HSI_FS,          RCC_ICSCR_HSI_FS_Msk               /* HSIFS[15:13] bits */
.equiv RCC_ICSCR_HSI_FS_0,        (0x01 << RCC_ICSCR_HSI_FS_Pos)     /* 0x00002000 */
.equiv RCC_ICSCR_HSI_FS_1,        (0x02 << RCC_ICSCR_HSI_FS_Pos)     /* 0x00004000 */
.equiv RCC_ICSCR_HSI_FS_2,        (0x04 << RCC_ICSCR_HSI_FS_Pos)     /* 0x00008000 */
.equiv RCC_ICSCR_LSI_TRIM_Pos,    (16)
.equiv RCC_ICSCR_LSI_TRIM_Msk,    (0x1FF << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM,        RCC_ICSCR_LSI_TRIM_Msk
.equiv RCC_ICSCR_LSI_TRIM_0,      (0x01 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_1,      (0x02 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_2,      (0x04 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_3,      (0x08 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_4,      (0x10 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_5,      (0x20 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_6,      (0x40 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_7,      (0x80 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_TRIM_8,      (0x100 << RCC_ICSCR_LSI_TRIM_Pos)
.equiv RCC_ICSCR_LSI_STARTUP_Pos, (26)
.equiv RCC_ICSCR_LSI_STARTUP_Msk, (0x3 << RCC_ICSCR_LSI_STARTUP_Pos)
.equiv RCC_ICSCR_LSI_STARTUP,     RCC_ICSCR_LSI_STARTUP_Msk
.equiv RCC_ICSCR_LSI_STARTUP_0,   (0x01 << RCC_ICSCR_LSI_STARTUP_Pos)
.equiv RCC_ICSCR_LSI_STARTUP_1,   (0x02 << RCC_ICSCR_LSI_STARTUP_Pos)

/********************  Bit definition for RCC_CFGR register  ***************/
/* SW configuration */
.equiv RCC_CFGR_SW_Pos,     (0)
.equiv RCC_CFGR_SW_Msk,     (0x7 << RCC_CFGR_SW_Pos)     /* 0x00000007 */
.equiv RCC_CFGR_SW,         RCC_CFGR_SW_Msk              /* SW[2:0] bits (System clock Switch) */
.equiv RCC_CFGR_SW_0,       (0x1 << RCC_CFGR_SW_Pos)     /* 0x00000001 */
.equiv RCC_CFGR_SW_1,       (0x2 << RCC_CFGR_SW_Pos)     /* 0x00000002 */
.equiv RCC_CFGR_SW_2,       (0x4 << RCC_CFGR_SW_Pos)     /* 0x00000004 */

/* SWS configuration */
.equiv RCC_CFGR_SWS_Pos,    (3)
.equiv RCC_CFGR_SWS_Msk,    (0x7 << RCC_CFGR_SWS_Pos)    /* 0x00000038 */
.equiv RCC_CFGR_SWS,        RCC_CFGR_SWS_Msk             /* SWS[2:0] bits (System Clock Switch Status) */
.equiv RCC_CFGR_SWS_0,      (0x1 << RCC_CFGR_SWS_Pos)    /* 0x00000008 */
.equiv RCC_CFGR_SWS_1,      (0x2 << RCC_CFGR_SWS_Pos)    /* 0x00000010 */
.equiv RCC_CFGR_SWS_2,      (0x4 << RCC_CFGR_SWS_Pos)    /* 0x00000020 */

.equiv RCC_CFGR_SWS_HSI,    (0)                          /* HSI used as system clock */
.equiv RCC_CFGR_SWS_HSE,    (0x00000008)                 /* HSE used as system clock */
.equiv RCC_CFGR_SWS_LSI,    (0x00000018)                 /* LSI used as system clock */

/* HPRE configuration */
.equiv RCC_CFGR_HPRE_Pos,   (8)
.equiv RCC_CFGR_HPRE_Msk,   (0xF << RCC_CFGR_HPRE_Pos)   /* 0x00000F00 */
.equiv RCC_CFGR_HPRE,       RCC_CFGR_HPRE_Msk            /* HPRE[3:0] bits (AHB prescaler) */
.equiv RCC_CFGR_HPRE_0,     (0x1 << RCC_CFGR_HPRE_Pos)   /* 0x00000100 */
.equiv RCC_CFGR_HPRE_1,     (0x2 << RCC_CFGR_HPRE_Pos)   /* 0x00000200 */
.equiv RCC_CFGR_HPRE_2,     (0x4 << RCC_CFGR_HPRE_Pos)   /* 0x00000400 */
.equiv RCC_CFGR_HPRE_3,     (0x8 << RCC_CFGR_HPRE_Pos)   /* 0x00000800 */

/* PPRE configuration */
.equiv RCC_CFGR_PPRE_Pos,   (12)
.equiv RCC_CFGR_PPRE_Msk,   (0x7 << RCC_CFGR_PPRE_Pos)   /* 0x00007000 */
.equiv RCC_CFGR_PPRE,       RCC_CFGR_PPRE_Msk            /* PRE1[2:0] bits (APB prescaler) */
.equiv RCC_CFGR_PPRE_0,     (0x1 << RCC_CFGR_PPRE_Pos)   /* 0x00001000 */
.equiv RCC_CFGR_PPRE_1,     (0x2 << RCC_CFGR_PPRE_Pos)   /* 0x00002000 */
.equiv RCC_CFGR_PPRE_2,     (0x4 << RCC_CFGR_PPRE_Pos)   /* 0x00004000 */

/* MCOSEL configuration */
.equiv RCC_CFGR_MCOSEL_Pos, (24)
.equiv RCC_CFGR_MCOSEL_Msk, (0x7 << RCC_CFGR_MCOSEL_Pos) /* 0x0F000000 */
.equiv RCC_CFGR_MCOSEL,     RCC_CFGR_MCOSEL_Msk          /* MCOSEL [2:0] bits (Clock output selection) */
.equiv RCC_CFGR_MCOSEL_0,   (0x1 << RCC_CFGR_MCOSEL_Pos) /* 0x01000000 */
.equiv RCC_CFGR_MCOSEL_1,   (0x2 << RCC_CFGR_MCOSEL_Pos) /* 0x02000000 */
.equiv RCC_CFGR_MCOSEL_2,   (0x4 << RCC_CFGR_MCOSEL_Pos) /* 0x04000000 */
.equiv RCC_CFGR_MCOSEL_OFF, (0x0 << RCC_CFGR_MCOSEL_Pos)
.equiv RCC_CFGR_MCOSEL_SYSCLK, (0x1 << RCC_CFGR_MCOSEL_Pos)
.equiv RCC_CFGR_MCOSEL_HSI, (0x3 << RCC_CFGR_MCOSEL_Pos)
.equiv RCC_CFGR_MCOSEL_HSE, (0x4 << RCC_CFGR_MCOSEL_Pos)
.equiv RCC_CFGR_MCOSEL_LSI, (0x6 << RCC_CFGR_MCOSEL_Pos)

/* MCO Prescaler configuration */
.equiv RCC_CFGR_MCOPRE_Pos, (28)
.equiv RCC_CFGR_MCOPRE_Msk, (0x7 << RCC_CFGR_MCOPRE_Pos) /* 0x70000000 */
.equiv RCC_CFGR_MCOPRE,     RCC_CFGR_MCOPRE_Msk          /* MCO prescaler [2:0] */
.equiv RCC_CFGR_MCOPRE_0,   (0x1 << RCC_CFGR_MCOPRE_Pos) /* 0x10000000 */
.equiv RCC_CFGR_MCOPRE_1,   (0x2 << RCC_CFGR_MCOPRE_Pos) /* 0x20000000 */
.equiv RCC_CFGR_MCOPRE_2,   (0x4 << RCC_CFGR_MCOPRE_Pos) /* 0x40000000 */

/********************  Bit definition for RCC_ECSCR register  ***************/
/* HSE FREQ configuration */
.equiv RCC_ECSCR_HSE_FREQ_Pos, (2)
.equiv RCC_ECSCR_HSE_FREQ_Msk, (3 << RCC_ECSCR_HSE_FREQ_Pos)   /* 0x0000000C */
.equiv RCC_ECSCR_HSE_FREQ,     RCC_ECSCR_HSE_FREQ_Msk
.equiv RCC_ECSCR_HSE_FREQ_0,   (0x1 << RCC_ECSCR_HSE_FREQ_Pos) /* 0x00000004 */
.equiv RCC_ECSCR_HSE_FREQ_1,   (0x2 << RCC_ECSCR_HSE_FREQ_Pos) /* 0x00000008 */

/********************  Bit definition for RCC_CIER register  ******************/
.equiv RCC_CIER_LSIRDYIE_Pos, (0)
.equiv RCC_CIER_LSIRDYIE_Msk, (0x1 << RCC_CIER_LSIRDYIE_Pos) /* 0x00000001 */
.equiv RCC_CIER_LSIRDYIE,     RCC_CIER_LSIRDYIE_Msk
.equiv RCC_CIER_HSIRDYIE_Pos, (3)
.equiv RCC_CIER_HSIRDYIE_Msk, (0x1 << RCC_CIER_HSIRDYIE_Pos) /* 0x00000008 */
.equiv RCC_CIER_HSIRDYIE,     RCC_CIER_HSIRDYIE_Msk
.equiv RCC_CIER_HSERDYIE_Pos, (4)
.equiv RCC_CIER_HSERDYIE_Msk, (0x1 << RCC_CIER_HSERDYIE_Pos) /* 0x00000010 */
.equiv RCC_CIER_HSERDYIE,     RCC_CIER_HSERDYIE_Msk

/********************  Bit definition for RCC_CIFR register  ******************/
.equiv RCC_CIFR_LSIRDYF_Pos, (0)
.equiv RCC_CIFR_LSIRDYF_Msk, (0x1 << RCC_CIFR_LSIRDYF_Pos) /* 0x00000001 */
.equiv RCC_CIFR_LSIRDYF,     RCC_CIFR_LSIRDYF_Msk
.equiv RCC_CIFR_HSIRDYF_Pos, (3)
.equiv RCC_CIFR_HSIRDYF_Msk, (0x1 << RCC_CIFR_HSIRDYF_Pos) /* 0x00000008 */
.equiv RCC_CIFR_HSIRDYF,     RCC_CIFR_HSIRDYF_Msk
.equiv RCC_CIFR_HSERDYF_Pos, (4)
.equiv RCC_CIFR_HSERDYF_Msk, (0x1 << RCC_CIFR_HSERDYF_Pos) /* 0x00000010 */
.equiv RCC_CIFR_HSERDYF,     RCC_CIFR_HSERDYF_Msk
.equiv RCC_CIFR_CSSF_Pos,    (8)
.equiv RCC_CIFR_CSSF_Msk,    (0x1 << RCC_CIFR_CSSF_Pos)    /* 0x00000100 */
.equiv RCC_CIFR_CSSF,        RCC_CIFR_CSSF_Msk

/********************  Bit definition for RCC_CICR register  ******************/
.equiv RCC_CICR_LSIRDYC_Pos, (0)
.equiv RCC_CICR_LSIRDYC_Msk, (0x1 << RCC_CICR_LSIRDYC_Pos)/* 0x00000001 */
.equiv RCC_CICR_LSIRDYC,     RCC_CICR_LSIRDYC_Msk
.equiv RCC_CICR_HSIRDYC_Pos, (3)
.equiv RCC_CICR_HSIRDYC_Msk, (0x1 << RCC_CICR_HSIRDYC_Pos)/* 0x00000008 */
.equiv RCC_CICR_HSIRDYC,     RCC_CICR_HSIRDYC_Msk
.equiv RCC_CICR_HSERDYC_Pos, (4)
.equiv RCC_CICR_HSERDYC_Msk, (0x1 << RCC_CICR_HSERDYC_Pos)/* 0x00000010 */
.equiv RCC_CICR_HSERDYC,     RCC_CICR_HSERDYC_Msk
.equiv RCC_CICR_CSSC_Pos,    (8)
.equiv RCC_CICR_CSSC_Msk,    (0x1 << RCC_CICR_CSSC_Pos)   /* 0x00000100 */
.equiv RCC_CICR_CSSC,        RCC_CICR_CSSC_Msk

/********************  Bit definition for RCC_IOPRSTR register  ****************/
.equiv RCC_IOPRSTR_GPIOARST_Pos, (0)
.equiv RCC_IOPRSTR_GPIOARST_Msk, (0x1 << RCC_IOPRSTR_GPIOARST_Pos) /* 0x00000001 */
.equiv RCC_IOPRSTR_GPIOARST,     RCC_IOPRSTR_GPIOARST_Msk
.equiv RCC_IOPRSTR_GPIOBRST_Pos, (1)
.equiv RCC_IOPRSTR_GPIOBRST_Msk, (0x1 << RCC_IOPRSTR_GPIOBRST_Pos) /* 0x00000002 */
.equiv RCC_IOPRSTR_GPIOBRST,     RCC_IOPRSTR_GPIOBRST_Msk
.equiv RCC_IOPRSTR_GPIOFRST_Pos, (5)
.equiv RCC_IOPRSTR_GPIOFRST_Msk, (0x1 << RCC_IOPRSTR_GPIOFRST_Pos) /* 0x00000020 */
.equiv RCC_IOPRSTR_GPIOFRST,     RCC_IOPRSTR_GPIOFRST_Msk

/********************  Bit definition for RCC_AHBRSTR register  ***************/
.equiv RCC_AHBRSTR_CRCRST_Pos, (12)
.equiv RCC_AHBRSTR_CRCRST_Msk, (0x1 << RCC_AHBRSTR_CRCRST_Pos) /* 0x00001000 */
.equiv RCC_AHBRSTR_CRCRST,     RCC_AHBRSTR_CRCRST_Msk

/********************  Bit definition for RCC_APBRSTR1 register  **************/
.equiv RCC_APBRSTR1_I2CRST_Pos,   (21)
.equiv RCC_APBRSTR1_I2CRST_Msk,   (0x1 << RCC_APBRSTR1_I2CRST_Pos)   /* 0x00200000 */
.equiv RCC_APBRSTR1_I2CRST,       RCC_APBRSTR1_I2CRST_Msk
.equiv RCC_APBRSTR1_DBGRST_Pos,   (27)
.equiv RCC_APBRSTR1_DBGRST_Msk,   (0x1 << RCC_APBRSTR1_DBGRST_Pos)   /* 0x08000000 */
.equiv RCC_APBRSTR1_DBGRST,       RCC_APBRSTR1_DBGRST_Msk
.equiv RCC_APBRSTR1_PWRRST_Pos,   (28)
.equiv RCC_APBRSTR1_PWRRST_Msk,   (0x1 << RCC_APBRSTR1_PWRRST_Pos)   /* 0x10000000 */
.equiv RCC_APBRSTR1_PWRRST,       RCC_APBRSTR1_PWRRST_Msk
.equiv RCC_APBRSTR1_LPTIMRST_Pos, (31)
.equiv RCC_APBRSTR1_LPTIMRST_Msk, (0x1 << RCC_APBRSTR1_LPTIMRST_Pos) /* 0x80000000 */
.equiv RCC_APBRSTR1_LPTIMRST,     RCC_APBRSTR1_LPTIMRST_Msk

/********************  Bit definition for RCC_APBRSTR2 register  **************/
.equiv RCC_APBRSTR2_SYSCFGRST_Pos, (0)
.equiv RCC_APBRSTR2_SYSCFGRST_Msk, (0x1 << RCC_APBRSTR2_SYSCFGRST_Pos) /* 0x00000001 */
.equiv RCC_APBRSTR2_SYSCFGRST,     RCC_APBRSTR2_SYSCFGRST_Msk
.equiv RCC_APBRSTR2_TIM1RST_Pos,   (11)
.equiv RCC_APBRSTR2_TIM1RST_Msk,   (0x1 << RCC_APBRSTR2_TIM1RST_Pos)   /* 0x00000800 */
.equiv RCC_APBRSTR2_TIM1RST,       RCC_APBRSTR2_TIM1RST_Msk
.equiv RCC_APBRSTR2_SPI1RST_Pos,   (12)
.equiv RCC_APBRSTR2_SPI1RST_Msk,   (0x1 << RCC_APBRSTR2_SPI1RST_Pos)   /* 0x00001000 */
.equiv RCC_APBRSTR2_SPI1RST,       RCC_APBRSTR2_SPI1RST_Msk
.equiv RCC_APBRSTR2_USART1RST_Pos, (14)
.equiv RCC_APBRSTR2_USART1RST_Msk, (0x1 << RCC_APBRSTR2_USART1RST_Pos) /* 0x00004000 */
.equiv RCC_APBRSTR2_USART1RST,     RCC_APBRSTR2_USART1RST_Msk
.equiv RCC_APBRSTR2_TIM16RST_Pos,  (17)
.equiv RCC_APBRSTR2_TIM16RST_Msk,  (0x1 << RCC_APBRSTR2_TIM16RST_Pos)  /* 0x00020000 */
.equiv RCC_APBRSTR2_TIM16RST,      RCC_APBRSTR2_TIM16RST_Msk
.equiv RCC_APBRSTR2_ADCRST_Pos,    (20)
.equiv RCC_APBRSTR2_ADCRST_Msk,    (0x1 << RCC_APBRSTR2_ADCRST_Pos)    /* 0x00100000 */
.equiv RCC_APBRSTR2_ADCRST,        RCC_APBRSTR2_ADCRST_Msk
.equiv RCC_APBRSTR2_COMP1RST_Pos,  (21)
.equiv RCC_APBRSTR2_COMP1RST_Msk,  (0x1 << RCC_APBRSTR2_COMP1RST_Pos)  /* 0x00200000 */
.equiv RCC_APBRSTR2_COMP1RST,      RCC_APBRSTR2_COMP1RST_Msk
.equiv RCC_APBRSTR2_COMP2RST_Pos,  (22)
.equiv RCC_APBRSTR2_COMP2RST_Msk,  (0x1 << RCC_APBRSTR2_COMP2RST_Pos)  /* 0x00400000 */
.equiv RCC_APBRSTR2_COMP2RST,      RCC_APBRSTR2_COMP2RST_Msk
/********************  Bit definition for RCC_IOPENR register  ****************/
.equiv RCC_IOPENR_GPIOAEN_Pos, (0)
.equiv RCC_IOPENR_GPIOAEN_Msk, (0x1 << RCC_IOPENR_GPIOAEN_Pos) /* 0x00000001 */
.equiv RCC_IOPENR_GPIOAEN,     RCC_IOPENR_GPIOAEN_Msk
.equiv RCC_IOPENR_GPIOBEN_Pos, (1)
.equiv RCC_IOPENR_GPIOBEN_Msk, (0x1 << RCC_IOPENR_GPIOBEN_Pos) /* 0x00000002 */
.equiv RCC_IOPENR_GPIOBEN,     RCC_IOPENR_GPIOBEN_Msk
.equiv RCC_IOPENR_GPIOFEN_Pos, (5)
.equiv RCC_IOPENR_GPIOFEN_Msk, (0x1 << RCC_IOPENR_GPIOFEN_Pos) /* 0x00000020 */
.equiv RCC_IOPENR_GPIOFEN,     RCC_IOPENR_GPIOFEN_Msk

/********************  Bit definition for RCC_AHBENR register  ****************/
.equiv RCC_AHBENR_FLASHEN_Pos, (8)
.equiv RCC_AHBENR_FLASHEN_Msk, (0x1 << RCC_AHBENR_FLASHEN_Pos) /* 0x00000100 */
.equiv RCC_AHBENR_FLASHEN,     RCC_AHBENR_FLASHEN_Msk
.equiv RCC_AHBENR_SRAMEN_Pos,  (9)
.equiv RCC_AHBENR_SRAMEN_Msk,  (0x1 << RCC_AHBENR_SRAMEN_Pos)  /* 0x00000100 */
.equiv RCC_AHBENR_SRAMEN,      RCC_AHBENR_SRAMEN_Msk
.equiv RCC_AHBENR_CRCEN_Pos,   (12)
.equiv RCC_AHBENR_CRCEN_Msk,   (0x1 << RCC_AHBENR_CRCEN_Pos)   /* 0x00001000 */
.equiv RCC_AHBENR_CRCEN,       RCC_AHBENR_CRCEN_Msk

/********************  Bit definition for RCC_APBENR1 register  ***************/
.equiv RCC_APBENR1_I2CEN_Pos,   (21)
.equiv RCC_APBENR1_I2CEN_Msk,   (0x1 << RCC_APBENR1_I2CEN_Pos)   /* 0x00200000 */
.equiv RCC_APBENR1_I2CEN,       RCC_APBENR1_I2CEN_Msk
.equiv RCC_APBENR1_DBGEN_Pos,   (27)
.equiv RCC_APBENR1_DBGEN_Msk,   (0x1 << RCC_APBENR1_DBGEN_Pos)   /* 0x08000000 */
.equiv RCC_APBENR1_DBGEN,       RCC_APBENR1_DBGEN_Msk
.equiv RCC_APBENR1_PWREN_Pos,   (28)
.equiv RCC_APBENR1_PWREN_Msk,   (0x1 << RCC_APBENR1_PWREN_Pos)   /* 0x10000000 */
.equiv RCC_APBENR1_PWREN,       RCC_APBENR1_PWREN_Msk
.equiv RCC_APBENR1_LPTIMEN_Pos, (31)
.equiv RCC_APBENR1_LPTIMEN_Msk, (0x1 << RCC_APBENR1_LPTIMEN_Pos) /* 0x80000000 */
.equiv RCC_APBENR1_LPTIMEN,     RCC_APBENR1_LPTIMEN_Msk

/********************  Bit definition for RCC_APBENR2 register  **************/
.equiv RCC_APBENR2_SYSCFGEN_Pos, (0)
.equiv RCC_APBENR2_SYSCFGEN_Msk, (0x1 << RCC_APBENR2_SYSCFGEN_Pos)    /* 0x00000001 */
.equiv RCC_APBENR2_SYSCFGEN,     RCC_APBENR2_SYSCFGEN_Msk
.equiv RCC_APBENR2_TIM1EN_Pos,   (11)
.equiv RCC_APBENR2_TIM1EN_Msk,   (0x1 << RCC_APBENR2_TIM1EN_Pos)      /* 0x00000800 */
.equiv RCC_APBENR2_TIM1EN,       RCC_APBENR2_TIM1EN_Msk
.equiv RCC_APBENR2_SPI1EN_Pos,   (12)
.equiv RCC_APBENR2_SPI1EN_Msk,   (0x1 << RCC_APBENR2_SPI1EN_Pos)      /* 0x00001000 */
.equiv RCC_APBENR2_SPI1EN,       RCC_APBENR2_SPI1EN_Msk
.equiv RCC_APBENR2_USART1EN_Pos, (14)
.equiv RCC_APBENR2_USART1EN_Msk, (0x1 << RCC_APBENR2_USART1EN_Pos)    /* 0x00004000 */
.equiv RCC_APBENR2_USART1EN,     RCC_APBENR2_USART1EN_Msk
.equiv RCC_APBENR2_TIM16EN_Pos,  (17)
.equiv RCC_APBENR2_TIM16EN_Msk,  (0x1 << RCC_APBENR2_TIM16EN_Pos)     /* 0x00020000 */
.equiv RCC_APBENR2_TIM16EN,      RCC_APBENR2_TIM16EN_Msk
.equiv RCC_APBENR2_ADCEN_Pos,    (20)
.equiv RCC_APBENR2_ADCEN_Msk,    (0x1 << RCC_APBENR2_ADCEN_Pos)       /* 0x00100000 */
.equiv RCC_APBENR2_ADCEN,        RCC_APBENR2_ADCEN_Msk
.equiv RCC_APBENR2_COMP1EN_Pos,  (21)
.equiv RCC_APBENR2_COMP1EN_Msk,  (0x1 << RCC_APBENR2_COMP1EN_Pos)       /* 0x00200000 */
.equiv RCC_APBENR2_COMP1EN,      RCC_APBENR2_COMP1EN_Msk
.equiv RCC_APBENR2_COMP2EN_Pos,  (22)
.equiv RCC_APBENR2_COMP2EN_Msk,  (0x1 << RCC_APBENR2_COMP2EN_Pos)       /* 0x00400000 */
.equiv RCC_APBENR2_COMP2EN,      RCC_APBENR2_COMP2EN_Msk

/********************  Bit definition for RCC_CCIPR register  ******************/
.equiv RCC_CCIPR_COMP1SEL_Pos, (8)
.equiv RCC_CCIPR_COMP1SEL_Msk, (0x1 << RCC_CCIPR_COMP1SEL_Pos) /* 0x00000100 */
.equiv RCC_CCIPR_COMP1SEL,     RCC_CCIPR_COMP1SEL_Msk
.equiv RCC_CCIPR_COMP2SEL_Pos, (9)
.equiv RCC_CCIPR_COMP2SEL_Msk, (0x1 << RCC_CCIPR_COMP2SEL_Pos) /* 0x00000200 */
.equiv RCC_CCIPR_COMP2SEL,     RCC_CCIPR_COMP2SEL_Msk
.equiv RCC_CCIPR_LPTIMSEL_Pos, (18)
.equiv RCC_CCIPR_LPTIMSEL_Msk, (0x3 << RCC_CCIPR_LPTIMSEL_Pos) /* 0x000C0000 */
.equiv RCC_CCIPR_LPTIMSEL,     RCC_CCIPR_LPTIMSEL_Msk
.equiv RCC_CCIPR_LPTIMSEL_0,   (0x1 << RCC_CCIPR_LPTIMSEL_Pos) /* 0x00040000 */
.equiv RCC_CCIPR_LPTIMSEL_1,   (0x2 << RCC_CCIPR_LPTIMSEL_Pos) /* 0x00080000 */

/********************  Bit definition for RCC_BDCR register  ******************/
.equiv RCC_BDCR_LSCOEN_Pos, (24)
.equiv RCC_BDCR_LSCOEN_Msk, (0x1 << RCC_BDCR_LSCOEN_Pos) /* 0x01000000 */
.equiv RCC_BDCR_LSCOEN,     RCC_BDCR_LSCOEN_Msk

/********************  Bit definition for RCC_CSR register  *******************/
.equiv RCC_CSR_LSION_Pos,       (0)
.equiv RCC_CSR_LSION_Msk,       (0x1 << RCC_CSR_LSION_Pos)       /* 0x00000001 */
.equiv RCC_CSR_LSION,           RCC_CSR_LSION_Msk
.equiv RCC_CSR_LSIRDY_Pos,      (1)
.equiv RCC_CSR_LSIRDY_Msk,      (0x1 << RCC_CSR_LSIRDY_Pos)      /* 0x00000002 */
.equiv RCC_CSR_LSIRDY,          RCC_CSR_LSIRDY_Msk
.equiv RCC_CSR_NRST_FLTDIS_Pos, (8)
.equiv RCC_CSR_NRST_FLTDIS_Msk, (0x1 << RCC_CSR_NRST_FLTDIS_Pos) /* 0x00000100 */
.equiv RCC_CSR_NRST_FLTDIS,     RCC_CSR_NRST_FLTDIS_Msk
.equiv RCC_CSR_RMVF_Pos,        (23)
.equiv RCC_CSR_RMVF_Msk,        (0x1 << RCC_CSR_RMVF_Pos)        /* 0x00800000 */
.equiv RCC_CSR_RMVF,            RCC_CSR_RMVF_Msk
.equiv RCC_CSR_OBLRSTF_Pos,     (25)
.equiv RCC_CSR_OBLRSTF_Msk,     (0x1 << RCC_CSR_OBLRSTF_Pos)     /* 0x02000000 */
.equiv RCC_CSR_OBLRSTF,         RCC_CSR_OBLRSTF_Msk
.equiv RCC_CSR_PINRSTF_Pos,     (26)
.equiv RCC_CSR_PINRSTF_Msk,     (0x1 << RCC_CSR_PINRSTF_Pos)     /* 0x04000000 */
.equiv RCC_CSR_PINRSTF,         RCC_CSR_PINRSTF_Msk
.equiv RCC_CSR_PWRRSTF_Pos,     (27)
.equiv RCC_CSR_PWRRSTF_Msk,     (0x1 << RCC_CSR_PWRRSTF_Pos)     /* 0x08000000 */
.equiv RCC_CSR_PWRRSTF,         RCC_CSR_PWRRSTF_Msk
.equiv RCC_CSR_SFTRSTF_Pos,     (28)
.equiv RCC_CSR_SFTRSTF_Msk,     (0x1 << RCC_CSR_SFTRSTF_Pos)     /* 0x10000000 */
.equiv RCC_CSR_SFTRSTF,         RCC_CSR_SFTRSTF_Msk
.equiv RCC_CSR_IWDGRSTF_Pos,    (29)
.equiv RCC_CSR_IWDGRSTF_Msk,    (0x1 << RCC_CSR_IWDGRSTF_Pos)    /* 0x20000000 */
.equiv RCC_CSR_IWDGRSTF,        RCC_CSR_IWDGRSTF_Msk

/******************************************************************************/
/*                                                                            */
/*                        Serial Peripheral Interface (SPI)                   */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for SPI_CR1 register  ********************/
.equiv SPI_CR1_CPHA_Pos,     (0)
.equiv SPI_CR1_CPHA_Msk,     (0x1 << SPI_CR1_CPHA_Pos)     /* 0x00000001 */
.equiv SPI_CR1_CPHA,         SPI_CR1_CPHA_Msk              /* Clock Phase */
.equiv SPI_CR1_CPOL_Pos,     (1)
.equiv SPI_CR1_CPOL_Msk,     (0x1 << SPI_CR1_CPOL_Pos)     /* 0x00000002 */
.equiv SPI_CR1_CPOL,         SPI_CR1_CPOL_Msk              /* Clock Polarity */
.equiv SPI_CR1_MSTR_Pos,     (2)
.equiv SPI_CR1_MSTR_Msk,     (0x1 << SPI_CR1_MSTR_Pos)     /* 0x00000004 */
.equiv SPI_CR1_MSTR,         SPI_CR1_MSTR_Msk              /* Master Selection */
.equiv SPI_CR1_BR_Pos,       (3)
.equiv SPI_CR1_BR_Msk,       (0x7 << SPI_CR1_BR_Pos)       /* 0x00000038 */
.equiv SPI_CR1_BR,           SPI_CR1_BR_Msk                /* BR[2:0] bits (Baud Rate Control) */
.equiv SPI_CR1_BR_0,         (0x1 << SPI_CR1_BR_Pos)       /* 0x00000008 */
.equiv SPI_CR1_BR_1,         (0x2 << SPI_CR1_BR_Pos)       /* 0x00000010 */
.equiv SPI_CR1_BR_2,         (0x4 << SPI_CR1_BR_Pos)       /* 0x00000020 */
.equiv SPI_CR1_SPE_Pos,      (6)
.equiv SPI_CR1_SPE_Msk,      (0x1 << SPI_CR1_SPE_Pos)      /* 0x00000040 */
.equiv SPI_CR1_SPE,          SPI_CR1_SPE_Msk               /* SPI Enable */
.equiv SPI_CR1_LSBFIRST_Pos, (7)
.equiv SPI_CR1_LSBFIRST_Msk, (0x1 << SPI_CR1_LSBFIRST_Pos) /* 0x00000080 */
.equiv SPI_CR1_LSBFIRST,     SPI_CR1_LSBFIRST_Msk          /* Frame Format */
.equiv SPI_CR1_SSI_Pos,      (8)
.equiv SPI_CR1_SSI_Msk,      (0x1 << SPI_CR1_SSI_Pos)      /* 0x00000100 */
.equiv SPI_CR1_SSI,          SPI_CR1_SSI_Msk               /* Internal slave select */
.equiv SPI_CR1_SSM_Pos,      (9)
.equiv SPI_CR1_SSM_Msk,      (0x1 << SPI_CR1_SSM_Pos)      /* 0x00000200 */
.equiv SPI_CR1_SSM,          SPI_CR1_SSM_Msk               /* Software slave management */
.equiv SPI_CR1_RXONLY_Pos,   (10)
.equiv SPI_CR1_RXONLY_Msk,   (0x1 << SPI_CR1_RXONLY_Pos)   /* 0x00000400 */
.equiv SPI_CR1_RXONLY,       SPI_CR1_RXONLY_Msk            /* Receive only */
.equiv SPI_CR1_BIDIOE_Pos,   (14)
.equiv SPI_CR1_BIDIOE_Msk,   (0x1 << SPI_CR1_BIDIOE_Pos)   /* 0x00004000 */
.equiv SPI_CR1_BIDIOE,       SPI_CR1_BIDIOE_Msk            /* Output enable in bidirectional mode */
.equiv SPI_CR1_BIDIMODE_Pos, (15)
.equiv SPI_CR1_BIDIMODE_Msk, (0x1 << SPI_CR1_BIDIMODE_Pos) /* 0x00008000 */
.equiv SPI_CR1_BIDIMODE,     SPI_CR1_BIDIMODE_Msk          /* Bidirectional data mode enable */

/*******************  Bit definition for SPI_CR2 register  ********************/
.equiv SPI_CR2_SSOE_Pos,   (2)
.equiv SPI_CR2_SSOE_Msk,   (0x1 << SPI_CR2_SSOE_Pos)   /* 0x00000004 */
.equiv SPI_CR2_SSOE,       SPI_CR2_SSOE_Msk            /* SS Output Enable */
.equiv SPI_CR2_ERRIE_Pos,  (5)
.equiv SPI_CR2_ERRIE_Msk,  (0x1 << SPI_CR2_ERRIE_Pos)  /* 0x00000020 */
.equiv SPI_CR2_ERRIE,      SPI_CR2_ERRIE_Msk           /* Error Interrupt Enable */
.equiv SPI_CR2_RXNEIE_Pos, (6)
.equiv SPI_CR2_RXNEIE_Msk, (0x1 << SPI_CR2_RXNEIE_Pos) /* 0x00000040 */
.equiv SPI_CR2_RXNEIE,     SPI_CR2_RXNEIE_Msk          /* RX buffer Not Empty Interrupt Enable */
.equiv SPI_CR2_TXEIE_Pos,  (7)
.equiv SPI_CR2_TXEIE_Msk,  (0x1 << SPI_CR2_TXEIE_Pos)  /* 0x00000080 */
.equiv SPI_CR2_TXEIE,      SPI_CR2_TXEIE_Msk           /* Tx buffer Empty Interrupt Enable */
.equiv SPI_CR2_DS_Pos,     (11)
.equiv SPI_CR2_DS_Msk,     (0x1 << SPI_CR2_DS_Pos)     /* 0x00000800 */
.equiv SPI_CR2_DS,         SPI_CR2_DS_Msk
.equiv SPI_CR2_FRXTH_Pos,  (12)
.equiv SPI_CR2_FRXTH_Msk,  (0x1 << SPI_CR2_FRXTH_Pos)  /* 0x00001000 */
.equiv SPI_CR2_FRXTH,      SPI_CR2_FRXTH_Msk           /* FIFO reception Threshold */
.equiv SPI_CR2_SLVFM_Pos,  (15)
.equiv SPI_CR2_SLVFM_Msk,  (0x1 << SPI_CR2_SLVFM_Pos)  /* 0x00008000 */
.equiv SPI_CR2_SLVFM,      SPI_CR2_SLVFM_Msk           /* Slave fast mode enable */

/********************  Bit definition for SPI_SR register  ********************/
.equiv SPI_SR_RXNE_Pos,  (0)
.equiv SPI_SR_RXNE_Msk,  (0x1 << SPI_SR_RXNE_Pos)  /* 0x00000001 */
.equiv SPI_SR_RXNE,      SPI_SR_RXNE_Msk           /* Receive buffer Not Empty */
.equiv SPI_SR_TXE_Pos,   (1)
.equiv SPI_SR_TXE_Msk,   (0x1 << SPI_SR_TXE_Pos)   /* 0x00000002 */
.equiv SPI_SR_TXE,       SPI_SR_TXE_Msk            /* Transmit buffer Empty */
.equiv SPI_SR_MODF_Pos,  (5)
.equiv SPI_SR_MODF_Msk,  (0x1 << SPI_SR_MODF_Pos)  /* 0x00000020 */
.equiv SPI_SR_MODF,      SPI_SR_MODF_Msk           /* Mode fault */
.equiv SPI_SR_OVR_Pos,   (6)
.equiv SPI_SR_OVR_Msk,   (0x1 << SPI_SR_OVR_Pos)   /* 0x00000040 */
.equiv SPI_SR_OVR,       SPI_SR_OVR_Msk            /* Overrun flag */
.equiv SPI_SR_BSY_Pos,   (7)
.equiv SPI_SR_BSY_Msk,   (0x1 << SPI_SR_BSY_Pos)   /* 0x00000080 */
.equiv SPI_SR_BSY,       SPI_SR_BSY_Msk            /* Busy flag */
.equiv SPI_SR_FRLVL_Pos, (9)
.equiv SPI_SR_FRLVL_Msk, (0x3 << SPI_SR_FRLVL_Pos) /* 0x00000600 */
.equiv SPI_SR_FRLVL,     SPI_SR_FRLVL_Msk          /* FIFO Reception Level */
.equiv SPI_SR_FRLVL_0,   (0x1 << SPI_SR_FRLVL_Pos) /* 0x00000200 */
.equiv SPI_SR_FRLVL_1,   (0x2 << SPI_SR_FRLVL_Pos) /* 0x00000400 */
.equiv SPI_SR_FTLVL_Pos, (11)
.equiv SPI_SR_FTLVL_Msk, (0x3 << SPI_SR_FTLVL_Pos) /* 0x00001800 */
.equiv SPI_SR_FTLVL,     SPI_SR_FTLVL_Msk          /* FIFO Transmission Level */
.equiv SPI_SR_FTLVL_0,   (0x1 << SPI_SR_FTLVL_Pos) /* 0x00000800 */
.equiv SPI_SR_FTLVL_1,   (0x2 << SPI_SR_FTLVL_Pos) /* 0x00001000 */

/********************  Bit definition for SPI_DR register  ********************/
.equiv SPI_DR_DR_Pos, (0)
.equiv SPI_DR_DR_Msk, (0xFFFF << SPI_DR_DR_Pos) /* 0x0000FFFF */
.equiv SPI_DR_DR,     SPI_DR_DR_Msk             /* Data Register */

/******************************************************************************/
/*                                                                            */
/*                       System Configuration (SYSCFG)                        */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for SYSCFG_CFGR1 register  ****************/
.equiv SYSCFG_CFGR1_MEM_MODE_Pos,     (0)
.equiv SYSCFG_CFGR1_MEM_MODE_Msk,     (0x3 << SYSCFG_CFGR1_MEM_MODE_Pos)    /* 0x00000003 */
.equiv SYSCFG_CFGR1_MEM_MODE,         SYSCFG_CFGR1_MEM_MODE_Msk             /* SYSCFG_Memory Remap Config */
.equiv SYSCFG_CFGR1_MEM_MODE_0,       (0x1 << SYSCFG_CFGR1_MEM_MODE_Pos)    /* 0x00000001 */
.equiv SYSCFG_CFGR1_MEM_MODE_1,       (0x2 << SYSCFG_CFGR1_MEM_MODE_Pos)    /* 0x00000002 */
.equiv SYSCFG_CFGR1_I2C_PA2_ANF_Pos,  (18)
.equiv SYSCFG_CFGR1_I2C_PA2_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PA2_ANF_Pos) /* 0x00040000 */
.equiv SYSCFG_CFGR1_I2C_PA2_ANF,      SYSCFG_CFGR1_I2C_PA2_ANF_Msk          /* PA2 ANF */
.equiv SYSCFG_CFGR1_I2C_PA3_ANF_Pos,  (19)
.equiv SYSCFG_CFGR1_I2C_PA3_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PA3_ANF_Pos) /* 0x00080000 */
.equiv SYSCFG_CFGR1_I2C_PA3_ANF,      SYSCFG_CFGR1_I2C_PA3_ANF_Msk          /* PA3 ANF */
.equiv SYSCFG_CFGR1_I2C_PA7_ANF_Pos,  (20)
.equiv SYSCFG_CFGR1_I2C_PA7_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PA7_ANF_Pos) /* 0x00100000 */
.equiv SYSCFG_CFGR1_I2C_PA7_ANF,      SYSCFG_CFGR1_I2C_PA7_ANF_Msk          /* PA7 ANF */
.equiv SYSCFG_CFGR1_I2C_PA8_ANF_Pos,  (21)
.equiv SYSCFG_CFGR1_I2C_PA8_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PA8_ANF_Pos) /* 0x00200000 */
.equiv SYSCFG_CFGR1_I2C_PA8_ANF,      SYSCFG_CFGR1_I2C_PA8_ANF_Msk          /* PA8 ANF */
.equiv SYSCFG_CFGR1_I2C_PA9_ANF_Pos,  (22)
.equiv SYSCFG_CFGR1_I2C_PA9_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PA9_ANF_Pos) /* 0x00400000 */
.equiv SYSCFG_CFGR1_I2C_PA9_ANF,      SYSCFG_CFGR1_I2C_PA9_ANF_Msk          /* PA9 ANF */
.equiv SYSCFG_CFGR1_I2C_PA10_ANF_Pos, (23)
.equiv SYSCFG_CFGR1_I2C_PA10_ANF_Msk, (0x1 << SYSCFG_CFGR1_I2C_PA10_ANF_Pos) /* 0x00800000 */
.equiv SYSCFG_CFGR1_I2C_PA10_ANF,     SYSCFG_CFGR1_I2C_PA10_ANF_Msk          /* PA10 ANF */
.equiv SYSCFG_CFGR1_I2C_PA11_ANF_Pos, (24)
.equiv SYSCFG_CFGR1_I2C_PA11_ANF_Msk, (0x1 << SYSCFG_CFGR1_I2C_PA11_ANF_Pos) /* 0x01000000 */
.equiv SYSCFG_CFGR1_I2C_PA11_ANF,     SYSCFG_CFGR1_I2C_PA11_ANF_Msk          /* PA11 ANF */
.equiv SYSCFG_CFGR1_I2C_PA12_ANF_Pos, (25)
.equiv SYSCFG_CFGR1_I2C_PA12_ANF_Msk, (0x1 << SYSCFG_CFGR1_I2C_PA12_ANF_Pos) /* 0x02000000 */
.equiv SYSCFG_CFGR1_I2C_PA12_ANF,     SYSCFG_CFGR1_I2C_PA12_ANF_Msk          /* PA12 ANF */
.equiv SYSCFG_CFGR1_I2C_PB6_ANF_Pos,  (26)
.equiv SYSCFG_CFGR1_I2C_PB6_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PB6_ANF_Pos) /* 0x04000000 */
.equiv SYSCFG_CFGR1_I2C_PB6_ANF,      SYSCFG_CFGR1_I2C_PB6_ANF_Msk          /* PB6 ANF */
.equiv SYSCFG_CFGR1_I2C_PB7_ANF_Pos,  (27)
.equiv SYSCFG_CFGR1_I2C_PB7_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PB7_ANF_Pos) /* 0x08000000 */
.equiv SYSCFG_CFGR1_I2C_PB7_ANF,      SYSCFG_CFGR1_I2C_PB7_ANF_Msk          /* PB7 ANF */
.equiv SYSCFG_CFGR1_I2C_PB8_ANF_Pos,  (28)
.equiv SYSCFG_CFGR1_I2C_PB8_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PB8_ANF_Pos) /* 0x10000000 */
.equiv SYSCFG_CFGR1_I2C_PB8_ANF,      SYSCFG_CFGR1_I2C_PB8_ANF_Msk          /* PB8 ANF */
.equiv SYSCFG_CFGR1_I2C_PF0_ANF_Pos,  (29)
.equiv SYSCFG_CFGR1_I2C_PF0_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PF0_ANF_Pos) /* 0x20000000 */
.equiv SYSCFG_CFGR1_I2C_PF0_ANF,      SYSCFG_CFGR1_I2C_PF0_ANF_Msk          /* PF0 ANF */
.equiv SYSCFG_CFGR1_I2C_PF1_ANF_Pos,  (30)
.equiv SYSCFG_CFGR1_I2C_PF1_ANF_Msk,  (0x1 << SYSCFG_CFGR1_I2C_PF1_ANF_Pos) /* 0x40000000 */
.equiv SYSCFG_CFGR1_I2C_PF1_ANF,      SYSCFG_CFGR1_I2C_PF1_ANF_Msk          /* PF1 ANF */

/******************  Bit definition for SYSCFG_CFGR2 register  ****************/
.equiv SYSCFG_CFGR2_LOCKUP_LOCK_Pos,     (0)
.equiv SYSCFG_CFGR2_LOCKUP_LOCK_Msk,     (0x1 << SYSCFG_CFGR2_LOCKUP_LOCK_Pos)     /* 0x00000001 */
.equiv SYSCFG_CFGR2_LOCKUP_LOCK,         SYSCFG_CFGR2_LOCKUP_LOCK_Msk              /* Enables and locks the LOCKUP_LOCK (Hardfault) output of CortexM0 with Break Input of TIMER1 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM1_Pos,  (3)
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM1_Msk,  (0x1 << SYSCFG_CFGR2_COMP1_BRK_TIM1_Pos)  /* 0x00000008 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM1,      SYSCFG_CFGR2_COMP1_BRK_TIM1_Msk           /* COMP1_BRK_TIM1 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM1_Pos,  (4)
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM1_Msk,  (0x1 << SYSCFG_CFGR2_COMP2_BRK_TIM1_Pos)  /* 0x00000010 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM1,      SYSCFG_CFGR2_COMP2_BRK_TIM1_Msk           /* COMP2_BRK_TIM1 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM16_Pos, (5)
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM16_Msk, (0x1 << SYSCFG_CFGR2_COMP1_BRK_TIM16_Pos) /* 0x00000020 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM16,     SYSCFG_CFGR2_COMP1_BRK_TIM16_Msk          /* COMP1_BRK_TIM16 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM16_Pos, (6)
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM16_Msk, (0x1 << SYSCFG_CFGR2_COMP2_BRK_TIM16_Pos) /* 0x00000040 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM16,     SYSCFG_CFGR2_COMP2_BRK_TIM16_Msk          /* COMP2_BRK_TIM16 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM17_Pos, (7)
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM17_Msk, (0x1 << SYSCFG_CFGR2_COMP1_BRK_TIM17_Pos) /* 0x00000080 */
.equiv SYSCFG_CFGR2_COMP1_BRK_TIM17,     SYSCFG_CFGR2_COMP1_BRK_TIM17_Msk          /* COMP1_BRK_TIM17 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM17_Pos, (8)
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM17_Msk, (0x1 << SYSCFG_CFGR2_COMP2_BRK_TIM17_Pos) /* 0x00000100 */
.equiv SYSCFG_CFGR2_COMP2_BRK_TIM17,     SYSCFG_CFGR2_COMP2_BRK_TIM17_Msk          /* COMP2_BRK_TIM17 */
.equiv SYSCFG_CFGR2_ETR_SRC_TIM1_Pos,    (9)
.equiv SYSCFG_CFGR2_ETR_SRC_TIM1_Msk,    (0x3 << SYSCFG_CFGR2_ETR_SRC_TIM1_Pos)    /* 0x00000600 */
.equiv SYSCFG_CFGR2_ETR_SRC_TIM1,        SYSCFG_CFGR2_ETR_SRC_TIM1_Msk             /* ETR_SRC_TIM1 */
.equiv SYSCFG_CFGR2_ETR_SRC_TIM1_0,      (0x1 << SYSCFG_CFGR2_ETR_SRC_TIM1_Pos)
.equiv SYSCFG_CFGR2_ETR_SRC_TIM1_1,      (0x2 << SYSCFG_CFGR2_ETR_SRC_TIM1_Pos)

/*****************************************************************************/
/*                                                                           */
/*                               Timers (TIM)                                */
/*                                                                           */
/*****************************************************************************/
/*******************  Bit definition for TIM_CR1 register  *******************/
.equiv TIM_CR1_CEN_Pos,  (0)
.equiv TIM_CR1_CEN_Msk,  (0x1 << TIM_CR1_CEN_Pos)  /* 0x00000001 */
.equiv TIM_CR1_CEN,      TIM_CR1_CEN_Msk           /*Counter enable */
.equiv TIM_CR1_UDIS_Pos, (1)
.equiv TIM_CR1_UDIS_Msk, (0x1 << TIM_CR1_UDIS_Pos) /* 0x00000002 */
.equiv TIM_CR1_UDIS,     TIM_CR1_UDIS_Msk          /*Update disable */
.equiv TIM_CR1_URS_Pos,  (2)
.equiv TIM_CR1_URS_Msk,  (0x1 << TIM_CR1_URS_Pos)  /* 0x00000004 */
.equiv TIM_CR1_URS,      TIM_CR1_URS_Msk           /*Update request source */
.equiv TIM_CR1_OPM_Pos,  (3)
.equiv TIM_CR1_OPM_Msk,  (0x1 << TIM_CR1_OPM_Pos)  /* 0x00000008 */
.equiv TIM_CR1_OPM,      TIM_CR1_OPM_Msk           /*One pulse mode */
.equiv TIM_CR1_DIR_Pos,  (4)
.equiv TIM_CR1_DIR_Msk,  (0x1 << TIM_CR1_DIR_Pos)  /* 0x00000010 */
.equiv TIM_CR1_DIR,      TIM_CR1_DIR_Msk           /*Direction */

.equiv TIM_CR1_CMS_Pos,  (5)
.equiv TIM_CR1_CMS_Msk,  (0x3 << TIM_CR1_CMS_Pos)  /* 0x00000060 */
.equiv TIM_CR1_CMS,      TIM_CR1_CMS_Msk           /*CMS[1:0] bits (Center-aligned mode selection) */
.equiv TIM_CR1_CMS_0,    (0x1 << TIM_CR1_CMS_Pos)  /* 0x00000020 */
.equiv TIM_CR1_CMS_1,    (0x2 << TIM_CR1_CMS_Pos)  /* 0x00000040 */

.equiv TIM_CR1_ARPE_Pos, (7)
.equiv TIM_CR1_ARPE_Msk, (0x1 << TIM_CR1_ARPE_Pos) /* 0x00000080 */
.equiv TIM_CR1_ARPE,     TIM_CR1_ARPE_Msk          /*Auto-reload preload enable */

.equiv TIM_CR1_CKD_Pos,  (8)
.equiv TIM_CR1_CKD_Msk,  (0x3 << TIM_CR1_CKD_Pos)  /* 0x00000300 */
.equiv TIM_CR1_CKD,      TIM_CR1_CKD_Msk           /*CKD[1:0] bits (clock division) */
.equiv TIM_CR1_CKD_0,    (0x1 << TIM_CR1_CKD_Pos)  /* 0x00000100 */
.equiv TIM_CR1_CKD_1,    (0x2 << TIM_CR1_CKD_Pos)  /* 0x00000200 */

/*******************  Bit definition for TIM_CR2 register  *******************/
.equiv TIM_CR2_CCPC_Pos,  (0)
.equiv TIM_CR2_CCPC_Msk,  (0x1 << TIM_CR2_CCPC_Pos)  /* 0x00000001 */
.equiv TIM_CR2_CCPC,      TIM_CR2_CCPC_Msk            /*Capture/Compare Preloaded Control */
.equiv TIM_CR2_CCUS_Pos,  (2)
.equiv TIM_CR2_CCUS_Msk,  (0x1 << TIM_CR2_CCUS_Pos)  /* 0x00000004 */
.equiv TIM_CR2_CCUS,      TIM_CR2_CCUS_Msk            /*Capture/Compare Control Update Selection */

.equiv TIM_CR2_MMS_Pos,   (4)
.equiv TIM_CR2_MMS_Msk,   (0x7 << TIM_CR2_MMS_Pos)   /* 0x00000070 */
.equiv TIM_CR2_MMS,       TIM_CR2_MMS_Msk             /*MMS[2:0] bits (Master Mode Selection) */
.equiv TIM_CR2_MMS_0,     (0x1 << TIM_CR2_MMS_Pos)   /* 0x00000010 */
.equiv TIM_CR2_MMS_1,     (0x2 << TIM_CR2_MMS_Pos)   /* 0x00000020 */
.equiv TIM_CR2_MMS_2,     (0x4 << TIM_CR2_MMS_Pos)   /* 0x00000040 */

.equiv TIM_CR2_TI1S_Pos,  (7)
.equiv TIM_CR2_TI1S_Msk,  (0x1 << TIM_CR2_TI1S_Pos)  /* 0x00000080 */
.equiv TIM_CR2_TI1S,      TIM_CR2_TI1S_Msk           /*TI1 Selection */
.equiv TIM_CR2_OIS1_Pos,  (8)
.equiv TIM_CR2_OIS1_Msk,  (0x1 << TIM_CR2_OIS1_Pos)  /* 0x00000100 */
.equiv TIM_CR2_OIS1,      TIM_CR2_OIS1_Msk           /*Output Idle state 1 (OC1 output) */
.equiv TIM_CR2_OIS1N_Pos, (9)
.equiv TIM_CR2_OIS1N_Msk, (0x1 << TIM_CR2_OIS1N_Pos) /* 0x00000200 */
.equiv TIM_CR2_OIS1N,     TIM_CR2_OIS1N_Msk          /*Output Idle state 1 (OC1N output) */
.equiv TIM_CR2_OIS2_Pos,  (10)
.equiv TIM_CR2_OIS2_Msk,  (0x1 << TIM_CR2_OIS2_Pos)  /* 0x00000400 */
.equiv TIM_CR2_OIS2,      TIM_CR2_OIS2_Msk           /*Output Idle state 2 (OC2 output) */
.equiv TIM_CR2_OIS2N_Pos, (11)
.equiv TIM_CR2_OIS2N_Msk, (0x1 << TIM_CR2_OIS2N_Pos) /* 0x00000800 */
.equiv TIM_CR2_OIS2N,     TIM_CR2_OIS2N_Msk          /*Output Idle state 2 (OC2N output) */
.equiv TIM_CR2_OIS3_Pos,  (12)
.equiv TIM_CR2_OIS3_Msk,  (0x1 << TIM_CR2_OIS3_Pos)  /* 0x00001000 */
.equiv TIM_CR2_OIS3,      TIM_CR2_OIS3_Msk           /*Output Idle state 3 (OC3 output) */
.equiv TIM_CR2_OIS3N_Pos, (13)
.equiv TIM_CR2_OIS3N_Msk, (0x1 << TIM_CR2_OIS3N_Pos) /* 0x00002000 */
.equiv TIM_CR2_OIS3N,     TIM_CR2_OIS3N_Msk          /*Output Idle state 3 (OC3N output) */
.equiv TIM_CR2_OIS4_Pos,  (14)
.equiv TIM_CR2_OIS4_Msk,  (0x1 << TIM_CR2_OIS4_Pos)  /* 0x00004000 */
.equiv TIM_CR2_OIS4,      TIM_CR2_OIS4_Msk           /*Output Idle state 4 (OC4 output) */

/*******************  Bit definition for TIM_SMCR register  ******************/
.equiv TIM_SMCR_SMS_Pos,  (0)
.equiv TIM_SMCR_SMS_Msk,  (0x7 << TIM_SMCR_SMS_Pos)  /* 0x00000007 */
.equiv TIM_SMCR_SMS,      TIM_SMCR_SMS_Msk           /*SMS[2:0] bits (Slave mode selection) */
.equiv TIM_SMCR_SMS_0,    (0x1 << TIM_SMCR_SMS_Pos)  /* 0x00000001 */
.equiv TIM_SMCR_SMS_1,    (0x2 << TIM_SMCR_SMS_Pos)  /* 0x00000002 */
.equiv TIM_SMCR_SMS_2,    (0x4 << TIM_SMCR_SMS_Pos)  /* 0x00000004 */

.equiv TIM_SMCR_OCCS_Pos, (3)
.equiv TIM_SMCR_OCCS_Msk, (0x1 << TIM_SMCR_OCCS_Pos) /* 0x00000008 */
.equiv TIM_SMCR_OCCS,     TIM_SMCR_OCCS_Msk          /* OCREF clear selection */

.equiv TIM_SMCR_TS_Pos,   (4)
.equiv TIM_SMCR_TS_Msk,   (0x7 << TIM_SMCR_TS_Pos)   /* 0x00000070 */
.equiv TIM_SMCR_TS,       TIM_SMCR_TS_Msk            /*TS[2:0] bits (Trigger selection) */
.equiv TIM_SMCR_TS_0,     (0x1 << TIM_SMCR_TS_Pos)   /* 0x00000010 */
.equiv TIM_SMCR_TS_1,     (0x2 << TIM_SMCR_TS_Pos)   /* 0x00000020 */
.equiv TIM_SMCR_TS_2,     (0x4 << TIM_SMCR_TS_Pos)   /* 0x00000040 */

.equiv TIM_SMCR_MSM_Pos,  (7)
.equiv TIM_SMCR_MSM_Msk,  (0x1 << TIM_SMCR_MSM_Pos)  /* 0x00000080 */
.equiv TIM_SMCR_MSM,      TIM_SMCR_MSM_Msk           /*Master/slave mode */

.equiv TIM_SMCR_ETF_Pos,  (8)
.equiv TIM_SMCR_ETF_Msk,  (0xF << TIM_SMCR_ETF_Pos)  /* 0x00000F00 */
.equiv TIM_SMCR_ETF,      TIM_SMCR_ETF_Msk           /*ETF[3:0] bits (External trigger filter) */
.equiv TIM_SMCR_ETF_0,    (0x1 << TIM_SMCR_ETF_Pos)  /* 0x00000100 */
.equiv TIM_SMCR_ETF_1,    (0x2 << TIM_SMCR_ETF_Pos)  /* 0x00000200 */
.equiv TIM_SMCR_ETF_2,    (0x4 << TIM_SMCR_ETF_Pos)  /* 0x00000400 */
.equiv TIM_SMCR_ETF_3,    (0x8 << TIM_SMCR_ETF_Pos)  /* 0x00000800 */

.equiv TIM_SMCR_ETPS_Pos, (12)
.equiv TIM_SMCR_ETPS_Msk, (0x3 << TIM_SMCR_ETPS_Pos) /* 0x00003000 */
.equiv TIM_SMCR_ETPS,     TIM_SMCR_ETPS_Msk          /*ETPS[1:0] bits (External trigger prescaler) */
.equiv TIM_SMCR_ETPS_0,   (0x1 << TIM_SMCR_ETPS_Pos) /* 0x00001000 */
.equiv TIM_SMCR_ETPS_1,   (0x2 << TIM_SMCR_ETPS_Pos) /* 0x00002000 */

.equiv TIM_SMCR_ECE_Pos,  (14)
.equiv TIM_SMCR_ECE_Msk,  (0x1 << TIM_SMCR_ECE_Pos)  /* 0x00004000 */
.equiv TIM_SMCR_ECE,      TIM_SMCR_ECE_Msk           /*External clock enable */
.equiv TIM_SMCR_ETP_Pos,  (15)
.equiv TIM_SMCR_ETP_Msk,  (0x1 << TIM_SMCR_ETP_Pos)  /* 0x00008000 */
.equiv TIM_SMCR_ETP,      TIM_SMCR_ETP_Msk           /*External trigger polarity */

/*******************  Bit definition for TIM_DIER register  ******************/
.equiv TIM_DIER_UIE_Pos,   (0)
.equiv TIM_DIER_UIE_Msk,   (0x1 << TIM_DIER_UIE_Pos)   /* 0x00000001 */
.equiv TIM_DIER_UIE,       TIM_DIER_UIE_Msk            /*Update interrupt enable */
.equiv TIM_DIER_CC1IE_Pos, (1)
.equiv TIM_DIER_CC1IE_Msk, (0x1 << TIM_DIER_CC1IE_Pos) /* 0x00000002 */
.equiv TIM_DIER_CC1IE,     TIM_DIER_CC1IE_Msk          /*Capture/Compare 1 interrupt enable */
.equiv TIM_DIER_CC2IE_Pos, (2)
.equiv TIM_DIER_CC2IE_Msk, (0x1 << TIM_DIER_CC2IE_Pos) /* 0x00000004 */
.equiv TIM_DIER_CC2IE,     TIM_DIER_CC2IE_Msk          /*Capture/Compare 2 interrupt enable */
.equiv TIM_DIER_CC3IE_Pos, (3)
.equiv TIM_DIER_CC3IE_Msk, (0x1 << TIM_DIER_CC3IE_Pos) /* 0x00000008 */
.equiv TIM_DIER_CC3IE,     TIM_DIER_CC3IE_Msk          /*Capture/Compare 3 interrupt enable */
.equiv TIM_DIER_CC4IE_Pos, (4)
.equiv TIM_DIER_CC4IE_Msk, (0x1 << TIM_DIER_CC4IE_Pos) /* 0x00000010 */
.equiv TIM_DIER_CC4IE,     TIM_DIER_CC4IE_Msk          /*Capture/Compare 4 interrupt enable */
.equiv TIM_DIER_COMIE_Pos, (5)
.equiv TIM_DIER_COMIE_Msk, (0x1 << TIM_DIER_COMIE_Pos) /* 0x00000020 */
.equiv TIM_DIER_COMIE,     TIM_DIER_COMIE_Msk          /*COM interrupt enable */
.equiv TIM_DIER_TIE_Pos,   (6)
.equiv TIM_DIER_TIE_Msk,   (0x1 << TIM_DIER_TIE_Pos)   /* 0x00000040 */
.equiv TIM_DIER_TIE,       TIM_DIER_TIE_Msk            /*Trigger interrupt enable */
.equiv TIM_DIER_BIE_Pos,   (7)
.equiv TIM_DIER_BIE_Msk,   (0x1 << TIM_DIER_BIE_Pos)   /* 0x00000080 */
.equiv TIM_DIER_BIE,       TIM_DIER_BIE_Msk            /*Break interrupt enable */

/********************  Bit definition for TIM_SR register  *******************/
.equiv TIM_SR_UIF_Pos,   (0)
.equiv TIM_SR_UIF_Msk,   (0x1 << TIM_SR_UIF_Pos)   /* 0x00000001 */
.equiv TIM_SR_UIF,       TIM_SR_UIF_Msk            /*Update interrupt Flag */
.equiv TIM_SR_CC1IF_Pos, (1)
.equiv TIM_SR_CC1IF_Msk, (0x1 << TIM_SR_CC1IF_Pos) /* 0x00000002 */
.equiv TIM_SR_CC1IF,     TIM_SR_CC1IF_Msk          /*Capture/Compare 1 interrupt Flag */
.equiv TIM_SR_CC2IF_Pos, (2)
.equiv TIM_SR_CC2IF_Msk, (0x1 << TIM_SR_CC2IF_Pos) /* 0x00000004 */
.equiv TIM_SR_CC2IF,     TIM_SR_CC2IF_Msk          /*Capture/Compare 2 interrupt Flag */
.equiv TIM_SR_CC3IF_Pos, (3)
.equiv TIM_SR_CC3IF_Msk, (0x1 << TIM_SR_CC3IF_Pos) /* 0x00000008 */
.equiv TIM_SR_CC3IF,     TIM_SR_CC3IF_Msk          /*Capture/Compare 3 interrupt Flag */
.equiv TIM_SR_CC4IF_Pos, (4)
.equiv TIM_SR_CC4IF_Msk, (0x1 << TIM_SR_CC4IF_Pos) /* 0x00000010 */
.equiv TIM_SR_CC4IF,     TIM_SR_CC4IF_Msk          /*Capture/Compare 4 interrupt Flag */
.equiv TIM_SR_COMIF_Pos, (5)
.equiv TIM_SR_COMIF_Msk, (0x1 << TIM_SR_COMIF_Pos) /* 0x00000020 */
.equiv TIM_SR_COMIF,     TIM_SR_COMIF_Msk          /*COM interrupt Flag */
.equiv TIM_SR_TIF_Pos,   (6)
.equiv TIM_SR_TIF_Msk,   (0x1 << TIM_SR_TIF_Pos)   /* 0x00000040 */
.equiv TIM_SR_TIF,       TIM_SR_TIF_Msk            /*Trigger interrupt Flag */
.equiv TIM_SR_BIF_Pos,   (7)
.equiv TIM_SR_BIF_Msk,   (0x1 << TIM_SR_BIF_Pos)   /* 0x00000080 */
.equiv TIM_SR_BIF,       TIM_SR_BIF_Msk            /*Break interrupt Flag */
.equiv TIM_SR_CC1OF_Pos, (9)
.equiv TIM_SR_CC1OF_Msk, (0x1 << TIM_SR_CC1OF_Pos) /* 0x00000200 */
.equiv TIM_SR_CC1OF,     TIM_SR_CC1OF_Msk          /*Capture/Compare 1 Overcapture Flag */
.equiv TIM_SR_CC2OF_Pos, (10)
.equiv TIM_SR_CC2OF_Msk, (0x1 << TIM_SR_CC2OF_Pos) /* 0x00000400 */
.equiv TIM_SR_CC2OF,     TIM_SR_CC2OF_Msk          /*Capture/Compare 2 Overcapture Flag */
.equiv TIM_SR_CC3OF_Pos, (11)
.equiv TIM_SR_CC3OF_Msk, (0x1 << TIM_SR_CC3OF_Pos) /* 0x00000800 */
.equiv TIM_SR_CC3OF,     TIM_SR_CC3OF_Msk          /*Capture/Compare 3 Overcapture Flag */
.equiv TIM_SR_CC4OF_Pos, (12)
.equiv TIM_SR_CC4OF_Msk, (0x1 << TIM_SR_CC4OF_Pos) /* 0x00001000 */
.equiv TIM_SR_CC4OF,     TIM_SR_CC4OF_Msk          /*Capture/Compare 4 Overcapture Flag */

/*******************  Bit definition for TIM_EGR register  *******************/
.equiv TIM_EGR_UG_Pos,   (0)
.equiv TIM_EGR_UG_Msk,   (0x1 << TIM_EGR_UG_Pos)   /* 0x00000001 */
.equiv TIM_EGR_UG,       TIM_EGR_UG_Msk            /*Update Generation */
.equiv TIM_EGR_CC1G_Pos, (1)
.equiv TIM_EGR_CC1G_Msk, (0x1 << TIM_EGR_CC1G_Pos) /* 0x00000002 */
.equiv TIM_EGR_CC1G,     TIM_EGR_CC1G_Msk          /*Capture/Compare 1 Generation */
.equiv TIM_EGR_CC2G_Pos, (2)
.equiv TIM_EGR_CC2G_Msk, (0x1 << TIM_EGR_CC2G_Pos) /* 0x00000004 */
.equiv TIM_EGR_CC2G,     TIM_EGR_CC2G_Msk          /*Capture/Compare 2 Generation */
.equiv TIM_EGR_CC3G_Pos, (3)
.equiv TIM_EGR_CC3G_Msk, (0x1 << TIM_EGR_CC3G_Pos) /* 0x00000008 */
.equiv TIM_EGR_CC3G,     TIM_EGR_CC3G_Msk          /*Capture/Compare 3 Generation */
.equiv TIM_EGR_CC4G_Pos, (4)
.equiv TIM_EGR_CC4G_Msk, (0x1 << TIM_EGR_CC4G_Pos) /* 0x00000010 */
.equiv TIM_EGR_CC4G,     TIM_EGR_CC4G_Msk          /*Capture/Compare 4 Generation */
.equiv TIM_EGR_COMG_Pos, (5)
.equiv TIM_EGR_COMG_Msk, (0x1 << TIM_EGR_COMG_Pos) /* 0x00000020 */
.equiv TIM_EGR_COMG,     TIM_EGR_COMG_Msk          /*Capture/Compare Control Update Generation */
.equiv TIM_EGR_TG_Pos,   (6)
.equiv TIM_EGR_TG_Msk,   (0x1 << TIM_EGR_TG_Pos)   /* 0x00000040 */
.equiv TIM_EGR_TG,       TIM_EGR_TG_Msk            /*Trigger Generation */
.equiv TIM_EGR_BG_Pos,   (7)
.equiv TIM_EGR_BG_Msk,   (0x1 << TIM_EGR_BG_Pos)   /* 0x00000080 */
.equiv TIM_EGR_BG,       TIM_EGR_BG_Msk            /*Break Generation */

/******************  Bit definition for TIM_CCMR1 register  ******************/
.equiv TIM_CCMR1_CC1S_Pos,  (0)
.equiv TIM_CCMR1_CC1S_Msk,  (0x3 << TIM_CCMR1_CC1S_Pos)  /* 0x00000003 */
.equiv TIM_CCMR1_CC1S,      TIM_CCMR1_CC1S_Msk           /*CC1S[1:0] bits (Capture/Compare 1 Selection) */
.equiv TIM_CCMR1_CC1S_0,    (0x1 << TIM_CCMR1_CC1S_Pos)  /* 0x00000001 */
.equiv TIM_CCMR1_CC1S_1,    (0x2 << TIM_CCMR1_CC1S_Pos)  /* 0x00000002 */

.equiv TIM_CCMR1_OC1FE_Pos, (2)
.equiv TIM_CCMR1_OC1FE_Msk, (0x1 << TIM_CCMR1_OC1FE_Pos) /* 0x00000004 */
.equiv TIM_CCMR1_OC1FE,     TIM_CCMR1_OC1FE_Msk          /*Output Compare 1 Fast enable */
.equiv TIM_CCMR1_OC1PE_Pos, (3)
.equiv TIM_CCMR1_OC1PE_Msk, (0x1 << TIM_CCMR1_OC1PE_Pos) /* 0x00000008 */
.equiv TIM_CCMR1_OC1PE,     TIM_CCMR1_OC1PE_Msk          /*Output Compare 1 Preload enable */

.equiv TIM_CCMR1_OC1M_Pos,  (4)
.equiv TIM_CCMR1_OC1M_Msk,  (0x7 << TIM_CCMR1_OC1M_Pos)  /* 0x00000070 */
.equiv TIM_CCMR1_OC1M,      TIM_CCMR1_OC1M_Msk           /*OC1M[2:0] bits (Output Compare 1 Mode) */
.equiv TIM_CCMR1_OC1M_0,    (0x1 << TIM_CCMR1_OC1M_Pos)  /* 0x00000010 */
.equiv TIM_CCMR1_OC1M_1,    (0x2 << TIM_CCMR1_OC1M_Pos)  /* 0x00000020 */
.equiv TIM_CCMR1_OC1M_2,    (0x4 << TIM_CCMR1_OC1M_Pos)  /* 0x00000040 */

.equiv TIM_CCMR1_OC1CE_Pos, (7)
.equiv TIM_CCMR1_OC1CE_Msk, (0x1 << TIM_CCMR1_OC1CE_Pos) /* 0x00000080 */
.equiv TIM_CCMR1_OC1CE,     TIM_CCMR1_OC1CE_Msk          /*Output Compare 1Clear Enable */

.equiv TIM_CCMR1_CC2S_Pos,  (8)
.equiv TIM_CCMR1_CC2S_Msk,  (0x3 << TIM_CCMR1_CC2S_Pos)  /* 0x00000300 */
.equiv TIM_CCMR1_CC2S,      TIM_CCMR1_CC2S_Msk           /*CC2S[1:0] bits (Capture/Compare 2 Selection) */
.equiv TIM_CCMR1_CC2S_0,    (0x1 << TIM_CCMR1_CC2S_Pos)  /* 0x00000100 */
.equiv TIM_CCMR1_CC2S_1,    (0x2 << TIM_CCMR1_CC2S_Pos)  /* 0x00000200 */

.equiv TIM_CCMR1_OC2FE_Pos, (10)
.equiv TIM_CCMR1_OC2FE_Msk, (0x1 << TIM_CCMR1_OC2FE_Pos) /* 0x00000400 */
.equiv TIM_CCMR1_OC2FE,     TIM_CCMR1_OC2FE_Msk          /*Output Compare 2 Fast enable */
.equiv TIM_CCMR1_OC2PE_Pos, (11)
.equiv TIM_CCMR1_OC2PE_Msk, (0x1 << TIM_CCMR1_OC2PE_Pos) /* 0x00000800 */
.equiv TIM_CCMR1_OC2PE,     TIM_CCMR1_OC2PE_Msk          /*Output Compare 2 Preload enable */

.equiv TIM_CCMR1_OC2M_Pos,  (12)
.equiv TIM_CCMR1_OC2M_Msk,  (0x7 << TIM_CCMR1_OC2M_Pos)  /* 0x00007000 */
.equiv TIM_CCMR1_OC2M,      TIM_CCMR1_OC2M_Msk           /*OC2M[2:0] bits (Output Compare 2 Mode) */
.equiv TIM_CCMR1_OC2M_0,    (0x1 << TIM_CCMR1_OC2M_Pos)  /* 0x00001000 */
.equiv TIM_CCMR1_OC2M_1,    (0x2 << TIM_CCMR1_OC2M_Pos)  /* 0x00002000 */
.equiv TIM_CCMR1_OC2M_2,    (0x4 << TIM_CCMR1_OC2M_Pos)  /* 0x00004000 */

.equiv TIM_CCMR1_OC2CE_Pos, (15)
.equiv TIM_CCMR1_OC2CE_Msk, (0x1 << TIM_CCMR1_OC2CE_Pos) /* 0x00008000 */
.equiv TIM_CCMR1_OC2CE,     TIM_CCMR1_OC2CE_Msk          /*Output Compare 2 Clear Enable */

/*---------------------------------------------------------------------------*/
.equiv TIM_CCMR1_IC1PSC_Pos, (2)
.equiv TIM_CCMR1_IC1PSC_Msk, (0x3 << TIM_CCMR1_IC1PSC_Pos) /* 0x0000000C */
.equiv TIM_CCMR1_IC1PSC,     TIM_CCMR1_IC1PSC_Msk          /*IC1PSC[1:0] bits (Input Capture 1 Prescaler) */
.equiv TIM_CCMR1_IC1PSC_0,   (0x1 << TIM_CCMR1_IC1PSC_Pos) /* 0x00000004 */
.equiv TIM_CCMR1_IC1PSC_1,   (0x2 << TIM_CCMR1_IC1PSC_Pos) /* 0x00000008 */

.equiv TIM_CCMR1_IC1F_Pos,   (4)
.equiv TIM_CCMR1_IC1F_Msk,   (0xF << TIM_CCMR1_IC1F_Pos)   /* 0x000000F0 */
.equiv TIM_CCMR1_IC1F,       TIM_CCMR1_IC1F_Msk            /*IC1F[3:0] bits (Input Capture 1 Filter) */
.equiv TIM_CCMR1_IC1F_0,     (0x1 << TIM_CCMR1_IC1F_Pos)   /* 0x00000010 */
.equiv TIM_CCMR1_IC1F_1,     (0x2 << TIM_CCMR1_IC1F_Pos)   /* 0x00000020 */
.equiv TIM_CCMR1_IC1F_2,     (0x4 << TIM_CCMR1_IC1F_Pos)   /* 0x00000040 */
.equiv TIM_CCMR1_IC1F_3,     (0x8 << TIM_CCMR1_IC1F_Pos)   /* 0x00000080 */

.equiv TIM_CCMR1_IC2PSC_Pos, (10)
.equiv TIM_CCMR1_IC2PSC_Msk, (0x3 << TIM_CCMR1_IC2PSC_Pos) /* 0x00000C00 */
.equiv TIM_CCMR1_IC2PSC,     TIM_CCMR1_IC2PSC_Msk          /*IC2PSC[1:0] bits (Input Capture 2 Prescaler) */
.equiv TIM_CCMR1_IC2PSC_0,   (0x1 << TIM_CCMR1_IC2PSC_Pos) /* 0x00000400 */
.equiv TIM_CCMR1_IC2PSC_1,   (0x2 << TIM_CCMR1_IC2PSC_Pos) /* 0x00000800 */

.equiv TIM_CCMR1_IC2F_Pos,   (12)
.equiv TIM_CCMR1_IC2F_Msk,   (0xF << TIM_CCMR1_IC2F_Pos)   /* 0x0000F000 */
.equiv TIM_CCMR1_IC2F,       TIM_CCMR1_IC2F_Msk            /*IC2F[3:0] bits (Input Capture 2 Filter) */
.equiv TIM_CCMR1_IC2F_0,     (0x1 << TIM_CCMR1_IC2F_Pos)   /* 0x00001000 */
.equiv TIM_CCMR1_IC2F_1,     (0x2 << TIM_CCMR1_IC2F_Pos)   /* 0x00002000 */
.equiv TIM_CCMR1_IC2F_2,     (0x4 << TIM_CCMR1_IC2F_Pos)   /* 0x00004000 */
.equiv TIM_CCMR1_IC2F_3,     (0x8 << TIM_CCMR1_IC2F_Pos)   /* 0x00008000 */

/******************  Bit definition for TIM_CCMR2 register  ******************/
.equiv TIM_CCMR2_CC3S_Pos,  (0)
.equiv TIM_CCMR2_CC3S_Msk,  (0x3 << TIM_CCMR2_CC3S_Pos)  /* 0x00000003 */
.equiv TIM_CCMR2_CC3S,      TIM_CCMR2_CC3S_Msk           /*CC3S[1:0] bits (Capture/Compare 3 Selection) */
.equiv TIM_CCMR2_CC3S_0,    (0x1 << TIM_CCMR2_CC3S_Pos)  /* 0x00000001 */
.equiv TIM_CCMR2_CC3S_1,    (0x2 << TIM_CCMR2_CC3S_Pos)  /* 0x00000002 */

.equiv TIM_CCMR2_OC3FE_Pos, (2)
.equiv TIM_CCMR2_OC3FE_Msk, (0x1 << TIM_CCMR2_OC3FE_Pos) /* 0x00000004 */
.equiv TIM_CCMR2_OC3FE,     TIM_CCMR2_OC3FE_Msk          /*Output Compare 3 Fast enable */
.equiv TIM_CCMR2_OC3PE_Pos, (3)
.equiv TIM_CCMR2_OC3PE_Msk, (0x1 << TIM_CCMR2_OC3PE_Pos) /* 0x00000008 */
.equiv TIM_CCMR2_OC3PE,     TIM_CCMR2_OC3PE_Msk          /*Output Compare 3 Preload enable */

.equiv TIM_CCMR2_OC3M_Pos,  (4)
.equiv TIM_CCMR2_OC3M_Msk,  (0x7 << TIM_CCMR2_OC3M_Pos)  /* 0x00000070 */
.equiv TIM_CCMR2_OC3M,      TIM_CCMR2_OC3M_Msk           /*OC3M[2:0] bits (Output Compare 3 Mode) */
.equiv TIM_CCMR2_OC3M_0,    (0x1 << TIM_CCMR2_OC3M_Pos)  /* 0x00000010 */
.equiv TIM_CCMR2_OC3M_1,    (0x2 << TIM_CCMR2_OC3M_Pos)  /* 0x00000020 */
.equiv TIM_CCMR2_OC3M_2,    (0x4 << TIM_CCMR2_OC3M_Pos)  /* 0x00000040 */

.equiv TIM_CCMR2_OC3CE_Pos, (7)
.equiv TIM_CCMR2_OC3CE_Msk, (0x1 << TIM_CCMR2_OC3CE_Pos) /* 0x00000080 */
.equiv TIM_CCMR2_OC3CE,     TIM_CCMR2_OC3CE_Msk          /*Output Compare 3 Clear Enable */

.equiv TIM_CCMR2_CC4S_Pos,  (8)
.equiv TIM_CCMR2_CC4S_Msk,  (0x3 << TIM_CCMR2_CC4S_Pos)  /* 0x00000300 */
.equiv TIM_CCMR2_CC4S,      TIM_CCMR2_CC4S_Msk           /*CC4S[1:0] bits (Capture/Compare 4 Selection) */
.equiv TIM_CCMR2_CC4S_0,    (0x1 << TIM_CCMR2_CC4S_Pos)  /* 0x00000100 */
.equiv TIM_CCMR2_CC4S_1,    (0x2 << TIM_CCMR2_CC4S_Pos)  /* 0x00000200 */

.equiv TIM_CCMR2_OC4FE_Pos, (10)
.equiv TIM_CCMR2_OC4FE_Msk, (0x1 << TIM_CCMR2_OC4FE_Pos) /* 0x00000400 */
.equiv TIM_CCMR2_OC4FE,     TIM_CCMR2_OC4FE_Msk          /*Output Compare 4 Fast enable */
.equiv TIM_CCMR2_OC4PE_Pos, (11)
.equiv TIM_CCMR2_OC4PE_Msk, (0x1 << TIM_CCMR2_OC4PE_Pos) /* 0x00000800 */
.equiv TIM_CCMR2_OC4PE,     TIM_CCMR2_OC4PE_Msk          /*Output Compare 4 Preload enable */

.equiv TIM_CCMR2_OC4M_Pos,  (12)
.equiv TIM_CCMR2_OC4M_Msk,  (0x7 << TIM_CCMR2_OC4M_Pos)  /* 0x00007000 */
.equiv TIM_CCMR2_OC4M,      TIM_CCMR2_OC4M_Msk           /*OC4M[2:0] bits (Output Compare 4 Mode) */
.equiv TIM_CCMR2_OC4M_0,    (0x1 << TIM_CCMR2_OC4M_Pos)  /* 0x00001000 */
.equiv TIM_CCMR2_OC4M_1,    (0x2 << TIM_CCMR2_OC4M_Pos)  /* 0x00002000 */
.equiv TIM_CCMR2_OC4M_2,    (0x4 << TIM_CCMR2_OC4M_Pos)  /* 0x00004000 */

.equiv TIM_CCMR2_OC4CE_Pos, (15)
.equiv TIM_CCMR2_OC4CE_Msk, (0x1 << TIM_CCMR2_OC4CE_Pos) /* 0x00008000 */
.equiv TIM_CCMR2_OC4CE,     TIM_CCMR2_OC4CE_Msk          /*Output Compare 4 Clear Enable */

/*---------------------------------------------------------------------------*/
.equiv TIM_CCMR2_IC3PSC_Pos, (2)
.equiv TIM_CCMR2_IC3PSC_Msk, (0x3 << TIM_CCMR2_IC3PSC_Pos) /* 0x0000000C */
.equiv TIM_CCMR2_IC3PSC,     TIM_CCMR2_IC3PSC_Msk          /*IC3PSC[1:0] bits (Input Capture 3 Prescaler) */
.equiv TIM_CCMR2_IC3PSC_0,   (0x1 << TIM_CCMR2_IC3PSC_Pos) /* 0x00000004 */
.equiv TIM_CCMR2_IC3PSC_1,   (0x2 << TIM_CCMR2_IC3PSC_Pos) /* 0x00000008 */

.equiv TIM_CCMR2_IC3F_Pos,   (4)
.equiv TIM_CCMR2_IC3F_Msk,   (0xF << TIM_CCMR2_IC3F_Pos)   /* 0x000000F0 */
.equiv TIM_CCMR2_IC3F,       TIM_CCMR2_IC3F_Msk            /*IC3F[3:0] bits (Input Capture 3 Filter) */
.equiv TIM_CCMR2_IC3F_0,     (0x1 << TIM_CCMR2_IC3F_Pos)   /* 0x00000010 */
.equiv TIM_CCMR2_IC3F_1,     (0x2 << TIM_CCMR2_IC3F_Pos)   /* 0x00000020 */
.equiv TIM_CCMR2_IC3F_2,     (0x4 << TIM_CCMR2_IC3F_Pos)   /* 0x00000040 */
.equiv TIM_CCMR2_IC3F_3,     (0x8 << TIM_CCMR2_IC3F_Pos)   /* 0x00000080 */

.equiv TIM_CCMR2_IC4PSC_Pos, (10)
.equiv TIM_CCMR2_IC4PSC_Msk, (0x3 << TIM_CCMR2_IC4PSC_Pos) /* 0x00000C00 */
.equiv TIM_CCMR2_IC4PSC,     TIM_CCMR2_IC4PSC_Msk          /*IC4PSC[1:0] bits (Input Capture 4 Prescaler) */
.equiv TIM_CCMR2_IC4PSC_0,   (0x1 << TIM_CCMR2_IC4PSC_Pos) /* 0x00000400 */
.equiv TIM_CCMR2_IC4PSC_1,   (0x2 << TIM_CCMR2_IC4PSC_Pos) /* 0x00000800 */

.equiv TIM_CCMR2_IC4F_Pos,   (12)
.equiv TIM_CCMR2_IC4F_Msk,   (0xF << TIM_CCMR2_IC4F_Pos)   /* 0x0000F000 */
.equiv TIM_CCMR2_IC4F,       TIM_CCMR2_IC4F_Msk            /*IC4F[3:0] bits (Input Capture 4 Filter) */
.equiv TIM_CCMR2_IC4F_0,     (0x1 << TIM_CCMR2_IC4F_Pos)   /* 0x00001000 */
.equiv TIM_CCMR2_IC4F_1,     (0x2 << TIM_CCMR2_IC4F_Pos)   /* 0x00002000 */
.equiv TIM_CCMR2_IC4F_2,     (0x4 << TIM_CCMR2_IC4F_Pos)   /* 0x00004000 */
.equiv TIM_CCMR2_IC4F_3,     (0x8 << TIM_CCMR2_IC4F_Pos)   /* 0x00008000 */

/*******************  Bit definition for TIM_CCER register  ******************/
.equiv TIM_CCER_CC1E_Pos,  (0)
.equiv TIM_CCER_CC1E_Msk,  (0x1 << TIM_CCER_CC1E_Pos)  /* 0x00000001 */
.equiv TIM_CCER_CC1E,      TIM_CCER_CC1E_Msk           /*Capture/Compare 1 output enable */
.equiv TIM_CCER_CC1P_Pos,  (1)
.equiv TIM_CCER_CC1P_Msk,  (0x1 << TIM_CCER_CC1P_Pos)  /* 0x00000002 */
.equiv TIM_CCER_CC1P,      TIM_CCER_CC1P_Msk           /*Capture/Compare 1 output Polarity */
.equiv TIM_CCER_CC1NE_Pos, (2)
.equiv TIM_CCER_CC1NE_Msk, (0x1 << TIM_CCER_CC1NE_Pos) /* 0x00000004 */
.equiv TIM_CCER_CC1NE,     TIM_CCER_CC1NE_Msk          /*Capture/Compare 1 Complementary output enable */
.equiv TIM_CCER_CC1NP_Pos, (3)
.equiv TIM_CCER_CC1NP_Msk, (0x1 << TIM_CCER_CC1NP_Pos) /* 0x00000008 */
.equiv TIM_CCER_CC1NP,     TIM_CCER_CC1NP_Msk          /*Capture/Compare 1 Complementary output Polarity */
.equiv TIM_CCER_CC2E_Pos,  (4)
.equiv TIM_CCER_CC2E_Msk,  (0x1 << TIM_CCER_CC2E_Pos)  /* 0x00000010 */
.equiv TIM_CCER_CC2E,      TIM_CCER_CC2E_Msk           /*Capture/Compare 2 output enable */
.equiv TIM_CCER_CC2P_Pos,  (5)
.equiv TIM_CCER_CC2P_Msk,  (0x1 << TIM_CCER_CC2P_Pos)  /* 0x00000020 */
.equiv TIM_CCER_CC2P,      TIM_CCER_CC2P_Msk           /*Capture/Compare 2 output Polarity */
.equiv TIM_CCER_CC2NE_Pos, (6)
.equiv TIM_CCER_CC2NE_Msk, (0x1 << TIM_CCER_CC2NE_Pos) /* 0x00000040 */
.equiv TIM_CCER_CC2NE,     TIM_CCER_CC2NE_Msk          /*Capture/Compare 2 Complementary output enable */
.equiv TIM_CCER_CC2NP_Pos, (7)
.equiv TIM_CCER_CC2NP_Msk, (0x1 << TIM_CCER_CC2NP_Pos) /* 0x00000080 */
.equiv TIM_CCER_CC2NP,     TIM_CCER_CC2NP_Msk          /*Capture/Compare 2 Complementary output Polarity */
.equiv TIM_CCER_CC3E_Pos,  (8)
.equiv TIM_CCER_CC3E_Msk,  (0x1 << TIM_CCER_CC3E_Pos)  /* 0x00000100 */
.equiv TIM_CCER_CC3E,      TIM_CCER_CC3E_Msk           /*Capture/Compare 3 output enable */
.equiv TIM_CCER_CC3P_Pos,  (9)
.equiv TIM_CCER_CC3P_Msk,  (0x1 << TIM_CCER_CC3P_Pos)  /* 0x00000200 */
.equiv TIM_CCER_CC3P,      TIM_CCER_CC3P_Msk           /*Capture/Compare 3 output Polarity */
.equiv TIM_CCER_CC3NE_Pos, (10)
.equiv TIM_CCER_CC3NE_Msk, (0x1 << TIM_CCER_CC3NE_Pos) /* 0x00000400 */
.equiv TIM_CCER_CC3NE,     TIM_CCER_CC3NE_Msk          /*Capture/Compare 3 Complementary output enable */
.equiv TIM_CCER_CC3NP_Pos, (11)
.equiv TIM_CCER_CC3NP_Msk, (0x1 << TIM_CCER_CC3NP_Pos) /* 0x00000800 */
.equiv TIM_CCER_CC3NP,     TIM_CCER_CC3NP_Msk          /*Capture/Compare 3 Complementary output Polarity */
.equiv TIM_CCER_CC4E_Pos,  (12)
.equiv TIM_CCER_CC4E_Msk,  (0x1 << TIM_CCER_CC4E_Pos)  /* 0x00001000 */
.equiv TIM_CCER_CC4E,      TIM_CCER_CC4E_Msk           /*Capture/Compare 4 output enable */
.equiv TIM_CCER_CC4P_Pos,  (13)
.equiv TIM_CCER_CC4P_Msk,  (0x1 << TIM_CCER_CC4P_Pos)  /* 0x00002000 */
.equiv TIM_CCER_CC4P,      TIM_CCER_CC4P_Msk           /*Capture/Compare 4 output Polarity */
.equiv TIM_CCER_CC4NP_Pos, (15)
.equiv TIM_CCER_CC4NP_Msk, (0x1 << TIM_CCER_CC4NP_Pos) /* 0x00008000 */
.equiv TIM_CCER_CC4NP,     TIM_CCER_CC4NP_Msk          /*Capture/Compare 4 Complementary output Polarity */

/*******************  Bit definition for TIM_CNT register  *******************/
.equiv TIM_CNT_CNT_Pos, (0)
.equiv TIM_CNT_CNT_Msk, (0xFFFF << TIM_CNT_CNT_Pos) /* 0x0000FFFF */
.equiv TIM_CNT_CNT,     TIM_CNT_CNT_Msk             /*Counter Value */

/*******************  Bit definition for TIM_PSC register  *******************/
.equiv TIM_PSC_PSC_Pos, (0)
.equiv TIM_PSC_PSC_Msk, (0xFFFF << TIM_PSC_PSC_Pos) /* 0x0000FFFF */
.equiv TIM_PSC_PSC,     TIM_PSC_PSC_Msk             /*Prescaler Value */

/*******************  Bit definition for TIM_ARR register  *******************/
.equiv TIM_ARR_ARR_Pos, (0)
.equiv TIM_ARR_ARR_Msk, (0xFFFF << TIM_ARR_ARR_Pos) /* 0x0000FFFF */
.equiv TIM_ARR_ARR,     TIM_ARR_ARR_Msk             /*actual auto-reload Value */

/*******************  Bit definition for TIM_RCR register  *******************/
.equiv TIM_RCR_REP_Pos, (0)
.equiv TIM_RCR_REP_Msk, (0xFF << TIM_RCR_REP_Pos) /* 0x000000FF */
.equiv TIM_RCR_REP,     TIM_RCR_REP_Msk           /*Repetition Counter Value */

/*******************  Bit definition for TIM_CCR1 register  ******************/
.equiv TIM_CCR1_CCR1_Pos, (0)
.equiv TIM_CCR1_CCR1_Msk, (0xFFFF << TIM_CCR1_CCR1_Pos) /* 0x0000FFFF */
.equiv TIM_CCR1_CCR1,     TIM_CCR1_CCR1_Msk             /*Capture/Compare 1 Value */

/*******************  Bit definition for TIM_CCR2 register  ******************/
.equiv TIM_CCR2_CCR2_Pos, (0)
.equiv TIM_CCR2_CCR2_Msk, (0xFFFF << TIM_CCR2_CCR2_Pos) /* 0x0000FFFF */
.equiv TIM_CCR2_CCR2,     TIM_CCR2_CCR2_Msk             /*Capture/Compare 2 Value */

/*******************  Bit definition for TIM_CCR3 register  ******************/
.equiv TIM_CCR3_CCR3_Pos, (0)
.equiv TIM_CCR3_CCR3_Msk, (0xFFFF << TIM_CCR3_CCR3_Pos) /* 0x0000FFFF */
.equiv TIM_CCR3_CCR3,     TIM_CCR3_CCR3_Msk             /*Capture/Compare 3 Value */

/*******************  Bit definition for TIM_CCR4 register  ******************/
.equiv TIM_CCR4_CCR4_Pos, (0)
.equiv TIM_CCR4_CCR4_Msk, (0xFFFF << TIM_CCR4_CCR4_Pos) /* 0x0000FFFF */
.equiv TIM_CCR4_CCR4,     TIM_CCR4_CCR4_Msk             /*Capture/Compare 4 Value */

/*******************  Bit definition for TIM_BDTR register  ******************/
.equiv TIM_BDTR_DTG_Pos,  (0)
.equiv TIM_BDTR_DTG_Msk,  (0xFF << TIM_BDTR_DTG_Pos) /* 0x000000FF */
.equiv TIM_BDTR_DTG,      TIM_BDTR_DTG_Msk           /*DTG[0:7] bits (Dead-Time Generator set-up) */
.equiv TIM_BDTR_DTG_0,    (0x01 << TIM_BDTR_DTG_Pos) /* 0x00000001 */
.equiv TIM_BDTR_DTG_1,    (0x02 << TIM_BDTR_DTG_Pos) /* 0x00000002 */
.equiv TIM_BDTR_DTG_2,    (0x04 << TIM_BDTR_DTG_Pos) /* 0x00000004 */
.equiv TIM_BDTR_DTG_3,    (0x08 << TIM_BDTR_DTG_Pos) /* 0x00000008 */
.equiv TIM_BDTR_DTG_4,    (0x10 << TIM_BDTR_DTG_Pos) /* 0x00000010 */
.equiv TIM_BDTR_DTG_5,    (0x20 << TIM_BDTR_DTG_Pos) /* 0x00000020 */
.equiv TIM_BDTR_DTG_6,    (0x40 << TIM_BDTR_DTG_Pos) /* 0x00000040 */
.equiv TIM_BDTR_DTG_7,    (0x80 << TIM_BDTR_DTG_Pos) /* 0x00000080 */

.equiv TIM_BDTR_LOCK_Pos, (8)
.equiv TIM_BDTR_LOCK_Msk, (0x3 << TIM_BDTR_LOCK_Pos) /* 0x00000300 */
.equiv TIM_BDTR_LOCK,     TIM_BDTR_LOCK_Msk          /*LOCK[1:0] bits (Lock Configuration) */
.equiv TIM_BDTR_LOCK_0,   (0x1 << TIM_BDTR_LOCK_Pos) /* 0x00000100 */
.equiv TIM_BDTR_LOCK_1,   (0x2 << TIM_BDTR_LOCK_Pos) /* 0x00000200 */

.equiv TIM_BDTR_OSSI_Pos, (10)
.equiv TIM_BDTR_OSSI_Msk, (0x1 << TIM_BDTR_OSSI_Pos) /* 0x00000400 */
.equiv TIM_BDTR_OSSI,     TIM_BDTR_OSSI_Msk          /*Off-State Selection for Idle mode */
.equiv TIM_BDTR_OSSR_Pos, (11)
.equiv TIM_BDTR_OSSR_Msk, (0x1 << TIM_BDTR_OSSR_Pos) /* 0x00000800 */
.equiv TIM_BDTR_OSSR,     TIM_BDTR_OSSR_Msk          /*Off-State Selection for Run mode */
.equiv TIM_BDTR_BKE_Pos,  (12)
.equiv TIM_BDTR_BKE_Msk,  (0x1 << TIM_BDTR_BKE_Pos)  /* 0x00001000 */
.equiv TIM_BDTR_BKE,      TIM_BDTR_BKE_Msk           /*Break enable */
.equiv TIM_BDTR_BKP_Pos,  (13)
.equiv TIM_BDTR_BKP_Msk,  (0x1 << TIM_BDTR_BKP_Pos)  /* 0x00002000 */
.equiv TIM_BDTR_BKP,      TIM_BDTR_BKP_Msk           /*Break Polarity */
.equiv TIM_BDTR_AOE_Pos,  (14)
.equiv TIM_BDTR_AOE_Msk,  (0x1 << TIM_BDTR_AOE_Pos)  /* 0x00004000 */
.equiv TIM_BDTR_AOE,      TIM_BDTR_AOE_Msk           /*Automatic Output enable */
.equiv TIM_BDTR_MOE_Pos,  (15)
.equiv TIM_BDTR_MOE_Msk,  (0x1 << TIM_BDTR_MOE_Pos)  /* 0x00008000 */
.equiv TIM_BDTR_MOE,      TIM_BDTR_MOE_Msk           /*Main Output enable */

/******************************************************************************/
/*                                                                            */
/*                         Low Power Timer (LPTIM)                            */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for LPTIM_ISR register  *******************/
.equiv LPTIM_ISR_ARRM_Pos, (1)
.equiv LPTIM_ISR_ARRM_Msk, (0x1 << LPTIM_ISR_ARRM_Pos) /* 0x00000002 */
.equiv LPTIM_ISR_ARRM,     LPTIM_ISR_ARRM_Msk          /* Autoreload match */

/******************  Bit definition for LPTIM_ICR register  *******************/
.equiv LPTIM_ICR_ARRMCF_Pos, (1)
.equiv LPTIM_ICR_ARRMCF_Msk, (0x1 << LPTIM_ICR_ARRMCF_Pos) /* 0x00000002 */
.equiv LPTIM_ICR_ARRMCF,     LPTIM_ICR_ARRMCF_Msk          /* Autoreload match Clear Flag */

/******************  Bit definition for LPTIM_IER register ********************/
.equiv LPTIM_IER_ARRMIE_Pos, (1)
.equiv LPTIM_IER_ARRMIE_Msk, (0x1 << LPTIM_IER_ARRMIE_Pos) /* 0x00000002 */
.equiv LPTIM_IER_ARRMIE,     LPTIM_IER_ARRMIE_Msk          /* Autoreload match Interrupt Enable */

/******************  Bit definition for LPTIM_CFGR register *******************/
.equiv LPTIM_CFGR_PRESC_Pos,   (9)
.equiv LPTIM_CFGR_PRESC_Msk,   (0x7 << LPTIM_CFGR_PRESC_Pos)   /* 0x00000E00 */
.equiv LPTIM_CFGR_PRESC,       LPTIM_CFGR_PRESC_Msk            /* PRESC[2:0] bits (Clock prescaler) */
.equiv LPTIM_CFGR_PRESC_0,     (0x1 << LPTIM_CFGR_PRESC_Pos)   /* 0x00000200 */
.equiv LPTIM_CFGR_PRESC_1,     (0x2 << LPTIM_CFGR_PRESC_Pos)   /* 0x00000400 */
.equiv LPTIM_CFGR_PRESC_2,     (0x4 << LPTIM_CFGR_PRESC_Pos)   /* 0x00000800 */

.equiv LPTIM_CFGR_PRELOAD_Pos, (22)
.equiv LPTIM_CFGR_PRELOAD_Msk, (0x1 << LPTIM_CFGR_PRELOAD_Pos) /* 0x00400000 */
.equiv LPTIM_CFGR_PRELOAD,     LPTIM_CFGR_PRELOAD_Msk          /* Reg update mode */

/******************  Bit definition for LPTIM_CR register  ********************/
.equiv LPTIM_CR_ENABLE_Pos,  (0)
.equiv LPTIM_CR_ENABLE_Msk,  (0x1 << LPTIM_CR_ENABLE_Pos) /* 0x00000001 */
.equiv LPTIM_CR_ENABLE,      LPTIM_CR_ENABLE_Msk          /* LPTIMer enable */
.equiv LPTIM_CR_SNGSTRT_Pos, (1)
.equiv LPTIM_CR_SNGSTRT_Msk, (0x1 << LPTIM_CR_SNGSTRT_Pos)/* 0x00000002 */
.equiv LPTIM_CR_SNGSTRT,     LPTIM_CR_SNGSTRT_Msk         /* Timer start in single mode */
.equiv LPTIM_CR_RSTARE_Pos,  (4)
.equiv LPTIM_CR_RSTARE_Msk,  (0x1 << LPTIM_CR_RSTARE_Pos) /* 0x00000010 */
.equiv LPTIM_CR_RSTARE,      LPTIM_CR_RSTARE_Msk          /* Reset after read enable */

/******************  Bit definition for LPTIM_ARR register  *******************/
.equiv LPTIM_ARR_ARR_Pos, (0)
.equiv LPTIM_ARR_ARR_Msk, (0xFFFF << LPTIM_ARR_ARR_Pos) /* 0x0000FFFF */
.equiv LPTIM_ARR_ARR,     LPTIM_ARR_ARR_Msk             /* Auto reload register */

/******************  Bit definition for LPTIM_CNT register  *******************/
.equiv LPTIM_CNT_CNT_Pos, (0)
.equiv LPTIM_CNT_CNT_Msk, (0xFFFF << LPTIM_CNT_CNT_Pos) /* 0x0000FFFF */
.equiv LPTIM_CNT_CNT,     LPTIM_CNT_CNT_Msk             /* Counter register */

/******************************************************************************/
/*                                                                            */
/*                      Analog Comparators (COMP)                             */
/*                                                                            */
/******************************************************************************/
/**********************  Bit definition for COMP_CSR register  ****************/
.equiv COMP_CSR_EN_Pos,   (0)
.equiv COMP_CSR_EN_Msk,   (0x1 << COMP_CSR_EN_Pos) /* 0x00000001 */
.equiv COMP_CSR_EN,       COMP_CSR_EN_Msk          /* Comparator enable */
.equiv COMP_CSR_COMP1_EN, COMP_CSR_EN
.equiv COMP_CSR_COMP2_EN, COMP_CSR_EN

.equiv COMP_CSR_SCALER_EN_Pos, (1)
.equiv COMP_CSR_SCALER_EN_Msk, (0x1 << COMP_CSR_SCALER_EN_Pos) /* 0x00000001 */
.equiv COMP_CSR_SCALER_EN,     COMP_CSR_SCALER_EN_Msk          /* Comparator enable */

.equiv COMP_CSR_INMSEL_Pos, (4)
.equiv COMP_CSR_INMSEL_Msk, (0xF << COMP_CSR_INMSEL_Pos) /* 0x000000F0 */
.equiv COMP_CSR_INMSEL,     COMP_CSR_INMSEL_Msk          /* Comparator input minus selection */
.equiv COMP_CSR_INMSEL_0,   (0x1 << COMP_CSR_INMSEL_Pos) /* 0x00000010 */
.equiv COMP_CSR_INMSEL_1,   (0x2 << COMP_CSR_INMSEL_Pos) /* 0x00000020 */
.equiv COMP_CSR_INMSEL_2,   (0x4 << COMP_CSR_INMSEL_Pos) /* 0x00000040 */
.equiv COMP_CSR_INMSEL_3,   (0x8 << COMP_CSR_INMSEL_Pos) /* 0x00000080 */

.equiv COMP_CSR_INPSEL_Pos, (8)
.equiv COMP_CSR_INPSEL_Msk, (0x3 << COMP_CSR_INPSEL_Pos) /* 0x00000300 */
.equiv COMP_CSR_INPSEL,     COMP_CSR_INPSEL_Msk          /* Comparator plus minus selection */
.equiv COMP_CSR_INPSEL_0,   (0x1 << COMP_CSR_INPSEL_Pos) /* 0x00000100 */
.equiv COMP_CSR_INPSEL_1,   (0x2 << COMP_CSR_INPSEL_Pos) /* 0x00000200 */

.equiv COMP_CSR_WINMODE_Pos,  (11)
.equiv COMP_CSR_WINMODE_Msk,  (0x1 << COMP_CSR_WINMODE_Pos) /* 0x00000800 */
.equiv COMP_CSR_WINMODE,      COMP_CSR_WINMODE_Msk          /* Pair of comparators window mode. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */
//.equiv COMP_CSR_WINOUT_Pos,   (14)
//.equiv COMP_CSR_WINOUT_Msk,   (0x1 << COMP_CSR_WINOUT_Pos)  /* 0x00004000 */
//.equiv COMP_CSR_WINOUT,       COMP_CSR_WINOUT_Msk           /* Pair of comparators window output level. Bit intended to be used with COMP common instance (COMP_Common_TypeDef) */

.equiv COMP_CSR_POLARITY_Pos, (15)
.equiv COMP_CSR_POLARITY_Msk, (0x1 << COMP_CSR_POLARITY_Pos) /* 0x00008000 */
.equiv COMP_CSR_POLARITY,     COMP_CSR_POLARITY_Msk          /* Comparator output polarity */

.equiv COMP_CSR_HYST_Pos, (16)
.equiv COMP_CSR_HYST_Msk, (0x1 << COMP_CSR_HYST_Pos) /* 0x00010000 */
.equiv COMP_CSR_HYST,     COMP_CSR_HYST_Msk          /* Comparator hysteresis enable */

.equiv COMP_CSR_PWRMODE_Pos, (18)
.equiv COMP_CSR_PWRMODE_Msk, (0x3 << COMP_CSR_PWRMODE_Pos) /* 0x000C0000 */
.equiv COMP_CSR_PWRMODE,     COMP_CSR_PWRMODE_Msk          /* Comparator power mode */
.equiv COMP_CSR_PWRMODE_0,   (0x1 << COMP_CSR_PWRMODE_Pos) /* 0x00040000 */
.equiv COMP_CSR_PWRMODE_1,   (0x2 << COMP_CSR_PWRMODE_Pos) /* 0x00080000 */

.equiv COMP_CSR_COMP_OUT_Pos, (30)
.equiv COMP_CSR_COMP_OUT_Msk, (0x1 << COMP_CSR_COMP_OUT_Pos) /* 0x40000000 */
.equiv COMP_CSR_COMP_OUT,     COMP_CSR_COMP_OUT_Msk

.equiv COMP_CSR_LOCK_Pos, (31)
.equiv COMP_CSR_LOCK_Msk, (0x1 << COMP_CSR_LOCK_Pos) /* 0x80000000 */
.equiv COMP_CSR_LOCK,     COMP_CSR_LOCK_Msk          /* Comparator lock */

/**********************  Bit definition for COMP_FR register  ****************/
.equiv COMP_FR_FLTEN_Pos,  (0)
.equiv COMP_FR_FLTEN_Msk,  (0x1 << COMP_FR_FLTEN_Pos)     /* 0x00000001 */
.equiv COMP_FR_FLTEN,      COMP_FR_FLTEN_Msk              /* Comparator filter enable */
.equiv COMP_FR_FLTCNT_Pos, (16)
.equiv COMP_FR_FLTCNT_Msk, (0xFFFF << COMP_FR_FLTCNT_Pos) /* 0xFFFF0000 */
.equiv COMP_FR_FLTCNT,     COMP_FR_FLTCNT_Msk             /* Comparator filter counter */

/******************************************************************************/
/*                                                                            */
/*      Universal Synchronous Asynchronous Receiver Transmitter (USART)       */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for USART_SR register  *******************/
.equiv USART_SR_PE_Pos,    (0)
.equiv USART_SR_PE_Msk,    (0x1 << USART_SR_PE_Pos)    /* 0x00000001 */
.equiv USART_SR_PE,        USART_SR_PE_Msk             /* Parity Error */
.equiv USART_SR_FE_Pos,    (1)
.equiv USART_SR_FE_Msk,    (0x1 << USART_SR_FE_Pos)    /* 0x00000002 */
.equiv USART_SR_FE,        USART_SR_FE_Msk             /* Framing Error */
.equiv USART_SR_NE_Pos,    (2)
.equiv USART_SR_NE_Msk,    (0x1 << USART_SR_NE_Pos)    /* 0x00000004 */
.equiv USART_SR_NE,        USART_SR_NE_Msk             /* Noise Error Flag */
.equiv USART_SR_ORE_Pos,   (3)
.equiv USART_SR_ORE_Msk,   (0x1 << USART_SR_ORE_Pos)   /* 0x00000008 */
.equiv USART_SR_ORE,       USART_SR_ORE_Msk            /* OverRun Error */
.equiv USART_SR_IDLE_Pos,  (4)
.equiv USART_SR_IDLE_Msk,  (0x1 << USART_SR_IDLE_Pos)  /* 0x00000010 */
.equiv USART_SR_IDLE,      USART_SR_IDLE_Msk           /* IDLE line detected */
.equiv USART_SR_RXNE_Pos,  (5)
.equiv USART_SR_RXNE_Msk,  (0x1 << USART_SR_RXNE_Pos)  /* 0x00000020 */
.equiv USART_SR_RXNE,      USART_SR_RXNE_Msk           /* Read Data Register Not Empty */
.equiv USART_SR_TC_Pos,    (6)
.equiv USART_SR_TC_Msk,    (0x1 << USART_SR_TC_Pos)    /* 0x00000040 */
.equiv USART_SR_TC,        USART_SR_TC_Msk             /* Transmission Complete */
.equiv USART_SR_TXE_Pos,   (7)
.equiv USART_SR_TXE_Msk,   (0x1 << USART_SR_TXE_Pos)   /* 0x00000080 */
.equiv USART_SR_TXE,       USART_SR_TXE_Msk            /* Transmit Data Register Empty */
.equiv USART_SR_CTS_Pos,   (9)
.equiv USART_SR_CTS_Msk,   (0x1 << USART_SR_CTS_Pos)   /* 0x00000200 */
.equiv USART_SR_CTS,       USART_SR_CTS_Msk            /* CTS Flag */
.equiv USART_SR_ABRF_Pos,  (10)
.equiv USART_SR_ABRF_Msk,  (0x1 << USART_SR_ABRF_Pos)  /* 0x00000400 */
.equiv USART_SR_ABRF,      USART_SR_ABRF_Msk           /* Auto brr detection Flag */
.equiv USART_SR_ABRE_Pos,  (11)
.equiv USART_SR_ABRE_Msk,  (0x1 << USART_SR_ABRE_Pos)  /* 0x00000800 */
.equiv USART_SR_ABRE,      USART_SR_ABRE_Msk           /* Auto brr detection err Flag */
.equiv USART_SR_ABRRQ_Pos, (12)
.equiv USART_SR_ABRRQ_Msk, (0x1 << USART_SR_ABRRQ_Pos) /* 0x00001000 */
.equiv USART_SR_ABRRQ,     USART_SR_ABRRQ_Msk          /* Auto brr detection err Flag */

/*******************  Bit definition for USART_DR register  *******************/
.equiv USART_DR_DR_Pos, (0)
.equiv USART_DR_DR_Msk, (0x1FF << USART_DR_DR_Pos) /* 0x000001FF */
.equiv USART_DR_DR,     USART_DR_DR_Msk            /* Data value */

/******************  Bit definition for USART_BRR register  *******************/
.equiv USART_BRR_DIV_Fraction_Pos, (0)
.equiv USART_BRR_DIV_Fraction_Msk, (0xF << USART_BRR_DIV_Fraction_Pos)   /* 0x0000000F */
.equiv USART_BRR_DIV_Fraction,     USART_BRR_DIV_Fraction_Msk            /* Fraction of USARTDIV */
.equiv USART_BRR_DIV_Mantissa_Pos, (4)
.equiv USART_BRR_DIV_Mantissa_Msk, (0xFFF << USART_BRR_DIV_Mantissa_Pos) /* 0x0000FFF0 */
.equiv USART_BRR_DIV_Mantissa,     USART_BRR_DIV_Mantissa_Msk            /* Mantissa of USARTDIV */

/******************  Bit definition for USART_CR1 register  *******************/
.equiv USART_CR1_SBK_Pos,    (0)
.equiv USART_CR1_SBK_Msk,    (0x1 << USART_CR1_SBK_Pos)    /* 0x00000001 */
.equiv USART_CR1_SBK,        USART_CR1_SBK_Msk             /* Send Break */
.equiv USART_CR1_RWU_Pos,    (1)
.equiv USART_CR1_RWU_Msk,    (0x1 << USART_CR1_RWU_Pos)    /* 0x00000002 */
.equiv USART_CR1_RWU,        USART_CR1_RWU_Msk             /* Receiver wakeup */
.equiv USART_CR1_RE_Pos,     (2)
.equiv USART_CR1_RE_Msk,     (0x1 << USART_CR1_RE_Pos)     /* 0x00000004 */
.equiv USART_CR1_RE,         USART_CR1_RE_Msk              /* Receiver Enable */
.equiv USART_CR1_TE_Pos,     (3)
.equiv USART_CR1_TE_Msk,     (0x1 << USART_CR1_TE_Pos)     /* 0x00000008 */
.equiv USART_CR1_TE,         USART_CR1_TE_Msk              /* Transmitter Enable */
.equiv USART_CR1_IDLEIE_Pos, (4)
.equiv USART_CR1_IDLEIE_Msk, (0x1 << USART_CR1_IDLEIE_Pos) /* 0x00000010 */
.equiv USART_CR1_IDLEIE,     USART_CR1_IDLEIE_Msk          /* IDLE Interrupt Enable */
.equiv USART_CR1_RXNEIE_Pos, (5)
.equiv USART_CR1_RXNEIE_Msk, (0x1 << USART_CR1_RXNEIE_Pos) /* 0x00000020 */
.equiv USART_CR1_RXNEIE,     USART_CR1_RXNEIE_Msk          /* RXNE Interrupt Enable */
.equiv USART_CR1_TCIE_Pos,   (6)
.equiv USART_CR1_TCIE_Msk,   (0x1 << USART_CR1_TCIE_Pos)   /* 0x00000040 */
.equiv USART_CR1_TCIE,       USART_CR1_TCIE_Msk            /* Transmission Complete Interrupt Enable */
.equiv USART_CR1_TXEIE_Pos,  (7)
.equiv USART_CR1_TXEIE_Msk,  (0x1 << USART_CR1_TXEIE_Pos)  /* 0x00000080 */
.equiv USART_CR1_TXEIE,      USART_CR1_TXEIE_Msk           /* des TXEIE  */
.equiv USART_CR1_PEIE_Pos,   (8)
.equiv USART_CR1_PEIE_Msk,   (0x1 << USART_CR1_PEIE_Pos)   /* 0x00000100 */
.equiv USART_CR1_PEIE,       USART_CR1_PEIE_Msk            /* des PEIE */
.equiv USART_CR1_PS_Pos,     (9)
.equiv USART_CR1_PS_Msk,     (0x1 << USART_CR1_PS_Pos)     /* 0x00000200 */
.equiv USART_CR1_PS,         USART_CR1_PS_Msk              /* Parity Selection */
.equiv USART_CR1_PCE_Pos,    (10)
.equiv USART_CR1_PCE_Msk,    (0x1 << USART_CR1_PCE_Pos)    /* 0x00000400 */
.equiv USART_CR1_PCE,        USART_CR1_PCE_Msk             /* Parity Control Enable */
.equiv USART_CR1_WAKE_Pos,   (11)
.equiv USART_CR1_WAKE_Msk,   (0x1 << USART_CR1_WAKE_Pos)   /* 0x00000800 */
.equiv USART_CR1_WAKE,       USART_CR1_WAKE_Msk            /* Wakeup method */
.equiv USART_CR1_M_Pos,      (12)
.equiv USART_CR1_M_Msk,      (0x1 << USART_CR1_M_Pos)      /* 0x00001000 */
.equiv USART_CR1_M,          USART_CR1_M_Msk               /* Word length */
.equiv USART_CR1_UE_Pos,     (13)
.equiv USART_CR1_UE_Msk,     (0x1 << USART_CR1_UE_Pos)     /* 0x00002000 */
.equiv USART_CR1_UE,         USART_CR1_UE_Msk              /* USART Enable */

/******************  Bit definition for USART_CR2 register  *******************/
.equiv USART_CR2_ADD_Pos,   (0)
.equiv USART_CR2_ADD_Msk,   (0xF << USART_CR2_ADD_Pos)  /* 0x0000000F */
.equiv USART_CR2_ADD,       USART_CR2_ADD_Msk           /* Address of the USART node */
.equiv USART_CR2_LBCL_Pos,  (8)
.equiv USART_CR2_LBCL_Msk,  (0x1 << USART_CR2_LBCL_Pos) /* 0x00000100 */
.equiv USART_CR2_LBCL,      USART_CR2_LBCL_Msk          /* Last Bit Clock pulse */
.equiv USART_CR2_CPHA_Pos,  (9)
.equiv USART_CR2_CPHA_Msk,  (0x1 << USART_CR2_CPHA_Pos) /* 0x00000200 */
.equiv USART_CR2_CPHA,      USART_CR2_CPHA_Msk          /* Clock Phase */
.equiv USART_CR2_CPOL_Pos,  (10)
.equiv USART_CR2_CPOL_Msk,  (0x1 << USART_CR2_CPOL_Pos) /* 0x00000400 */
.equiv USART_CR2_CPOL,      USART_CR2_CPOL_Msk          /* Clock Polarity */
.equiv USART_CR2_CLKEN_Pos, (11)
.equiv USART_CR2_CLKEN_Msk, (0x1 << USART_CR2_CLKEN_Pos)/* 0x00000800 */
.equiv USART_CR2_CLKEN,     USART_CR2_CLKEN_Msk         /* Clock Enable */
.equiv USART_CR2_STOP_Pos,  (13)
.equiv USART_CR2_STOP_Msk,  (0x1 << USART_CR2_STOP_Pos) /* 0x00002000 */
.equiv USART_CR2_STOP,      USART_CR2_STOP_Msk          /* STOP bits*/

/******************  Bit definition for USART_CR3 register  *******************/
.equiv USART_CR3_EIE_Pos,     (0)
.equiv USART_CR3_EIE_Msk,     (0x1 << USART_CR3_EIE_Pos)   /* 0x00000001 */
.equiv USART_CR3_EIE,         USART_CR3_EIE_Msk            /* Error Interrupt Enable */
.equiv USART_CR3_HDSEL_Pos,   (3)
.equiv USART_CR3_HDSEL_Msk,   (0x1 << USART_CR3_HDSEL_Pos) /* 0x00000008 */
.equiv USART_CR3_HDSEL,       USART_CR3_HDSEL_Msk          /* Half-Duplex Selection */
.equiv USART_CR3_RTSE_Pos,    (8)
.equiv USART_CR3_RTSE_Msk,    (0x1 << USART_CR3_RTSE_Pos)  /* 0x00000100 */
.equiv USART_CR3_RTSE,        USART_CR3_RTSE_Msk           /* RTS Enable */
.equiv USART_CR3_CTSE_Pos,    (9)
.equiv USART_CR3_CTSE_Msk,    (0x1 << USART_CR3_CTSE_Pos)  /* 0x00000200 */
.equiv USART_CR3_CTSE,        USART_CR3_CTSE_Msk           /* CTS Enable */
.equiv USART_CR3_CTSIE_Pos,   (10)
.equiv USART_CR3_CTSIE_Msk,   (0x1 << USART_CR3_CTSIE_Pos) /* 0x00000400 */
.equiv USART_CR3_CTSIE,       USART_CR3_CTSIE_Msk          /* CTS Interrupt Enable */
.equiv USART_CR3_OVER8_Pos,   (11)
.equiv USART_CR3_OVER8_Msk,   (0x1 << USART_CR3_OVER8_Pos)
.equiv USART_CR3_OVER8,       USART_CR3_OVER8_Msk
.equiv USART_CR3_ABREN_Pos,   (12)
.equiv USART_CR3_ABREN_Msk,   (0x1 << USART_CR3_ABREN_Pos)
.equiv USART_CR3_ABREN,       USART_CR3_ABREN_Msk
.equiv USART_CR3_ABRMODE_Pos, (13)
.equiv USART_CR3_ABRMODE_Msk, (0x3 << USART_CR3_ABRMODE_Pos)
.equiv USART_CR3_ABRMODE,      USART_CR3_ABRMODE_Msk
.equiv USART_CR3_ABRMODE_0,   (0x1 << USART_CR3_ABRMODE_Pos)
.equiv USART_CR3_ABRMODE_1,   (0x2 << USART_CR3_ABRMODE_Pos)

/******************************************************************************/
/*                                                                            */
/*      Cortex M0+ Core                                                       */
/*                                                                            */
/******************************************************************************/
/* APSR Register Definitions */
.equiv APSR_N_Pos, 31                 /* APSR: N Position */
.equiv APSR_N_Msk, (1 << APSR_N_Pos)  /* APSR: N Mask */
.equiv APSR_Z_Pos, 30                 /* APSR: Z Position */
.equiv APSR_Z_Msk, (1 << APSR_Z_Pos)  /* APSR: Z Mask */
.equiv APSR_C_Pos, 29                 /* APSR: C Position */
.equiv APSR_C_Msk, (1 << APSR_C_Pos)  /* APSR: C Mask */
.equiv APSR_V_Pos, 28                 /* APSR: V Position */
.equiv APSR_V_Msk, (1 << APSR_V_Pos)  /* APSR: V Mask */

/* IPSR Register Definitions */
.equiv IPSR_ISR_Pos,  0                       /* IPSR: ISR Position */
.equiv IPSR_ISR_Msk, (0x1FF << IPSR_ISR_Pos)  /* IPSR: ISR Mask */

/* xPSR Register Definitions */
.equiv xPSR_N_Pos,   31                       /* xPSR: N Position */
.equiv xPSR_N_Msk,   (1 << xPSR_N_Pos)        /* xPSR: N Mask */
.equiv xPSR_Z_Pos,   30                       /* xPSR: Z Position */
.equiv xPSR_Z_Msk,   (1 << xPSR_Z_Pos)        /* xPSR: Z Mask */
.equiv xPSR_C_Pos,   29                       /* xPSR: C Position */
.equiv xPSR_C_Msk,   (1 << xPSR_C_Pos)        /* xPSR: C Mask */
.equiv xPSR_V_Pos,   28                       /* xPSR: V Position */
.equiv xPSR_V_Msk,   (1 << xPSR_V_Pos)        /* xPSR: V Mask */
.equiv xPSR_T_Pos,   24                       /* xPSR: T Position */
.equiv xPSR_T_Msk,   (1 << xPSR_T_Pos)        /* xPSR: T Mask */
.equiv xPSR_ISR_Pos,  0                       /* xPSR: ISR Position */
.equiv xPSR_ISR_Msk, (0x1FF << xPSR_ISR_Pos)  /* xPSR: ISR Mask */

/* CONTROL Register Definitions */
.equiv CONTROL_SPSEL_Pos,  1                        /* CONTROL: SPSEL Position */
.equiv CONTROL_SPSEL_Msk, (1 << CONTROL_SPSEL_Pos)  /* CONTROL: SPSEL Mask */
.equiv CONTROL_nPRIV_Pos,  0                        /* CONTROL: nPRIV Position */
.equiv CONTROL_nPRIV_Msk, (1 << CONTROL_nPRIV_Pos)  /* CONTROL: nPRIV Mask */

/******************************************************************************/
/*                                                                            */
/*      System Control Block (SCB)                                            */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for SCB_CPUID register  *******************/

.equiv SCB_CPUID_IMPLEMENTER_Pos,  24                                  /* SCB CPUID: IMPLEMENTER Position */
.equiv SCB_CPUID_IMPLEMENTER_Msk,  (0xFF << SCB_CPUID_IMPLEMENTER_Pos) /* SCB CPUID: IMPLEMENTER Mask */

.equiv SCB_CPUID_VARIANT_Pos,      20                                  /* SCB CPUID: VARIANT Position */
.equiv SCB_CPUID_VARIANT_Msk,      (0xF << SCB_CPUID_VARIANT_Pos)      /* SCB CPUID: VARIANT Mask */

.equiv SCB_CPUID_ARCHITECTURE_Pos, 16                                  /* SCB CPUID: ARCHITECTURE Position */
.equiv SCB_CPUID_ARCHITECTURE_Msk, (0xF << SCB_CPUID_ARCHITECTURE_Pos) /* SCB CPUID: ARCHITECTURE Mask */

.equiv SCB_CPUID_PARTNO_Pos,        4                                  /* SCB CPUID: PARTNO Position */
.equiv SCB_CPUID_PARTNO_Msk,       (0xFFF << SCB_CPUID_PARTNO_Pos)     /* SCB CPUID: PARTNO Mask */

.equiv SCB_CPUID_REVISION_Pos,      0                                  /* SCB CPUID: REVISION Position */
.equiv SCB_CPUID_REVISION_Msk,     (0xF << SCB_CPUID_REVISION_Pos)     /* SCB CPUID: REVISION Mask */

/******************  Bit definition for SCB_ICSR register  ********************/

.equiv SCB_ICSR_NMIPENDSET_Pos,  31                                  /* SCB ICSR: NMIPENDSET Position */
.equiv SCB_ICSR_NMIPENDSET_Msk,  (1 << SCB_ICSR_NMIPENDSET_Pos)      /* SCB ICSR: NMIPENDSET Mask */

.equiv SCB_ICSR_PENDSVSET_Pos,   28                                  /* SCB ICSR: PENDSVSET Position */
.equiv SCB_ICSR_PENDSVSET_Msk,   (1 << SCB_ICSR_PENDSVSET_Pos)       /* SCB ICSR: PENDSVSET Mask */

.equiv SCB_ICSR_PENDSVCLR_Pos,   27                                  /* SCB ICSR: PENDSVCLR Position */
.equiv SCB_ICSR_PENDSVCLR_Msk,   (1 << SCB_ICSR_PENDSVCLR_Pos)       /* SCB ICSR: PENDSVCLR Mask */

.equiv SCB_ICSR_PENDSTSET_Pos,   26                                  /* SCB ICSR: PENDSTSET Position */
.equiv SCB_ICSR_PENDSTSET_Msk,   (1 << SCB_ICSR_PENDSTSET_Pos)       /* SCB ICSR: PENDSTSET Mask */

.equiv SCB_ICSR_PENDSTCLR_Pos,   25                                  /* SCB ICSR: PENDSTCLR Position */
.equiv SCB_ICSR_PENDSTCLR_Msk,   (1 << SCB_ICSR_PENDSTCLR_Pos)       /* SCB ICSR: PENDSTCLR Mask */

.equiv SCB_ICSR_ISRPREEMPT_Pos,  23                                  /* SCB ICSR: ISRPREEMPT Position */
.equiv SCB_ICSR_ISRPREEMPT_Msk,  (1 << SCB_ICSR_ISRPREEMPT_Pos)      /* SCB ICSR: ISRPREEMPT Mask */

.equiv SCB_ICSR_ISRPENDING_Pos,  22                                  /* SCB ICSR: ISRPENDING Position */
.equiv SCB_ICSR_ISRPENDING_Msk,  (1 << SCB_ICSR_ISRPENDING_Pos)      /* SCB ICSR: ISRPENDING Mask */

.equiv SCB_ICSR_VECTPENDING_Pos, 12                                  /* SCB ICSR: VECTPENDING Position */
.equiv SCB_ICSR_VECTPENDING_Msk, (0x1FF << SCB_ICSR_VECTPENDING_Pos) /* SCB ICSR: VECTPENDING Mask */

.equiv SCB_ICSR_VECTACTIVE_Pos,   0                                  /* SCB ICSR: VECTACTIVE Position */
.equiv SCB_ICSR_VECTACTIVE_Msk,  (0x1FF << SCB_ICSR_VECTACTIVE_Pos)  /* SCB ICSR: VECTACTIVE Mask */

/******************  Bit definition for SCB_VTOR register  ********************/
.equiv SCB_VTOR_TBLOFF_Pos,  8                                /* SCB VTOR: TBLOFF Position */
.equiv SCB_VTOR_TBLOFF_Msk, (0xFFFFFF << SCB_VTOR_TBLOFF_Pos) /* SCB VTOR: TBLOFF Mask */

/******************  Bit definition for SCB_AIRCR register  *******************/
.equiv SCB_AIRCR_VECTKEY_Pos,       16                                    /* SCB AIRCR: VECTKEY Position */
.equiv SCB_AIRCR_VECTKEY_Msk,       (0xFFFF << SCB_AIRCR_VECTKEY_Pos)     /* SCB AIRCR: VECTKEY Mask */

.equiv SCB_AIRCR_VECTKEYSTAT_Pos,   16                                    /* SCB AIRCR: VECTKEYSTAT Position */
.equiv SCB_AIRCR_VECTKEYSTAT_Msk,   (0xFFFF << SCB_AIRCR_VECTKEYSTAT_Pos) /* SCB AIRCR: VECTKEYSTAT Mask */

.equiv SCB_AIRCR_ENDIANESS_Pos,     15                                    /* SCB AIRCR: ENDIANESS Position */
.equiv SCB_AIRCR_ENDIANESS_Msk,     (1 << SCB_AIRCR_ENDIANESS_Pos)        /* SCB AIRCR: ENDIANESS Mask */

.equiv SCB_AIRCR_SYSRESETREQ_Pos,    2                                    /* SCB AIRCR: SYSRESETREQ Position */
.equiv SCB_AIRCR_SYSRESETREQ_Msk,   (1 << SCB_AIRCR_SYSRESETREQ_Pos)      /* SCB AIRCR: SYSRESETREQ Mask */

.equiv SCB_AIRCR_VECTCLRACTIVE_Pos,  1                                    /* SCB AIRCR: VECTCLRACTIVE Position */
.equiv SCB_AIRCR_VECTCLRACTIVE_Msk, (1 << SCB_AIRCR_VECTCLRACTIVE_Pos)    /* SCB AIRCR: VECTCLRACTIVE Mask */

/******************  Bit definition SCB_SCR register  *********************/
.equiv SCB_SCR_SEVONPEND_Pos,    4                             /* SCB SCR: SEVONPEND Position */
.equiv SCB_SCR_SEVONPEND_Msk,   (1 << SCB_SCR_SEVONPEND_Pos)   /* SCB SCR: SEVONPEND Mask */

.equiv SCB_SCR_SLEEPDEEP_Pos,    2                             /* SCB SCR: SLEEPDEEP Position */
.equiv SCB_SCR_SLEEPDEEP_Msk,   (1 << SCB_SCR_SLEEPDEEP_Pos)   /* SCB SCR: SLEEPDEEP Mask */

.equiv SCB_SCR_SLEEPONEXIT_Pos,  1                             /* SCB SCR: SLEEPONEXIT Position */
.equiv SCB_SCR_SLEEPONEXIT_Msk, (1 << SCB_SCR_SLEEPONEXIT_Pos) /* SCB SCR: SLEEPONEXIT Mask */

/******************  Bit definition SCB_CCR register  *********************/
.equiv SCB_CCR_STKALIGN_Pos,     9                             /* SCB CCR: STKALIGN Position */
.equiv SCB_CCR_STKALIGN_Msk,    (1 << SCB_CCR_STKALIGN_Pos)    /* SCB CCR: STKALIGN Mask */

.equiv SCB_CCR_UNALIGN_TRP_Pos,  3                             /* SCB CCR: UNALIGN_TRP Position */
.equiv SCB_CCR_UNALIGN_TRP_Msk, (1 << SCB_CCR_UNALIGN_TRP_Pos) /* SCB CCR: UNALIGN_TRP Mask */

/******************  Bit definition SCB_SHCSR register  *******************/
.equiv SCB_SHCSR_SVCALLPENDED_Pos, 15                                /* SCB SHCSR: SVCALLPENDED Position */
.equiv SCB_SHCSR_SVCALLPENDED_Msk, (1 << SCB_SHCSR_SVCALLPENDED_Pos) /* SCB SHCSR: SVCALLPENDED Mask */

/******************************************************************************/
/*                                                                            */
/*      System Timer (SysTick)                                                */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for SysTick_CTRL register  ****************/
.equiv SysTick_CTRL_COUNTFLAG_Pos, 16                                /* SysTick CTRL: COUNTFLAG Position */
.equiv SysTick_CTRL_COUNTFLAG_Msk, (1 << SysTick_CTRL_COUNTFLAG_Pos) /* SysTick CTRL: COUNTFLAG Mask */

.equiv SysTick_CTRL_CLKSOURCE_Pos,  2                                /* SysTick CTRL: CLKSOURCE Position */
.equiv SysTick_CTRL_CLKSOURCE_Msk, (1 << SysTick_CTRL_CLKSOURCE_Pos) /* SysTick CTRL: CLKSOURCE Mask */

.equiv SysTick_CTRL_TICKINT_Pos,    1                                /* SysTick CTRL: TICKINT Position */
.equiv SysTick_CTRL_TICKINT_Msk,   (1 << SysTick_CTRL_TICKINT_Pos)   /* SysTick CTRL: TICKINT Mask */

.equiv SysTick_CTRL_ENABLE_Pos,     0                                /* SysTick CTRL: ENABLE Position */
.equiv SysTick_CTRL_ENABLE_Msk,    (1 << SysTick_CTRL_ENABLE_Pos)    /* SysTick CTRL: ENABLE Mask */

/******************  Bit definition, for SysTick_LOAD register  ****************/
.equiv SysTick_LOAD_RELOAD_Pos,  0                                    /* SysTick LOAD: RELOAD Position */
.equiv SysTick_LOAD_RELOAD_Msk, (0xFFFFFF << SysTick_LOAD_RELOAD_Pos) /* SysTick LOAD: RELOAD Mask */

/******************  Bit definition, for SysTick_VAL register  *****************/
.equiv SysTick_VAL_CURRENT_Pos,  0                                    /* SysTick VAL: CURRENT Position */
.equiv SysTick_VAL_CURRENT_Msk, (0xFFFFFF << SysTick_VAL_CURRENT_Pos) /* SysTick VAL: CURRENT Mask */

/******************  Bit definition, for SysTick_CALIB register  ***************/
.equiv SysTick_CALIB_NOREF_Pos, 31                                    /* SysTick CALIB: NOREF Position */
.equiv SysTick_CALIB_NOREF_Msk, (1 << SysTick_CALIB_NOREF_Pos)        /* SysTick CALIB: NOREF Mask */

.equiv SysTick_CALIB_SKEW_Pos,  30                                    /* SysTick CALIB: SKEW Position */
.equiv SysTick_CALIB_SKEW_Msk,  (1 << SysTick_CALIB_SKEW_Pos)         /* SysTick CALIB: SKEW Mask */

.equiv SysTick_CALIB_TENMS_Pos,  0                                    /* SysTick CALIB: TENMS Position */
.equiv SysTick_CALIB_TENMS_Msk, (0xFFFFFF << SysTick_CALIB_TENMS_Pos) /* SysTick CALIB: TENMS Mask */

.list
