#!/usr/bin/perl -w

if (scalar(@ARGV) != 1) { die "Usage: $0 <filename.raw>\n"; }
open IN, $ARGV[0] or die "Can't open input file: $!\n";
$outfile = $ARGV[0];
$outfile =~ s/\.raw$/\.s/;
if ($outfile eq $ARGV[0]) { $outfile = $ARGV[0] . ".s"; }
open OUT, ">$outfile" or die "Can't open output file: $!\n";
$n = 0;
do {
	if (read(IN, $b, 1) != 1) { die "Read error.\n"; }
	$b = unpack('C', $b);
	if ($n % 16 == 0) { print OUT ".byte "; }
	printf OUT "0x%02x", $b;
	if (++$n % 16 == 0) { print OUT "\n"; } else { print OUT "," };
} while (!eof(IN));

if ($n % 16 == 0) { print OUT ".byte "; }
print OUT "0x00\n";



close IN;
close OUT;