@ Main table of animations to play
@ 
@ LED Numbers:
@                                   8
@                              9          7
@                          10
@                                             6   5
@                                     34                4
@                        11                         3
@                                              2
@                          12
@                                            1
@   17   16
@            15         13   33    32   31
@                 14                         30
@    18
@                                              29
@      19
@                                              28
@          20
@                                          27
@             21                       26
@                  22   23   24   25
@ 
@ Animation Commands:
@ 
@   ALLOFF - Clear all LEDs (set to brightness 0). Alias for FILL(0, 6, 0).
@ 
@   LED led, brt - Sets single LED  number 'led' to brightness 'brt'.
@                  Alias for FILL(led, 0, brt).
@ 
@   FILL led, n, brt - Fill a stretch of n LEDs starting with LED number 'led'
@                      with the brightness 'brt'. If the stretch extends
@                      beyond the last LED (N_LED), it wraps around to the first
@                      LED (1).
@                      Valid range: 'led' from 1 to N_LED,
@                                   'n'   from 1 to N_LED,
@                                   'brt' from 0 to 7.
@ 
@   ROTATE n - Rotate LED framebuffer by 'n' LEDs in the direction of
@              increasing LED numbers. For 'n' = 1, the previous value of LED 1
@              moves to to LED 2, the previous value of LED 2 moves to LED 3
@              and so on, and the previous value for LED N_LED moves to LED 1.
@              To rotate in the other direction, use very high values (e.g.
@              'n' = N_LED-1 rotates one step in the opposite direction). For
@              convenience, negative values can also be used ('n' = -1 has the
@              same effect as 'n' = N_LED-1).
@              Valid range: 'n' from 1 to N_LED-1 or from -1 to -(N_LED-1).
@ 
@   FADE n - Fade all LEDs up (n > 0) or down (n < 0) by the same number of
@            steps. If an LED reaches its minimum or maximum brightness, the
@            fading effect is clipped (no wrapping).
@ 
@   DELAY t - Insert a delay of 't' milliseconds. 't' is internally rounded to
@             a multiple of 10. The maximum is 2.55 seconds, for longer delays
@             two or more successive delay instructions or even a repeat block
@             with only a single delay instruction inside can be used.
@             This command also updates the LEDs with any changes done by
@             other commands since the previous "delay" command.
@             Valid range: 't' from 10 to 2550 in multiples of 10.
@ 
@   REPEAT n - Repeat the following block (until REPEAT_END) n times. Repeat
@              blocks may be nested (make sure enough stack is available for
@              nesting).
@              Valid range: n from 1 to 255.
@ 
@   REPEAT_END - Marks the end of a repeat block.
@ 
@   ANI_END - End of the animation table. Animation will continue from the
@             top of the table when this instruction is encountered.
@ 
@ Every command requires two bytes of ROM.

	ALLOFF
	
	REPEAT 5
	  .include "animations/worm.cm0.s"
	REPEAT_END
	
	REPEAT 7
	  .include "animations/flash.cm0.s"
	REPEAT_END
	
	REPEAT 3
	  .include "animations/worm_long.cm0.s"
	REPEAT_END
	
	.include "animations/alternating.cm0.s"
	
	REPEAT 5
	  .include "animations/worm_reverse.cm0.s"
	REPEAT_END
	
	REPEAT 3
	  .include "animations/scan_down.cm0.s"
	REPEAT_END
	
	ANI_END
